/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Takes a SAM/BAM/CRAM file and separates all the reads into one output file per library name.  Reads that do not have a read group specified or whose read group does not have a library name are written to a file called 'unknown.' The format (SAM/BAM/CRAM) of the  output files matches that of the input file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar SplitSamByLibrary <br />      I=input_reads.bam <br />      O=/output/directory/ <br /></pre>", oneLineSummary="Splits a SAM/BAM/CRAM file into individual files by library", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class SplitSamByLibrary
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Splits a SAM/BAM/CRAM file into individual files by library";
    static final String USAGE_DETAILS = "Takes a SAM/BAM/CRAM file and separates all the reads into one output file per library name.  Reads that do not have a read group specified or whose read group does not have a library name are written to a file called 'unknown.' The format (SAM/BAM/CRAM) of the  output files matches that of the input file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar SplitSamByLibrary <br />      I=input_reads.bam <br />      O=/output/directory/ <br /></pre>";
    @Argument(shortName="I", doc="The SAM, BAM of CRAM file to be split. ")
    public File INPUT;
    @Argument(shortName="O", doc="The directory where the per-library output files should be written (defaults to the current directory). ", optional=true)
    public File OUTPUT = new File(".").getAbsoluteFile();
    private static final Log log = Log.getInstance(SplitSamByLibrary.class);
    public static final int NO_LIBRARIES_SPECIFIED_IN_HEADER = 2;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertDirectoryIsWritable((File)this.OUTPUT);
        SAMFileWriter unknown = null;
        HashMap<String, SAMFileWriter> libraryToWriter = new HashMap<String, SAMFileWriter>();
        try (SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);){
            String lib;
            HashMap libraryToRg222 = new HashMap();
            SAMFileWriterFactory factory = new SAMFileWriterFactory();
            String extension = "." + reader.type().fileExtension();
            SAMFileHeader unknownHeader = reader.getFileHeader().clone();
            unknownHeader.setReadGroups(new ArrayList());
            for (SAMReadGroupRecord sAMReadGroupRecord : reader.getFileHeader().getReadGroups()) {
                lib = sAMReadGroupRecord.getLibrary();
                if (lib != null) {
                    if (!libraryToRg222.containsKey(lib)) {
                        libraryToRg222.put(lib, new ArrayList());
                    }
                    ((List)libraryToRg222.get(lib)).add(sAMReadGroupRecord);
                    continue;
                }
                unknownHeader.addReadGroup(sAMReadGroupRecord);
            }
            if (libraryToRg222.isEmpty()) {
                log.error(new Object[]{"No individual libraries are specified in the header of " + this.INPUT.getAbsolutePath()});
                int n = 2;
                return n;
            }
            for (Map.Entry entry : libraryToRg222.entrySet()) {
                lib = (String)entry.getKey();
                SAMFileHeader header = reader.getFileHeader().clone();
                header.setReadGroups((List)entry.getValue());
                libraryToWriter.put(lib, factory.makeWriter(header, true, new File(this.OUTPUT, IOUtil.makeFileNameSafe((String)lib) + extension), this.REFERENCE_SEQUENCE));
            }
            for (SAMRecord sAMRecord : reader) {
                SAMReadGroupRecord rg = sAMRecord.getReadGroup();
                if (rg != null && rg.getLibrary() != null) {
                    ((SAMFileWriter)libraryToWriter.get(rg.getLibrary())).addAlignment(sAMRecord);
                    continue;
                }
                if (unknown == null) {
                    unknown = factory.makeWriter(unknownHeader, true, new File(this.OUTPUT, "unknown" + extension), this.REFERENCE_SEQUENCE);
                }
                unknown.addAlignment(sAMRecord);
            }
        }
        catch (IOException e) {
            log.error(new Object[]{"Trouble while reading %s", this.INPUT.getAbsolutePath()});
            log.error(new Object[]{e.getMessage()});
        }
        if (unknown != null) {
            unknown.close();
        }
        Iterator iterator = libraryToWriter.values().iterator();
        while (iterator.hasNext()) {
            SAMFileWriter writer = (SAMFileWriter)iterator.next();
            writer.close();
        }
        return 0;
    }
}

