/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamIndexValidator;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamFileValidator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Validates a SAM/BAM/CRAM file.<p>This tool reports on the validity of a SAM/BAM/CRAM file relative to the SAM format specification.  This is useful for troubleshooting errors encountered with other tools that may be caused by improper formatting, faulty alignments, incorrect flag values, etc. </p> <p>By default, the tool runs in VERBOSE mode and will exit after finding 100 errors and output them to the console (stdout). Therefore, it is often more practical to run this tool initially using the MODE=SUMMARY option.  This mode outputs a summary table listing the numbers of all 'errors' and 'warnings'.</p> <p>When fixing errors in your file, it is often useful to prioritize the severe validation errors and ignore the errors/warnings of lesser concern.  This can be done using the IGNORE and/or IGNORE_WARNINGS arguments.  For helpful suggestions on error prioritization, please follow this link to obtain additional documentation on <a href='https://www.broadinstitute.org/gatk/guide/article?id=7571'>ValidateSamFile</a>.</p><p>After identifying and fixing your 'warnings/errors', we recommend that you rerun this tool to validate your SAM/BAM file prior to proceeding with your downstream analysis.  This will verify that all problems in your file have been addressed.</p><h3>Usage example:</h3><pre>java -jar picard.jar ValidateSamFile \\<br />      I=input.bam \\<br />      MODE=SUMMARY</pre><p>To obtain a complete list with descriptions of both 'ERROR' and 'WARNING' messages, please see our additional <a href='https://www.broadinstitute.org/gatk/guide/article?id=7571'>documentation</a> for this tool.</p><hr />Return codes depend on the errors/warnings discovered:<p>-1 failed to complete execution\n0  ran successfully\n1  warnings but no errors\n2  errors and warnings\n3  errors but no warnings", oneLineSummary="Validates a SAM/BAM/CRAM file.", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class ValidateSamFile
extends CommandLineProgram {
    private static final Log log = Log.getInstance(ValidateSamFile.class);
    static final String USAGE_SUMMARY = "Validates a SAM/BAM/CRAM file.";
    static final String USAGE_DETAILS = "<p>This tool reports on the validity of a SAM/BAM/CRAM file relative to the SAM format specification.  This is useful for troubleshooting errors encountered with other tools that may be caused by improper formatting, faulty alignments, incorrect flag values, etc. </p> <p>By default, the tool runs in VERBOSE mode and will exit after finding 100 errors and output them to the console (stdout). Therefore, it is often more practical to run this tool initially using the MODE=SUMMARY option.  This mode outputs a summary table listing the numbers of all 'errors' and 'warnings'.</p> <p>When fixing errors in your file, it is often useful to prioritize the severe validation errors and ignore the errors/warnings of lesser concern.  This can be done using the IGNORE and/or IGNORE_WARNINGS arguments.  For helpful suggestions on error prioritization, please follow this link to obtain additional documentation on <a href='https://www.broadinstitute.org/gatk/guide/article?id=7571'>ValidateSamFile</a>.</p><p>After identifying and fixing your 'warnings/errors', we recommend that you rerun this tool to validate your SAM/BAM file prior to proceeding with your downstream analysis.  This will verify that all problems in your file have been addressed.</p><h3>Usage example:</h3><pre>java -jar picard.jar ValidateSamFile \\<br />      I=input.bam \\<br />      MODE=SUMMARY</pre><p>To obtain a complete list with descriptions of both 'ERROR' and 'WARNING' messages, please see our additional <a href='https://www.broadinstitute.org/gatk/guide/article?id=7571'>documentation</a> for this tool.</p><hr />Return codes depend on the errors/warnings discovered:<p>-1 failed to complete execution\n0  ran successfully\n1  warnings but no errors\n2  errors and warnings\n3  errors but no warnings";
    @Argument(shortName="I", doc="Input SAM/BAM/CRAM file")
    public File INPUT;
    @Argument(shortName="O", doc="Output file or standard out if missing", optional=true)
    public File OUTPUT;
    @Argument(shortName="M", doc="Mode of output")
    public Mode MODE = Mode.VERBOSE;
    @Argument(doc="List of validation error types to ignore.", optional=true)
    public List<SAMValidationError.Type> IGNORE = new ArrayList<SAMValidationError.Type>();
    @Argument(shortName="MO", doc="The maximum number of lines output in verbose mode")
    public Integer MAX_OUTPUT = 100;
    @Argument(doc="If true, only report errors and ignore warnings.")
    public boolean IGNORE_WARNINGS = false;
    @Argument(doc="DEPRECATED.  Use INDEX_VALIDATION_STRINGENCY instead.  If true and input is a BAM file with an index file, also validates the index.  Until this parameter is retired VALIDATE INDEX and INDEX_VALIDATION_STRINGENCY must agree on whether to validate the index.")
    public boolean VALIDATE_INDEX = true;
    @Argument(doc="If set to anything other than IndexValidationStringency.NONE and input is a BAM file with an index file, also validates the index at the specified stringency. Until VALIDATE_INDEX is retired, VALIDATE INDEX and INDEX_VALIDATION_STRINGENCY must agree on whether to validate the index.")
    public BamIndexValidator.IndexValidationStringency INDEX_VALIDATION_STRINGENCY = BamIndexValidator.IndexValidationStringency.EXHAUSTIVE;
    @Argument(shortName="BISULFITE", doc="Whether the input file consists of bisulfite sequenced reads. If so, C->T is not counted as an error in computing the value of the NM tag.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Argument(doc="Relevant for a coordinate-sorted file containing read pairs only. Maximum number of file handles to keep open when spilling mate info to disk. Set this number a little lower than the per-process maximum number of file that may be open. This number can be found by executing the 'ulimit -n' command on a Unix system.")
    public int MAX_OPEN_TEMP_FILES = 8000;
    @Argument(shortName="SMV", doc="If true, this tool will not attempt to validate mate information. In general cases, this option should not be used.  However, in cases where samples have very high duplication or chimerism rates (> 10%), the mate validation process often requires extremely large amounts of memory to run, so this flag allows you to forego that check.")
    public boolean SKIP_MATE_VALIDATION = false;

    @Override
    protected int doWork() {
        try {
            PrintWriter out;
            IOUtil.assertFileIsReadable((File)this.INPUT);
            ReferenceSequenceFile reference = null;
            if (this.REFERENCE_SEQUENCE != null) {
                IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
                reference = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.REFERENCE_SEQUENCE);
            } else {
                log.warn(new Object[]{"NM validation cannot be performed without the reference. All other validations will still occur."});
            }
            if (this.OUTPUT != null) {
                IOUtil.assertFileIsWritable((File)this.OUTPUT);
                try {
                    out = new PrintWriter(this.OUTPUT);
                }
                catch (FileNotFoundException e) {
                    throw new PicardException("Unexpected exception", e);
                }
            } else {
                out = new PrintWriter(System.out);
            }
            SamReaderFactory factory = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).validationStringency(ValidationStringency.SILENT).enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.VALIDATE_CRC_CHECKSUMS});
            SamReader samReader = factory.open(this.INPUT);
            if (samReader.type() != SamReader.Type.BAM_TYPE && samReader.type() != SamReader.Type.BAM_CSI_TYPE) {
                this.VALIDATE_INDEX = false;
            }
            factory.setOption(SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES, this.VALIDATE_INDEX);
            factory.reapplyOptions(samReader);
            SamFileValidator validator = new SamFileValidator(out, this.MAX_OPEN_TEMP_FILES);
            validator.setErrorsToIgnore(this.IGNORE);
            validator.setSkipMateValidation(this.SKIP_MATE_VALIDATION);
            validator.setBisulfiteSequenced(this.IS_BISULFITE_SEQUENCED);
            validator.setIgnoreWarnings(this.IGNORE_WARNINGS);
            if (this.MODE == Mode.SUMMARY) {
                validator.setVerbose(false, 0);
            } else {
                validator.setVerbose(true, this.MAX_OUTPUT.intValue());
            }
            if (this.VALIDATE_INDEX) {
                validator.setIndexValidationStringency(this.VALIDATE_INDEX ? BamIndexValidator.IndexValidationStringency.EXHAUSTIVE : BamIndexValidator.IndexValidationStringency.NONE);
            }
            if (IOUtil.isRegularPath((File)this.INPUT)) {
                validator.validateBamFileTermination(this.INPUT);
            }
            boolean result = false;
            switch (this.MODE) {
                case SUMMARY: {
                    result = validator.validateSamFileSummary(samReader, reference);
                    break;
                }
                case VERBOSE: {
                    result = validator.validateSamFileVerbose(samReader, reference);
                }
            }
            out.flush();
            if (result) {
                return ReturnTypes.SUCCESSFUL.value();
            }
            if (validator.getNumErrors() == 0) {
                if (validator.getNumWarnings() > 0) {
                    return ReturnTypes.WARNINGS.value();
                }
                log.error(new Object[]{"SAM file validation fails without warnings or errors."});
                return ReturnTypes.FAILED.value();
            }
            if (validator.getNumWarnings() > 0) {
                return ReturnTypes.ERRORS_WARNINGS.value();
            }
            return ReturnTypes.ERRORS.value();
        }
        catch (Exception e) {
            log.error(new Object[]{e.getMessage()});
            return ReturnTypes.FAILED.value();
        }
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (!this.VALIDATE_INDEX && this.INDEX_VALIDATION_STRINGENCY != BamIndexValidator.IndexValidationStringency.NONE || this.VALIDATE_INDEX && this.INDEX_VALIDATION_STRINGENCY == BamIndexValidator.IndexValidationStringency.NONE) {
            return new String[]{"VALIDATE_INDEX and INDEX_VALIDATION_STRINGENCY must be consistent: VALIDATE_INDEX is " + this.VALIDATE_INDEX + " and INDEX_VALIDATION_STRINGENCY is " + this.INDEX_VALIDATION_STRINGENCY};
        }
        return super.customCommandLineValidation();
    }

    public static enum Mode {
        VERBOSE,
        SUMMARY;

    }

    static enum ReturnTypes {
        FAILED(-1),
        SUCCESSFUL(0),
        WARNINGS(1),
        ERRORS_WARNINGS(2),
        ERRORS(3);

        private final int value;

        private ReturnTypes(int value) {
            this.value = value;
        }

        int value() {
            return this.value;
        }
    }
}

