/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.io.output.NullOutputStream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="This tool checks that all reads with the same queryname have their duplicate marking flags set the same way. NOTE: This tool does NOT check that the duplicate marking is correct. The ONLY thing that it checks is that the 0x400 bit-flags of records with the same queryname are equal.", oneLineSummary="Checks the consistency of duplicate markings.", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature(enable=false)
public class CheckDuplicateMarking
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Checks the consistency of duplicate markings.";
    static final String USAGE_DETAILS = "This tool checks that all reads with the same queryname have their duplicate marking flags set the same way. NOTE: This tool does NOT check that the duplicate marking is correct. The ONLY thing that it checks is that the 0x400 bit-flags of records with the same queryname are equal.";
    @Argument(doc="Input BAM or SAM file to check.", shortName="I")
    public File INPUT;
    @Argument(doc="Output file into which bad querynames will be placed (if not null).", shortName="O", optional=true)
    public File OUTPUT = null;
    @Argument(doc="Which reads of the same name should be checked to have same duplicate marking.")
    public Mode MODE = Mode.ALL;
    private String currentReadName = "";
    private boolean currentReadDuplicateMarked = false;
    private static final Log log = Log.getInstance(CheckDuplicateMarking.class);
    private final ProgressLogger progress = new ProgressLogger(log, 1000000, "Checked.");
    private static final int NUM_WARNINGS = 100;
    private int numBadRecords = 0;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
        }
        try (SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);){
            this.checkDuplicateMarkingsInIterator(this.getSortedRecordsFromReader(reader));
            if (this.numBadRecords > 0) {
                log.error(new Object[]{"Found " + this.numBadRecords + " records that do not agree on their duplicate flag."});
            } else {
                log.info(new Object[]{"All records' duplicate markings agree."});
            }
        }
        catch (IOException e) {
            throw new PicardException("Error while reading input file " + this.INPUT, e);
        }
        return this.numBadRecords > 0 ? 1 : 0;
    }

    private Iterator<SAMRecord> getSortedRecordsFromReader(SamReader reader) {
        if (reader.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.queryname) {
            return reader.iterator();
        }
        log.info(new Object[]{"Input file isn't queryname sorted. Sorting into temp space."});
        ProgressLogger sortProgress = new ProgressLogger(log, 1000000, "Read into sorter");
        SortingCollection alignmentSorter = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(reader.getFileHeader()), (Comparator)new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM);
        for (SAMRecord rec : reader) {
            alignmentSorter.add((Object)rec);
            sortProgress.record(rec);
        }
        CloseableIterator iterator = alignmentSorter.iterator();
        alignmentSorter.cleanup();
        return iterator;
    }

    private boolean checkAndTallyRecordDuplicateMarking(SAMRecord rec) {
        if (!rec.getReadName().equals(this.currentReadName)) {
            this.currentReadName = rec.getReadName();
            this.currentReadDuplicateMarked = rec.getDuplicateReadFlag();
        } else if (rec.getDuplicateReadFlag() != this.currentReadDuplicateMarked) {
            ++this.numBadRecords;
            if (this.numBadRecords <= 100) {
                log.warn(() -> "Reads with queryname " + this.currentReadName + " have different duplicate flags (at " + rec.getContig() + ":" + rec.getStart() + ")");
            }
            if (this.numBadRecords == 100) {
                log.warn(new Object[]{"Further warnings will be suppressed."});
            }
            return false;
        }
        return true;
    }

    private void checkDuplicateMarkingsInIterator(Iterator<SAMRecord> iterator) throws IOException {
        try (PrintWriter writer = this.OUTPUT == null ? new PrintWriter((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM) : new PrintWriter(new FileWriter(this.OUTPUT));){
            while (iterator.hasNext()) {
                SAMRecord rec = iterator.next();
                if (this.MODE != Mode.ALL && rec.isSecondaryOrSupplementary() || this.MODE == Mode.PRIMARY_MAPPED_ONLY && rec.getReadUnmappedFlag() || this.MODE == Mode.PRIMARY_PROPER_PAIR_ONLY && !rec.getProperPairFlag()) continue;
                if (!this.checkAndTallyRecordDuplicateMarking(rec)) {
                    writer.println(rec.getReadName());
                }
                this.progress.record(rec);
            }
        }
    }

    public static enum Mode implements CommandLineParser.ClpEnum
    {
        ALL("Check all reads."),
        PRIMARY_ONLY("Check primary alignments."),
        PRIMARY_MAPPED_ONLY("Check mapped alignments."),
        PRIMARY_PROPER_PAIR_ONLY("Check mapped alignments.");

        private final String message;

        private Mode(String message) {
            this.message = message;
        }

        public String getHelpDoc() {
            return this.message;
        }
    }
}

