/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.SAMRecord;
import picard.sam.markduplicates.MarkDuplicatesForFlowHelper;
import picard.sam.markduplicates.util.ReadEnds;

public class ReadEndsForMarkDuplicates
extends ReadEnds
implements Cloneable {
    protected static final int SIZE_OF = 69;
    public short score = 0;
    public long read1IndexInFile = -1L;
    public long read2IndexInFile = -1L;
    public int duplicateSetSize = -1;

    public static int getSizeOf() {
        return 69;
    }

    public ReadEndsForMarkDuplicates() {
    }

    public ReadEndsForMarkDuplicates(ReadEndsForMarkDuplicates read) {
        this.libraryId = read.getLibraryId();
        this.orientation = read.orientation;
        this.read1ReferenceIndex = read.read1ReferenceIndex;
        this.read1Coordinate = read.read1Coordinate;
        this.read2ReferenceIndex = read.read2ReferenceIndex;
        this.read2Coordinate = read.read2Coordinate;
        this.readGroup = read.getReadGroup();
        this.tile = read.getTile();
        this.x = read.x;
        this.y = read.y;
        this.orientationForOpticalDuplicates = read.orientationForOpticalDuplicates;
        this.score = read.score;
        this.read1IndexInFile = read.read1IndexInFile;
        this.read2IndexInFile = read.read2IndexInFile;
    }

    public String toString() {
        return String.format("%d %d %d", this.read1IndexInFile, this.read1Coordinate, this.score);
    }

    public ReadEndsForMarkDuplicates clone() {
        return new ReadEndsForMarkDuplicates(this);
    }

    public static boolean isSingleEndReadKnownFragment(SAMRecord rec) {
        if (rec.getReadUnmappedFlag() || rec.getReadPairedFlag()) {
            return false;
        }
        if (MarkDuplicatesForFlowHelper.isAdapterClipped(rec)) {
            return true;
        }
        if (!rec.getReadNegativeStrandFlag()) {
            return rec.getEnd() != rec.getUnclippedEnd();
        }
        return rec.getStart() != rec.getUnclippedStart();
    }
}

