/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import picard.nio.PicardHtsPath;
import picard.util.VariantType;
import picard.vcf.ByIntervalListVariantContextIterator;

public class DbSnpBitSetUtil {
    private final Map<String, BitSet> sequenceToBitSet = new HashMap<String, BitSet>();

    private DbSnpBitSetUtil() {
    }

    public DbSnpBitSetUtil(File dbSnpFile, SAMSequenceDictionary sequenceDictionary) {
        this(dbSnpFile, sequenceDictionary, EnumSet.noneOf(VariantType.class));
    }

    public DbSnpBitSetUtil(Path dbSnpFile, SAMSequenceDictionary sequenceDictionary) {
        this(dbSnpFile, sequenceDictionary, EnumSet.noneOf(VariantType.class));
    }

    public DbSnpBitSetUtil(File dbSnpFile, SAMSequenceDictionary sequenceDictionary, Collection<VariantType> variantsToMatch) {
        this(dbSnpFile, sequenceDictionary, variantsToMatch, null);
    }

    public DbSnpBitSetUtil(Path dbSnpFile, SAMSequenceDictionary sequenceDictionary, Collection<VariantType> variantsToMatch) {
        this(dbSnpFile, sequenceDictionary, variantsToMatch, null);
    }

    public DbSnpBitSetUtil(File dbSnpFile, SAMSequenceDictionary sequenceDictionary, Collection<VariantType> variantsToMatch, IntervalList intervals) {
        this(dbSnpFile, sequenceDictionary, variantsToMatch, intervals, Optional.empty());
    }

    public DbSnpBitSetUtil(Path dbSnpFile, SAMSequenceDictionary sequenceDictionary, Collection<VariantType> variantsToMatch, IntervalList intervals) {
        this(dbSnpFile, sequenceDictionary, variantsToMatch, intervals, Optional.empty());
    }

    public DbSnpBitSetUtil(File dbSnpFile, SAMSequenceDictionary sequenceDictionary, Collection<VariantType> variantsToMatch, IntervalList intervals, Optional<Log> log) {
        this(dbSnpFile.toPath(), sequenceDictionary, variantsToMatch, intervals, log);
    }

    public DbSnpBitSetUtil(Path dbSnpFile, SAMSequenceDictionary sequenceDictionary, Collection<VariantType> variantsToMatch, IntervalList intervals, Optional<Log> log) {
        if (dbSnpFile == null) {
            throw new IllegalArgumentException("null dbSnpFile");
        }
        HashMap<DbSnpBitSetUtil, Set<VariantType>> tmp = new HashMap<DbSnpBitSetUtil, Set<VariantType>>();
        tmp.put(this, EnumSet.copyOf(variantsToMatch));
        DbSnpBitSetUtil.loadVcf(PicardHtsPath.fromPath(dbSnpFile), sequenceDictionary, tmp, intervals, log);
    }

    public static DbSnpBitSets createSnpAndIndelBitSets(File dbSnpFile, SAMSequenceDictionary sequenceDictionary) {
        return DbSnpBitSetUtil.createSnpAndIndelBitSets(dbSnpFile, sequenceDictionary, null);
    }

    public static DbSnpBitSets createSnpAndIndelBitSets(File dbSnpFile, SAMSequenceDictionary sequenceDictionary, IntervalList intervals) {
        return DbSnpBitSetUtil.createSnpAndIndelBitSets(new PicardHtsPath(dbSnpFile), sequenceDictionary, intervals);
    }

    public static DbSnpBitSets createSnpAndIndelBitSets(PicardHtsPath dbSnpFile, SAMSequenceDictionary sequenceDictionary, IntervalList intervals) {
        return DbSnpBitSetUtil.createSnpAndIndelBitSets(dbSnpFile, sequenceDictionary, intervals, Optional.empty());
    }

    public static DbSnpBitSets createSnpAndIndelBitSets(File dbSnpFile, SAMSequenceDictionary sequenceDictionary, IntervalList intervals, Optional<Log> log) {
        return DbSnpBitSetUtil.createSnpAndIndelBitSets(new PicardHtsPath(dbSnpFile), sequenceDictionary, intervals, log);
    }

    public static DbSnpBitSets createSnpAndIndelBitSets(PicardHtsPath dbSnpFile, SAMSequenceDictionary sequenceDictionary, IntervalList intervals, Optional<Log> log) {
        DbSnpBitSets sets = new DbSnpBitSets();
        sets.snps = new DbSnpBitSetUtil();
        sets.indels = new DbSnpBitSetUtil();
        HashMap<DbSnpBitSetUtil, Set<VariantType>> map = new HashMap<DbSnpBitSetUtil, Set<VariantType>>();
        map.put(sets.snps, EnumSet.of(VariantType.SNP));
        map.put(sets.indels, EnumSet.of(VariantType.insertion, VariantType.deletion));
        DbSnpBitSetUtil.loadVcf(dbSnpFile, sequenceDictionary, map, intervals, log);
        return sets;
    }

    private static void loadVcf(PicardHtsPath dbSnpFile, SAMSequenceDictionary sequenceDictionary, Map<DbSnpBitSetUtil, Set<VariantType>> bitSetsToVariantTypes, IntervalList intervals, Optional<Log> log) {
        Optional<ProgressLogger> progress = log.map(l -> new ProgressLogger(l, 100000, "Read", "variants"));
        VCFFileReader variantReader = new VCFFileReader(dbSnpFile.toPath(), intervals != null);
        ByIntervalListVariantContextIterator variantIterator = intervals != null ? new ByIntervalListVariantContextIterator(variantReader, intervals) : variantReader.iterator();
        while (variantIterator.hasNext()) {
            VariantContext kv = (VariantContext)variantIterator.next();
            for (Map.Entry<DbSnpBitSetUtil, Set<VariantType>> tuple : bitSetsToVariantTypes.entrySet()) {
                DbSnpBitSetUtil bitset = tuple.getKey();
                Set<VariantType> variantsToMatch = tuple.getValue();
                BitSet bits = bitset.sequenceToBitSet.get(kv.getContig());
                if (bits == null) {
                    int nBits = sequenceDictionary == null ? kv.getEnd() + 1 : sequenceDictionary.getSequence(kv.getContig()).getSequenceLength() + 1;
                    bits = new BitSet(nBits);
                    bitset.sequenceToBitSet.put(kv.getContig(), bits);
                }
                if (!(variantsToMatch.isEmpty() || kv.isSNP() && variantsToMatch.contains((Object)VariantType.SNP) || kv.isIndel() && variantsToMatch.contains((Object)VariantType.insertion)) && (!kv.isIndel() || !variantsToMatch.contains((Object)VariantType.deletion))) continue;
                for (int i = kv.getStart(); i <= kv.getEnd(); ++i) {
                    bits.set(i, true);
                }
            }
            progress.map(p -> p.record(kv.getContig(), kv.getStart()));
        }
        CloserUtil.close((Object)variantReader);
    }

    public boolean isDbSnpSite(String sequenceName, int pos) {
        return this.sequenceToBitSet.get(sequenceName) != null && pos <= this.sequenceToBitSet.get(sequenceName).length() && this.sequenceToBitSet.get(sequenceName).get(pos);
    }

    public static class DbSnpBitSets {
        public DbSnpBitSetUtil snps;
        public DbSnpBitSetUtil indels;
    }
}

