/*
 * Decompiled with CFR 0.152.
 */
package picard.util.IntervalList;

import java.util.function.Supplier;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import picard.util.IntervalList.IntervalListScatterer;
import picard.util.IntervalList.IntervalListScattererByIntervalCount;
import picard.util.IntervalList.IntervalListScattererByIntervalCountWithDistributedRemainder;
import picard.util.IntervalList.IntervalListScattererWithSubdivision;
import picard.util.IntervalList.IntervalListScattererWithoutSubdivision;
import picard.util.IntervalList.IntervalListScattererWithoutSubdivisionWithOverflow;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IntervalListScatterMode implements CommandLineParser.ClpEnum
{
    INTERVAL_SUBDIVISION(IntervalListScattererWithSubdivision::new, "Scatter the interval list into similarly sized interval lists (by base count), breaking up intervals as needed."){}
    ,
    BALANCING_WITHOUT_INTERVAL_SUBDIVISION(IntervalListScattererWithoutSubdivision::new, "Scatter the interval list into similarly sized interval lists (by base count), but without breaking up intervals."),
    BALANCING_WITHOUT_INTERVAL_SUBDIVISION_WITH_OVERFLOW(IntervalListScattererWithoutSubdivisionWithOverflow::new, "Scatter the interval list into similarly sized interval lists (by base count), but without breaking up intervals. Will overflow current interval list so that the remaining lists will not have too many bases to deal with."),
    INTERVAL_COUNT(IntervalListScattererByIntervalCount::new, "Scatter the interval list into similarly sized interval lists (by interval count, not by base count). Resulting interval lists will contain the same number of intervals except for the last, which contains the remainder."),
    INTERVAL_COUNT_WITH_DISTRIBUTED_REMAINDER(IntervalListScattererByIntervalCountWithDistributedRemainder::new, "Scatter the interval list into similarly sized interval lists (by interval count, not by base count). Resulting interval lists will contain similar number of intervals.");

    private final Supplier<IntervalListScatterer> scattererSupplier;
    private final String docString;

    private IntervalListScatterMode(Supplier<IntervalListScatterer> supplier, String docString) {
        this.scattererSupplier = supplier;
        this.docString = docString;
    }

    public String getHelpDoc() {
        return this.docString;
    }

    public IntervalListScatterer make() {
        return this.scattererSupplier.get();
    }
}

