/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMSequenceDictionaryCodec;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import picard.PicardException;

public class SequenceDictionaryUtils {
    public static void encodeDictionary(BufferedWriter writer, Iterator<SAMSequenceRecord> samSequenceRecordIterator) {
        SAMSequenceDictionaryCodec samDictCodec = new SAMSequenceDictionaryCodec((Writer)writer);
        samDictCodec.encodeHeaderLine(false);
        SortingCollection<String> sequenceNames = SequenceDictionaryUtils.makeSortingCollection();
        while (samSequenceRecordIterator.hasNext()) {
            SAMSequenceRecord samSequenceRecord = samSequenceRecordIterator.next();
            samDictCodec.encodeSequenceRecord(samSequenceRecord);
            sequenceNames.add((Object)samSequenceRecord.getSequenceName());
        }
        CloseableIterator iterator = sequenceNames.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        String current = (String)iterator.next();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (current.equals(next)) {
                throw new PicardException("Sequence name " + current + " appears more than once in reference file");
            }
            current = next;
        }
    }

    public static SortingCollection<String> makeSortingCollection() {
        File tmpDir = IOUtil.createTempDir((String)"SamDictionaryNames").toFile();
        tmpDir.deleteOnExit();
        long maxNamesInRam = Runtime.getRuntime().maxMemory() / 256L / 10L;
        return SortingCollection.newInstance(String.class, (SortingCollection.Codec)new StringCodec(), String::compareTo, (int)((int)Math.min(maxNamesInRam, Integer.MAX_VALUE)), (Path[])new Path[]{tmpDir.toPath()});
    }

    private static class StringCodec
    implements SortingCollection.Codec<String> {
        private DataInputStream dis;
        private DataOutputStream dos;

        private StringCodec() {
        }

        public StringCodec clone() {
            return new StringCodec();
        }

        public void setOutputStream(OutputStream os) {
            this.dos = new DataOutputStream(os);
        }

        public void setInputStream(InputStream is) {
            this.dis = new DataInputStream(is);
        }

        public void encode(String str) {
            try {
                this.dos.writeUTF(str);
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public String decode() {
            try {
                return this.dis.readUTF();
            }
            catch (EOFException e) {
                return null;
            }
            catch (IOException e) {
                throw new PicardException("Exception reading sequence name from temporary file.", e);
            }
        }
    }

    public static class SamSequenceRecordsIterator
    implements Iterator<SAMSequenceRecord> {
        private final boolean truncateNamesAtWhitespace;
        private final ReferenceSequenceFile refSeqFile;
        private String genomeAssembly;
        private String uri;
        private String species;
        private ReferenceSequence nextRefSeq;
        private final MessageDigest md5;

        public void setGenomeAssembly(String genomeAssembly) {
            this.genomeAssembly = genomeAssembly;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public void setSpecies(String species) {
            this.species = species;
        }

        public SamSequenceRecordsIterator(File referenceSequence, boolean truncateNamesAtWhitespace) {
            this.truncateNamesAtWhitespace = truncateNamesAtWhitespace;
            this.refSeqFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)referenceSequence, (boolean)truncateNamesAtWhitespace);
            this.nextRefSeq = this.refSeqFile.nextSequence();
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new PicardException("MD5 algorithm not found", e);
            }
        }

        private String md5Hash(byte[] bytes) {
            this.md5.reset();
            this.md5.update(bytes);
            Object s = new BigInteger(1, this.md5.digest()).toString(16);
            if (((String)s).length() != 32) {
                String zeros = "00000000000000000000000000000000";
                s = "00000000000000000000000000000000".substring(0, 32 - ((String)s).length()) + (String)s;
            }
            return s;
        }

        private SAMSequenceRecord makeSequenceRecord(ReferenceSequence refSeq) {
            SAMSequenceRecord ret = new SAMSequenceRecord(refSeq.getName(), refSeq.length());
            byte[] bases = refSeq.getBases();
            for (int i = 0; i < bases.length; ++i) {
                bases[i] = StringUtil.toUpperCase((byte)bases[i]);
            }
            ret.setAttribute("M5", this.md5Hash(bases));
            if (this.genomeAssembly != null) {
                ret.setAttribute("AS", this.genomeAssembly);
            }
            ret.setAttribute("UR", this.uri);
            if (this.species != null) {
                ret.setAttribute("SP", this.species);
            }
            return ret;
        }

        @Override
        public boolean hasNext() {
            return this.nextRefSeq != null;
        }

        @Override
        public SAMSequenceRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() was called when hasNext() was false.");
            }
            SAMSequenceRecord samSequenceRecord = this.makeSequenceRecord(this.nextRefSeq);
            this.nextRefSeq = this.refSeqFile.nextSequence();
            return samSequenceRecord;
        }
    }
}

