/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.CloseableIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import picard.PicardException;
import picard.util.TabbedInputParser;

public class TabbedTextFileWithHeaderParser
implements Iterable<Row>,
AutoCloseable {
    private final Map<String, Integer> columnLabelIndices = new HashMap<String, Integer>();
    private final TabbedInputParser parser;
    private TheIterator extantIterator;

    public TabbedTextFileWithHeaderParser(TabbedInputParser parser) {
        this.parser = parser;
        if (!parser.hasNext()) {
            throw new PicardException("No header line found in file " + parser.getFileName());
        }
        String[] columnLabels = (String[])parser.next();
        for (int i = 0; i < columnLabels.length; ++i) {
            this.columnLabelIndices.put(columnLabels[i], i);
        }
    }

    public TabbedTextFileWithHeaderParser(File file) {
        this(new TabbedInputParser(false, file));
    }

    public TabbedTextFileWithHeaderParser(File file, String[] columnHeaders) {
        this.parser = new TabbedInputParser(false, file);
        if (!this.parser.hasNext()) {
            throw new PicardException("No header line found in file " + file);
        }
        for (int i = 0; i < columnHeaders.length; ++i) {
            this.columnLabelIndices.put(columnHeaders[i], i);
        }
    }

    public boolean hasColumn(String columnLabel) {
        return this.columnLabelIndices.containsKey(columnLabel);
    }

    public Set<String> columnLabels() {
        return this.columnLabelIndices.keySet();
    }

    public List<String> columnLabelsList() {
        return Collections.unmodifiableList(new ArrayList<String>(this.columnLabelIndices.keySet()));
    }

    @Override
    public CloseableIterator<Row> iterator() {
        if (this.extantIterator != null) {
            throw new ConcurrentModificationException("Only one iterator allowed at a time.");
        }
        this.extantIterator = new TheIterator();
        return this.extantIterator;
    }

    @Override
    public void close() {
        this.parser.close();
    }

    public int getCurrentLineNumber() {
        return this.parser.getCurrentLineNumber();
    }

    public Set<String> getColumnNames() {
        return Collections.unmodifiableSet(this.columnLabelIndices.keySet());
    }

    class TheIterator
    implements CloseableIterator<Row> {
        TheIterator() {
        }

        public boolean hasNext() {
            return TabbedTextFileWithHeaderParser.this.parser.hasNext();
        }

        public Row next() {
            String[] fields = (String[])TabbedTextFileWithHeaderParser.this.parser.next();
            String source = TabbedTextFileWithHeaderParser.this.parser.getCurrentLine();
            return new Row(fields, source);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            TabbedTextFileWithHeaderParser.this.extantIterator = null;
        }
    }

    public class Row {
        private final String[] fields;
        private final String currentLine;

        Row(String[] fields, String source) {
            this.fields = fields;
            this.currentLine = source;
        }

        public String[] getFields() {
            return this.fields;
        }

        public String getField(String columnLabel) {
            Integer key = TabbedTextFileWithHeaderParser.this.columnLabelIndices.get(columnLabel);
            if (key == null) {
                throw new NoSuchElementException(String.format("column %s in %s", columnLabel, TabbedTextFileWithHeaderParser.this.parser.getFileName()));
            }
            return this.fields[key];
        }

        public Integer getIntegerField(String columnLabel) {
            if (this.fields[TabbedTextFileWithHeaderParser.this.columnLabelIndices.get(columnLabel)] == null) {
                return null;
            }
            return Integer.parseInt(this.fields[TabbedTextFileWithHeaderParser.this.columnLabelIndices.get(columnLabel)]);
        }

        public String getCurrentLine() {
            return this.currentLine;
        }
    }
}

