/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import picard.util.DbSnpBitSetUtil;
import picard.vcf.CollectVariantCallingMetrics;
import picard.vcf.processor.VariantProcessor;

public class CallingMetricAccumulator
implements VariantProcessor.Accumulator<Result> {
    private static final Log LOG = Log.getInstance(CallingMetricAccumulator.class);
    private static final ProgressLogger progress = new ProgressLogger(LOG, 10000);
    private final DbSnpBitSetUtil.DbSnpBitSets dbsnp;
    private final CollectVariantCallingMetrics.VariantCallingSummaryMetrics summaryMetric = new CollectVariantCallingMetrics.VariantCallingSummaryMetrics();
    private final CollectionUtil.DefaultingMap<String, CollectVariantCallingMetrics.VariantCallingDetailMetrics> sampleMetricsMap = new CollectionUtil.DefaultingMap(sampleName -> {
        CollectVariantCallingMetrics.VariantCallingDetailMetrics detail = new CollectVariantCallingMetrics.VariantCallingDetailMetrics();
        detail.SAMPLE_ALIAS = sampleName;
        return detail;
    }, true);

    public CallingMetricAccumulator(DbSnpBitSetUtil.DbSnpBitSets dbsnp) {
        this.dbsnp = dbsnp;
    }

    public void setup(VCFHeader vcfHeader) {
        vcfHeader.getGenotypeSamples().stream().forEach(sampleName -> this.sampleMetricsMap.get(sampleName));
    }

    @Override
    public void accumulate(VariantContext vc) {
        progress.record(vc.getContig(), vc.getStart());
        if (!CallingMetricAccumulator.isVariantExcluded(vc)) {
            String singletonSample = CallingMetricAccumulator.getSingletonSample(vc);
            this.updateSummaryMetric(this.summaryMetric, null, vc, singletonSample != null);
            vc.getSampleNames().stream().filter(sampleName -> !vc.getGenotype(sampleName).isHomRef()).forEach(sampleName -> this.updateDetailMetric((CollectVariantCallingMetrics.VariantCallingDetailMetrics)((Object)((Object)this.sampleMetricsMap.get(sampleName))), vc.getGenotype(sampleName), vc, sampleName.equals(singletonSample)));
        }
    }

    public static String getSingletonSample(VariantContext vc) {
        String[] sampleName = new String[1];
        if (vc.getGenotypes().stream().filter(genotype -> genotype.isHet() || genotype.isHomVar()).limit(2L).peek(genotype -> {
            sampleName[0] = genotype.getSampleName();
        }).mapToInt(genotype -> genotype.isHet() ? 1 : 2).reduce(Integer::sum).orElse(0) == 1) {
            return sampleName[0];
        }
        return null;
    }

    @Override
    public Result result() {
        Collection values = this.sampleMetricsMap.values();
        values.forEach(CollectVariantCallingMetrics.VariantCallingDetailMetrics::calculateDerivedFields);
        this.summaryMetric.calculateDerivedFields();
        return new Result(this.summaryMetric, values);
    }

    private static boolean isVariantExcluded(VariantContext vc) {
        return !vc.isVariant() || vc.getGenotypes().stream().allMatch(Genotype::isHomRef);
    }

    private void updateDetailMetric(CollectVariantCallingMetrics.VariantCallingDetailMetrics metric, Genotype genotype, VariantContext vc, boolean hasSingletonSample) {
        this.updateSummaryMetric(metric, genotype, vc, hasSingletonSample);
        if (genotype != null && !vc.isFiltered()) {
            if (genotype.getGQ() == 0) {
                ++metric.TOTAL_GQ0_VARIANTS;
            }
            if (genotype.isHet()) {
                ++metric.numHets;
            } else if (genotype.isHomVar()) {
                ++metric.numHomVar;
            }
        }
    }

    private void updateSummaryMetric(CollectVariantCallingMetrics.VariantCallingSummaryMetrics metric, Genotype genotype, VariantContext vc, boolean hasSingletonSample) {
        if (genotype != null && genotype.isNoCall()) {
            return;
        }
        if (vc.isFiltered()) {
            if (vc.isSNP()) {
                ++metric.FILTERED_SNPS;
            } else if (vc.isIndel()) {
                ++metric.FILTERED_INDELS;
            }
            return;
        }
        if (hasSingletonSample) {
            ++metric.NUM_SINGLETONS;
        }
        if (vc.isBiallelic() && vc.isSNP()) {
            boolean isInDbSnp = this.dbsnp.snps.isDbSnpSite(vc.getContig(), vc.getStart());
            boolean isTransition = VariantContextUtils.isTransition((VariantContext)vc);
            ++metric.TOTAL_SNPS;
            if (isInDbSnp) {
                ++metric.NUM_IN_DB_SNP;
                if (isTransition) {
                    ++metric.dbSnpTransitions;
                } else {
                    ++metric.dbSnpTransversions;
                }
            } else if (isTransition) {
                ++metric.novelTransitions;
            } else {
                ++metric.novelTransversions;
            }
            if (genotype != null && genotype.isHet()) {
                int[] alleleDepths = genotype.getAD();
                if (alleleDepths != null) {
                    int indexOfRef = vc.getAlleleIndex(vc.getReference());
                    int indexOfAlt = (indexOfRef + 1) % 2;
                    metric.refAlleleObs += (long)alleleDepths[indexOfRef];
                    metric.altAlleleObs += (long)alleleDepths[indexOfAlt];
                    this.summaryMetric.refAlleleObs += (long)alleleDepths[indexOfRef];
                    this.summaryMetric.altAlleleObs += (long)alleleDepths[indexOfAlt];
                } else {
                    LOG.debug(new Object[]{"Skipping aggregation of genotype due to missing allele depth data: ", genotype, "."});
                }
            }
        } else if (vc.isSNP() && vc.getAlternateAlleles().size() > 1) {
            metric.TOTAL_MULTIALLELIC_SNPS += 1.0;
            if (this.dbsnp.snps.isDbSnpSite(vc.getContig(), vc.getStart())) {
                metric.NUM_IN_DB_SNP_MULTIALLELIC += 1.0;
            }
        } else if (vc.isIndel() && !vc.isComplexIndel()) {
            boolean isInDbSnp = this.dbsnp.indels.isDbSnpSite(vc.getContig(), vc.getStart());
            boolean isInsertion = vc.isSimpleInsertion();
            ++metric.TOTAL_INDELS;
            if (isInDbSnp) {
                ++metric.NUM_IN_DB_SNP_INDELS;
                if (isInsertion) {
                    ++metric.dbSnpInsertions;
                } else {
                    ++metric.dbSnpDeletions;
                }
            } else if (isInsertion) {
                ++metric.novelInsertions;
            } else {
                ++metric.novelDeletions;
            }
        } else if (vc.isComplexIndel()) {
            metric.TOTAL_COMPLEX_INDELS += 1.0;
            if (this.dbsnp.indels.isDbSnpSite(vc.getContig(), vc.getStart())) {
                metric.NUM_IN_DB_SNP_COMPLEX_INDELS += 1.0;
            }
        }
    }

    public static class Result {
        final CollectVariantCallingMetrics.VariantCallingSummaryMetrics summary;
        final Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> details;

        Result(CollectVariantCallingMetrics.VariantCallingSummaryMetrics summary, Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> details) {
            this.summary = summary;
            this.details = details;
        }

        public static Result merge(Collection<Result> results) {
            ArrayList details = new ArrayList();
            ArrayList summaries = new ArrayList();
            results.stream().forEach(result -> {
                summaries.add(result.summary);
                details.addAll(result.details);
            });
            Map<String, List<CollectVariantCallingMetrics.VariantCallingDetailMetrics>> sampleDetailsMap = details.stream().collect(Collectors.groupingBy(vcDetailMetrics -> vcDetailMetrics.SAMPLE_ALIAS));
            ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics> collapsedDetails = new ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics>();
            sampleDetailsMap.values().stream().forEach(sampleDetails -> {
                CollectVariantCallingMetrics.VariantCallingDetailMetrics collapsed = new CollectVariantCallingMetrics.VariantCallingDetailMetrics();
                CollectVariantCallingMetrics.VariantCallingDetailMetrics.foldInto(collapsed, sampleDetails);
                collapsedDetails.add(collapsed);
                collapsed.calculateDerivedFields();
            });
            CollectVariantCallingMetrics.VariantCallingSummaryMetrics collapsedSummary = new CollectVariantCallingMetrics.VariantCallingSummaryMetrics();
            CollectVariantCallingMetrics.VariantCallingSummaryMetrics.foldInto(collapsedSummary, summaries);
            collapsedSummary.calculateDerivedFields();
            return new Result(collapsedSummary, collapsedDetails);
        }
    }
}

