/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import java.util.HashMap;
import java.util.Map;
import picard.vcf.GenotypeConcordanceStateCodes;

public class GenotypeConcordanceStates {
    static final Map<Integer, TruthState> truthMap = TruthState.getCodeMap();
    static final Map<Integer, CallState> callMap = CallState.getCodeMap();

    public static enum TruthState {
        MISSING(GenotypeConcordanceStateCodes.MISSING_CODE.ordinal()),
        HOM_REF(GenotypeConcordanceStateCodes.HOM_REF_CODE.ordinal()),
        HET_REF_VAR1(GenotypeConcordanceStateCodes.HET_REF_VAR1_CODE.ordinal()),
        HET_VAR1_VAR2(GenotypeConcordanceStateCodes.HET_VAR1_VAR2_CODE.ordinal()),
        HOM_VAR1(GenotypeConcordanceStateCodes.HOM_VAR1_CODE.ordinal()),
        NO_CALL(GenotypeConcordanceStateCodes.NO_CALL_CODE.ordinal()),
        LOW_GQ(GenotypeConcordanceStateCodes.LOW_GQ_CODE.ordinal()),
        LOW_DP(GenotypeConcordanceStateCodes.LOW_DP_CODE.ordinal()),
        VC_FILTERED(GenotypeConcordanceStateCodes.VC_FILTERED_CODE.ordinal()),
        GT_FILTERED(GenotypeConcordanceStateCodes.GT_FILTERED_CODE.ordinal()),
        IS_MIXED(GenotypeConcordanceStateCodes.IS_MIXED_CODE.ordinal());

        private final int code;

        public static TruthState getHom(int alleleIdx) {
            if (alleleIdx == 0) {
                return HOM_REF;
            }
            if (alleleIdx == 1) {
                return HOM_VAR1;
            }
            throw new IllegalStateException("Shouldn't be here.");
        }

        public static TruthState getVar(int allele0idx, int allele1idx) {
            if (allele0idx == 0 && allele1idx == 1) {
                return HET_REF_VAR1;
            }
            if (allele0idx == 1 && allele1idx == 0) {
                return HET_REF_VAR1;
            }
            if (allele0idx == 1 && allele1idx == 2) {
                return HET_VAR1_VAR2;
            }
            if (allele0idx == 2 && allele1idx == 1) {
                return HET_VAR1_VAR2;
            }
            throw new IllegalStateException("Shouldn't be here.");
        }

        static Map<Integer, TruthState> getCodeMap() {
            HashMap<Integer, TruthState> map = new HashMap<Integer, TruthState>();
            TruthState[] truthValues = TruthState.values();
            for (int i = 0; i < truthValues.length; ++i) {
                map.put(truthValues[i].code, truthValues[i]);
            }
            return map;
        }

        private TruthState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum CallState {
        MISSING(GenotypeConcordanceStateCodes.MISSING_CODE.ordinal()),
        HOM_REF(GenotypeConcordanceStateCodes.HOM_REF_CODE.ordinal()),
        HET_REF_VAR1(GenotypeConcordanceStateCodes.HET_REF_VAR1_CODE.ordinal()),
        HET_VAR1_VAR2(GenotypeConcordanceStateCodes.HET_VAR1_VAR2_CODE.ordinal()),
        HOM_VAR1(GenotypeConcordanceStateCodes.HOM_VAR1_CODE.ordinal()),
        HET_REF_VAR2(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal()),
        HET_REF_VAR3(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal()),
        HET_VAR1_VAR3(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal()),
        HET_VAR3_VAR4(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal()),
        HOM_VAR2(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal()),
        HOM_VAR3(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal()),
        NO_CALL(GenotypeConcordanceStateCodes.NO_CALL_CODE.ordinal()),
        LOW_GQ(GenotypeConcordanceStateCodes.LOW_GQ_CODE.ordinal()),
        LOW_DP(GenotypeConcordanceStateCodes.LOW_DP_CODE.ordinal()),
        VC_FILTERED(GenotypeConcordanceStateCodes.VC_FILTERED_CODE.ordinal()),
        GT_FILTERED(GenotypeConcordanceStateCodes.GT_FILTERED_CODE.ordinal()),
        IS_MIXED(GenotypeConcordanceStateCodes.IS_MIXED_CODE.ordinal());

        private final int code;

        public static CallState getHom(int alleleIdx) {
            if (alleleIdx == 0) {
                return HOM_REF;
            }
            if (alleleIdx == 1) {
                return HOM_VAR1;
            }
            if (alleleIdx == 2) {
                return HOM_VAR2;
            }
            if (alleleIdx == 3) {
                return HOM_VAR3;
            }
            throw new IllegalStateException("Shouldn't be here.");
        }

        public static CallState getHet(int allele0idx, int allele1idx) {
            if (allele0idx > allele1idx) {
                int temp = allele0idx;
                allele0idx = allele1idx;
                allele1idx = temp;
            }
            if (allele0idx == 0) {
                if (allele1idx == 1) {
                    return HET_REF_VAR1;
                }
                if (allele1idx == 2) {
                    return HET_REF_VAR2;
                }
                if (allele1idx == 3) {
                    return HET_REF_VAR3;
                }
                throw new IllegalStateException("Shouldn't be here.");
            }
            if (allele0idx == 1) {
                if (allele1idx == 2) {
                    return HET_VAR1_VAR2;
                }
                if (allele1idx == 3) {
                    return HET_VAR1_VAR3;
                }
                throw new IllegalStateException("Shouldn't be here.");
            }
            if (allele0idx == 2 && allele1idx == 3) {
                return HET_VAR3_VAR4;
            }
            if (allele0idx == 3 && allele1idx == 4) {
                return HET_VAR3_VAR4;
            }
            throw new IllegalStateException("Shouldn't be here.");
        }

        static Map<Integer, CallState> getCodeMap() {
            HashMap<Integer, CallState> map = new HashMap<Integer, CallState>();
            CallState[] callValues = CallState.values();
            for (int i = 0; i < callValues.length; ++i) {
                map.put(callValues[i].code, callValues[i]);
            }
            return map;
        }

        private CallState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static class TruthAndCallStates
    implements Comparable<TruthAndCallStates> {
        public final TruthState truthState;
        public final CallState callState;

        public TruthAndCallStates(TruthState truthState, CallState callState) {
            this.truthState = truthState;
            this.callState = callState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.compareTo((TruthAndCallStates)o) == 0;
        }

        public int hashCode() {
            int result = this.truthState.hashCode();
            result = 31 * result + this.callState.hashCode();
            return result;
        }

        @Override
        public int compareTo(TruthAndCallStates that) {
            int result = this.truthState.compareTo(that.truthState);
            if (result == 0) {
                result = this.callState.compareTo(that.callState);
            }
            return result;
        }
    }

    public static enum ContingencyState {
        TP,
        FP,
        TN,
        FN,
        NA,
        EMPTY;

    }
}

