/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Creates a TSV from sample name to VCF/GVCF path, with one line per input.\nInput VCF/GVCFs must contain a header describing exactly one sample.\n<h4>Usage example:</h4><pre>    java -jar picard.jar MakeVcfSampleNameMap \\\n        INPUT=sample1.vcf.gz \\\n        INPUT=sample2.vcf.gz \\\n        OUTPUT=cohort.sample_map</pre>", oneLineSummary="Creates a TSV from sample name to VCF/GVCF path, with one line per input.", programGroup=VariantManipulationProgramGroup.class)
public class MakeVcfSampleNameMap
extends CommandLineProgram {
    static final String SHORT_SUMMARY = "Creates a TSV from sample name to VCF/GVCF path, with one line per input.";
    static final String SUMMARY = "Creates a TSV from sample name to VCF/GVCF path, with one line per input.\nInput VCF/GVCFs must contain a header describing exactly one sample.\n<h4>Usage example:</h4><pre>    java -jar picard.jar MakeVcfSampleNameMap \\\n        INPUT=sample1.vcf.gz \\\n        INPUT=sample2.vcf.gz \\\n        OUTPUT=cohort.sample_map</pre>";
    @Argument(shortName="I", doc="One or more input VCFs to extract sample names from.", minElements=1)
    public List<String> INPUT;
    @Argument(shortName="O", doc="Output file to write the sample-name map to.")
    public File OUTPUT;
    private static final Log log = Log.getInstance(MakeVcfSampleNameMap.class);

    @Override
    protected int doWork() {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        HashMap<String, String> pathToNameMap = new HashMap<String, String>(this.INPUT.size());
        HashMap<String, String> nameToPathMap = new HashMap<String, String>(this.INPUT.size());
        for (String variantPathString : this.INPUT) {
            Path variantPath = MakeVcfSampleNameMap.getVariantPath(variantPathString);
            VCFHeader header = MakeVcfSampleNameMap.getHeaderFromPath(variantPath);
            int numberOfSamples = header.getNGenotypeSamples();
            if (numberOfSamples != 1) {
                throw new PicardException("Input: " + variantPathString + " was expected to contain a single sample but actually contained " + numberOfSamples + " samples.");
            }
            String sampleName = (String)header.getGenotypeSamples().get(0);
            pathToNameMap.put(variantPathString, sampleName);
            String previousPath = nameToPathMap.put(sampleName, variantPathString);
            if (previousPath == null) continue;
            log.warn(new Object[]{"Duplicate sample: " + sampleName + ". Sample was found in both " + previousPath + " and in " + variantPathString});
        }
        ArrayList mapLines = new ArrayList(this.INPUT.size());
        pathToNameMap.forEach((path, name) -> mapLines.add(path + "\t" + name));
        try {
            Files.write(this.OUTPUT.toPath(), mapLines, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new PicardException("Error while writing output", e);
        }
        return 0;
    }

    private static Path getVariantPath(String pathString) {
        try {
            return IOUtil.getPath((String)pathString);
        }
        catch (IOException e) {
            throw new PicardException("Error while converting input " + pathString + " to Path", e);
        }
    }

    private static VCFHeader getHeaderFromPath(Path variantPath) {
        VCFHeader vCFHeader;
        block9: {
            AbstractFeatureReader<VariantContext, LineIterator> reader = MakeVcfSampleNameMap.getReaderFromPath(variantPath);
            try {
                VCFHeader header = (VCFHeader)reader.getHeader();
                if (header == null) {
                    throw new PicardException("Null header found in " + variantPath.toUri() + ".");
                }
                vCFHeader = header;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PicardException("Error while reading VCF header from " + variantPath.toUri(), e);
                }
            }
            reader.close();
        }
        return vCFHeader;
    }

    private static AbstractFeatureReader<VariantContext, LineIterator> getReaderFromPath(Path variantPath) {
        String variantURI = variantPath.toAbsolutePath().toUri().toString();
        try {
            return AbstractFeatureReader.getFeatureReader((String)variantURI, null, (FeatureCodec)new VCFCodec(), (boolean)false, Function.identity(), Function.identity());
        }
        catch (TribbleException e) {
            throw new PicardException("Failed to create reader from " + variantURI, e);
        }
    }
}

