/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import com.google.common.primitives.Ints;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import picard.nio.PicardHtsPath;
import picard.vcf.processor.VcfPathSegment;

public abstract class VcfPathSegmentGenerator {
    static final Log LOG = Log.getInstance(VcfPathSegmentGenerator.class);

    public abstract Iterable<VcfPathSegment> forVcf(PicardHtsPath var1);

    public static VcfPathSegmentGenerator byWholeContigSubdividingWithWidth(long segmentWidth) {
        return WidthLimitingDecorator.wrapping(ByWholeContig.getInstance(), segmentWidth);
    }

    public static <T> VcfPathSegmentGenerator excludingNonOverlaps(final VcfPathSegmentGenerator strategy, final OverlapDetector<T> overlaps) {
        return new VcfPathSegmentGenerator(){

            @Override
            public Iterable<VcfPathSegment> forVcf(PicardHtsPath vcf) {
                return StreamSupport.stream(strategy.forVcf(vcf).spliterator(), false).filter(segment -> {
                    boolean keep;
                    boolean bl = keep = !overlaps.getOverlaps((Locatable)new Interval(segment.contig(), segment.start(), segment.stop())).isEmpty();
                    if (!keep) {
                        LOG.debug(new Object[]{String.format("Ignoring segment because it does not overlap with detector, %s::%s:%s-%s", new Object[]{segment.vcf(), segment.contig(), segment.start(), segment.stop()})});
                    }
                    return keep;
                }).collect(Collectors.toList());
            }
        };
    }

    static class ByWholeContig
    extends VcfPathSegmentGenerator {
        private static final ByWholeContig singleton = new ByWholeContig();

        ByWholeContig() {
        }

        public static ByWholeContig getInstance() {
            return singleton;
        }

        @Override
        public Iterable<VcfPathSegment> forVcf(PicardHtsPath vcf) {
            List<SAMSequenceRecord> samSequenceRecords = ByWholeContig.readSequences(vcf.toPath());
            return samSequenceRecords.stream().map(samSequenceRecord -> VcfPathSegment.ofWholeSequence(samSequenceRecord, vcf)).collect(Collectors.toList());
        }

        private static List<SAMSequenceRecord> readSequences(Path vcf) {
            VCFFileReader reader = new VCFFileReader(vcf);
            VCFHeader header = reader.getFileHeader();
            SAMSequenceDictionary dict = header.getSequenceDictionary();
            reader.close();
            return dict.getSequences();
        }
    }

    static final class WidthLimitingDecorator
    extends VcfPathSegmentGenerator {
        final VcfPathSegmentGenerator underlyingStrategy;
        final long width;

        public static WidthLimitingDecorator wrapping(VcfPathSegmentGenerator basis, long maximumWidth) {
            return new WidthLimitingDecorator(basis, maximumWidth);
        }

        private WidthLimitingDecorator(VcfPathSegmentGenerator underlyingStrategy, long maximumWidth) {
            this.underlyingStrategy = underlyingStrategy;
            this.width = maximumWidth - 1L;
        }

        @Override
        public Iterable<VcfPathSegment> forVcf(PicardHtsPath vcf) {
            return StreamSupport.stream(this.underlyingStrategy.forVcf(vcf).spliterator(), false).flatMap(vcfFileSegment -> StreamSupport.stream(new VcfPathSegmentSubdivider((VcfPathSegment)vcfFileSegment).spliterator(), false)).collect(Collectors.toList());
        }

        private final class VcfPathSegmentSubdivider
        implements Iterable<VcfPathSegment> {
            final VcfPathSegment basis;

            private VcfPathSegmentSubdivider(VcfPathSegment basis) {
                this.basis = basis;
            }

            @Override
            public Iterator<VcfPathSegment> iterator() {
                return new Iterator<VcfPathSegment>(){
                    int nextStart;
                    {
                        this.nextStart = VcfPathSegmentSubdivider.this.basis.start();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextStart <= VcfPathSegmentSubdivider.this.basis.stop();
                    }

                    @Override
                    public VcfPathSegment next() {
                        final int start = this.nextStart;
                        VcfPathSegment ret = new VcfPathSegment(){

                            @Override
                            public int start() {
                                return start;
                            }

                            @Override
                            public int stop() {
                                return Ints.checkedCast((long)Math.min((long)start + WidthLimitingDecorator.this.width, (long)VcfPathSegmentSubdivider.this.basis.stop()));
                            }

                            @Override
                            public String contig() {
                                return VcfPathSegmentSubdivider.this.basis.contig();
                            }

                            @Override
                            public PicardHtsPath vcf() {
                                return VcfPathSegmentSubdivider.this.basis.vcf();
                            }
                        };
                        this.nextStart = (int)((long)this.nextStart + (WidthLimitingDecorator.this.width + 1L));
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
    }
}

