/*
 * Decompiled with CFR 0.152.
 */
package com.brucecloud.fastclone;

import com.brucecloud.fastclone.cloner.Cloner;
import com.brucecloud.fastclone.config.Config;
import com.brucecloud.fastclone.config.DefaultConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastClone {
    private static Logger logger = LoggerFactory.getLogger(FastClone.class);
    private Config config;
    private boolean references = true;
    private boolean copyReferences = true;
    private boolean copyShallow;

    public Config getConfig() {
        return this.config;
    }

    public boolean getReferences() {
        return this.references;
    }

    public void setReferences(boolean references) {
        this.references = references;
    }

    public boolean isCopyReferences() {
        return this.copyReferences;
    }

    public void setCopyReferences(boolean copyReferences) {
        this.copyReferences = copyReferences;
    }

    public FastClone() {
        this.init();
    }

    private void init() {
        this.config = new DefaultConfig();
    }

    public <T> T clone(T t) throws Exception {
        if (t == null) {
            return null;
        }
        if (this.copyShallow) {
            return t;
        }
        Cloner<T> cloner = this.getDefaultCloner(t);
        if (cloner != null) {
            return cloner.copy(this, t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T cloneShallow(T t) throws Exception {
        if (t == null) {
            return null;
        }
        this.copyShallow = true;
        try {
            Cloner<T> cloner = this.getDefaultCloner(t);
            if (cloner != null) {
                T t2 = cloner.copy(this, t);
                return t2;
            }
            T t3 = null;
            return t3;
        }
        finally {
            this.copyShallow = false;
        }
    }

    private <T> Cloner<T> getDefaultCloner(T t) {
        if (t instanceof Enum) {
            return this.config.getDefaultCloner(this, Enum.class);
        }
        return this.config.getDefaultCloner(this, t.getClass());
    }
}

