/*
 * Decompiled with CFR 0.152.
 */
package com.brucecloud.fastclone.cloner;

import com.brucecloud.fastclone.FastClone;
import com.brucecloud.fastclone.cloner.Cloner;
import java.lang.reflect.Constructor;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class DateCloner
extends Cloner<Date> {
    @Override
    public Date copy(FastClone fastClone, Date original) throws Exception {
        return this.create(original.getClass(), original.getTime());
    }

    private Date create(Class<? extends Date> type, long time) throws Exception {
        if (type == Date.class || type == null) {
            return new Date(time);
        }
        if (type == Timestamp.class) {
            return new Timestamp(time);
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(time);
        }
        if (type == Time.class) {
            return new Time(time);
        }
        try {
            Constructor<? extends Date> constructor = type.getConstructor(Long.TYPE);
            if (!constructor.isAccessible()) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return constructor.newInstance(time);
        }
        catch (Exception ex) {
            return new Date(time);
        }
    }
}

