/*
 * Decompiled with CFR 0.152.
 */
package com.brucecloud.fastclone.cloner;

import com.brucecloud.fastclone.FastClone;
import com.brucecloud.fastclone.cloner.Cloner;
import com.brucecloud.fastclone.field.CachedField;
import com.brucecloud.fastclone.field.CachedFieldFactory;
import com.brucecloud.fastclone.util.ClassUtil;
import com.brucecloud.fastclone.util.UnsafeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FieldCloner<T>
extends Cloner<T> {
    public final FastClone fastClone;
    public final Class type;
    private CachedField[] fields = new CachedField[0];
    private static CachedFieldFactory unsafeFieldFactory;
    private static final ConcurrentHashMap<Class<?>, List<Field>> fieldsCache;
    private static Map<Class, CachedField[]> fieldMap;

    public FieldCloner(FastClone fastClone, Class type) {
        this.fastClone = fastClone;
        this.type = type;
        this.initCacheFields(type);
    }

    @Override
    public T copy(FastClone fastClone, T original) throws Exception {
        Object copy = original.getClass().newInstance();
        for (CachedField field : this.fields) {
            field.copy(original, copy);
        }
        return (T)copy;
    }

    public void initCacheFields(Class type) {
        this.fields = fieldMap.get(type);
        if (this.fields != null) {
            return;
        }
        List<Field> fieldList = this.getAllFields(type);
        ArrayList<CachedField> cachedFields = new ArrayList<CachedField>(fieldList.size());
        for (Field field : fieldList) {
            int accessIndex = -1;
            cachedFields.add(this.newCachedField(field, accessIndex));
        }
        this.fields = cachedFields.toArray(new CachedField[cachedFields.size()]);
        fieldMap.putIfAbsent(type, this.fields);
    }

    private List<Field> getAllFields(Class<?> type) {
        List<Field> allFields = fieldsCache.get(type);
        if (allFields == null) {
            allFields = new ArrayList<Field>();
            for (Class<?> nextClass = type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
                Field[] declaredFields = nextClass.getDeclaredFields();
                if (declaredFields == null) continue;
                for (Field f : declaredFields) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    allFields.add(f);
                }
            }
            fieldsCache.putIfAbsent(type, allFields);
        }
        return allFields;
    }

    private CachedField newCachedField(Field field, int accessIndex) {
        Class[] fieldClass = new Class[]{field.getType()};
        CachedField cachedField = this.newMatchingCachedField(field, fieldClass[0]);
        cachedField.field = field;
        cachedField.offset = UnsafeUtil.unsafe().objectFieldOffset(field);
        cachedField.accessIndex = accessIndex;
        boolean bl = cachedField.canBeNull = !fieldClass[0].isPrimitive();
        if (ClassUtil.isFinal(fieldClass[0])) {
            cachedField.valueClass = fieldClass[0];
        }
        return cachedField;
    }

    private CachedField newMatchingCachedField(Field field, Class fieldClass) {
        return this.getUnsafeFieldFactory().createCachedField(fieldClass, field, this);
    }

    private CachedFieldFactory getUnsafeFieldFactory() {
        if (unsafeFieldFactory == null) {
            try {
                unsafeFieldFactory = (CachedFieldFactory)this.getClass().getClassLoader().loadClass("com.brucecloud.fastclone.field.UnsafeCachedFieldFactory").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create UnsafeFieldFactory", e);
            }
        }
        return unsafeFieldFactory;
    }

    static {
        fieldsCache = new ConcurrentHashMap();
        fieldMap = new ConcurrentHashMap<Class, CachedField[]>();
    }
}

