/*
 * Decompiled with CFR 0.152.
 */
package com.brucecloud.fastclone.cloner;

import com.brucecloud.fastclone.cloner.MapCloner;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class TreeMapCloner
extends MapCloner {
    @Override
    protected Map createCopy(Map original) throws Exception {
        return this.createTreeMap(original.getClass(), ((TreeMap)original).comparator());
    }

    private TreeMap createTreeMap(Class<? extends Map> type, Comparator comparator) throws Exception {
        if (type != TreeMap.class && type != null) {
            Constructor<? extends Map> constructor = type.getConstructor(Comparator.class);
            if (!constructor.isAccessible()) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return (TreeMap)constructor.newInstance(comparator);
        }
        return new TreeMap(comparator);
    }
}

