/*
 * Decompiled with CFR 0.152.
 */
package com.brucecloud.fastclone.cloner;

import com.brucecloud.fastclone.cloner.CollectionCloner;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class TreeSetCloner
extends CollectionCloner {
    @Override
    protected TreeSet createCopy(Collection original) throws Exception {
        return this.createTreeSet(original.getClass(), ((TreeSet)original).comparator());
    }

    private TreeSet createTreeSet(Class<? extends Collection> type, Comparator comparator) throws Exception {
        if (type != TreeSet.class && type != null) {
            Constructor<? extends Collection> constructor = type.getConstructor(Comparator.class);
            if (!constructor.isAccessible()) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return (TreeSet)constructor.newInstance(comparator);
        }
        return new TreeSet(comparator);
    }
}

