/*
 * Decompiled with CFR 0.152.
 */
package com.brucecloud.fastclone.config;

import com.brucecloud.fastclone.FastClone;
import com.brucecloud.fastclone.cloner.Cloner;
import com.brucecloud.fastclone.cloner.FieldCloner;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Config {
    private Map<Class<?>, Cloner<?>> defaultCloner = new ConcurrentHashMap();
    private Map<Class, Boolean> referenceResolver = new ConcurrentHashMap<Class, Boolean>();

    public Cloner getDefaultCloner(FastClone fastClone, Class type) {
        Cloner<?> cloner = this.defaultCloner.get(type);
        if (cloner == null) {
            for (Map.Entry<Class<?>, Cloner<?>> entry : this.defaultCloner.entrySet()) {
                Class<?> key = entry.getKey();
                if (!key.isAssignableFrom(type)) continue;
                this.defaultCloner.putIfAbsent(type, entry.getValue());
                cloner = entry.getValue();
                break;
            }
        }
        if (cloner == null) {
            cloner = new FieldCloner(fastClone, type);
            this.defaultCloner.putIfAbsent(type, cloner);
        }
        return cloner;
    }

    public boolean useReference(Class type) {
        return this.referenceResolver.get(type) == null ? false : this.referenceResolver.get(type);
    }

    protected void registerCloner(Class type, Cloner cloner) {
        if (type == null || cloner == null) {
            return;
        }
        this.defaultCloner.put(type, cloner);
    }

    protected void registerReferenceResolver(Class type) {
        if (type == null) {
            return;
        }
        this.referenceResolver.put(type, true);
    }

    protected abstract void registerDefaultCloner();

    protected abstract void registerDefaultReferenceResolver();
}

