/*
 * Decompiled with CFR 0.152.
 */
package com.brucecloud.fastclone.field;

import com.brucecloud.fastclone.FastClone;
import com.brucecloud.fastclone.cloner.FieldCloner;
import com.brucecloud.fastclone.field.CachedField;

public class ObjectField
extends CachedField {
    private final FieldCloner fieldCloner;
    private final Class type;
    final FastClone fastClone;

    ObjectField(FieldCloner fieldCloner) {
        this.fieldCloner = fieldCloner;
        this.fastClone = fieldCloner.fastClone;
        this.type = fieldCloner.type;
    }

    public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.field.get(object);
    }

    public void setField(Object object, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(object, value);
    }

    @Override
    public void copy(Object original, Object copy) throws Exception {
        this.setField(copy, this.fastClone.clone(this.getField(original)));
    }

    static final class ObjectDoubleField
    extends ObjectField {
        public ObjectDoubleField(FieldCloner fieldCloner) {
            super(fieldCloner);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getDouble(object);
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setDouble(copy, this.field.getDouble(original));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class ObjectLongField
    extends ObjectField {
        public ObjectLongField(FieldCloner fieldCloner) {
            super(fieldCloner);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getLong(object);
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setLong(copy, this.field.getLong(original));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class ObjectCharField
    extends ObjectField {
        public ObjectCharField(FieldCloner fieldCloner) {
            super(fieldCloner);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return Character.valueOf(this.field.getChar(object));
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setChar(copy, this.field.getChar(original));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class ObjectBooleanField
    extends ObjectField {
        public ObjectBooleanField(FieldCloner fieldCloner) {
            super(fieldCloner);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getBoolean(object);
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setBoolean(copy, this.field.getBoolean(original));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class ObjectByteField
    extends ObjectField {
        public ObjectByteField(FieldCloner fieldCloner) {
            super(fieldCloner);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getByte(object);
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setByte(copy, this.field.getByte(original));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class ObjectShortField
    extends ObjectField {
        public ObjectShortField(FieldCloner fieldCloner) {
            super(fieldCloner);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getShort(object);
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setShort(copy, this.field.getShort(original));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class ObjectFloatField
    extends ObjectField {
        public ObjectFloatField(FieldCloner fieldCloner) {
            super(fieldCloner);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return Float.valueOf(this.field.getFloat(object));
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setFloat(copy, this.field.getFloat(original));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class ObjectIntField
    extends ObjectField {
        public ObjectIntField(FieldCloner fieldCloner) {
            super(fieldCloner);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getInt(object);
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setInt(copy, this.field.getInt(original));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

