/*
 * Decompiled with CFR 0.152.
 */
package com.brucecloud.fastclone.field;

import com.brucecloud.fastclone.cloner.FieldCloner;
import com.brucecloud.fastclone.field.CachedField;
import com.brucecloud.fastclone.field.ObjectField;
import com.brucecloud.fastclone.util.UnsafeUtil;
import java.lang.reflect.Field;

class UnsafeCacheFields {
    UnsafeCacheFields() {
    }

    static final class UnsafeObjectField
    extends ObjectField {
        public UnsafeObjectField(FieldCloner fieldCloner) {
            super(fieldCloner);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            if (this.offset >= 0L) {
                return UnsafeUtil.unsafe().getObject(object, this.offset);
            }
            throw new RuntimeException("Unknown offset");
        }

        @Override
        public void setField(Object object, Object value) throws IllegalArgumentException, IllegalAccessException {
            if (this.offset == -1L) {
                throw new RuntimeException("Unknown offset");
            }
            UnsafeUtil.unsafe().putObject(object, this.offset, value);
        }

        @Override
        public void copy(Object original, Object copy) throws Exception {
            if (this.offset == -1L) {
                throw new RuntimeException("Unknown offset");
            }
            UnsafeUtil.unsafe().putObject(copy, this.offset, this.fastClone.clone(UnsafeUtil.unsafe().getObject(original, this.offset)));
        }
    }

    static final class UnsafeRegionField
    extends UnsafeCachedField {
        final long len;
        static final boolean bulkReadsSupported = false;

        public UnsafeRegionField(long offset, long len) {
            super(offset);
            this.len = len;
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().copyMemory(original, this.offset, copy, this.offset, this.len);
        }
    }

    static final class UnsafeStringField
    extends UnsafeCachedField {
        public UnsafeStringField(Field f) {
            super(UnsafeUtil.unsafe().objectFieldOffset(f));
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().putObject(copy, this.offset, UnsafeUtil.unsafe().getObject(original, this.offset));
        }
    }

    static final class UnsafeDoubleField
    extends UnsafeCachedField {
        public UnsafeDoubleField(Field f) {
            super(UnsafeUtil.unsafe().objectFieldOffset(f));
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().putDouble(copy, this.offset, UnsafeUtil.unsafe().getDouble(original, this.offset));
        }
    }

    static final class UnsafeLongField
    extends UnsafeCachedField {
        public UnsafeLongField(Field f) {
            super(UnsafeUtil.unsafe().objectFieldOffset(f));
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().putLong(copy, this.offset, UnsafeUtil.unsafe().getLong(original, this.offset));
        }
    }

    static final class UnsafeCharField
    extends UnsafeCachedField {
        public UnsafeCharField(Field f) {
            super(UnsafeUtil.unsafe().objectFieldOffset(f));
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().putChar(copy, this.offset, UnsafeUtil.unsafe().getChar(original, this.offset));
        }
    }

    static final class UnsafeBooleanField
    extends UnsafeCachedField {
        public UnsafeBooleanField(Field f) {
            super(UnsafeUtil.unsafe().objectFieldOffset(f));
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().putBoolean(copy, this.offset, UnsafeUtil.unsafe().getBoolean(original, this.offset));
        }
    }

    static final class UnsafeByteField
    extends UnsafeCachedField {
        public UnsafeByteField(Field f) {
            super(UnsafeUtil.unsafe().objectFieldOffset(f));
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().putByte(copy, this.offset, UnsafeUtil.unsafe().getByte(original, this.offset));
        }
    }

    static final class UnsafeShortField
    extends UnsafeCachedField {
        public UnsafeShortField(Field f) {
            super(UnsafeUtil.unsafe().objectFieldOffset(f));
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().putShort(copy, this.offset, UnsafeUtil.unsafe().getShort(original, this.offset));
        }
    }

    static final class UnsafeFloatField
    extends UnsafeCachedField {
        public UnsafeFloatField(Field f) {
            super(UnsafeUtil.unsafe().objectFieldOffset(f));
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().putFloat(copy, this.offset, UnsafeUtil.unsafe().getFloat(original, this.offset));
        }
    }

    static final class UnsafeIntField
    extends UnsafeCachedField {
        public UnsafeIntField(Field f) {
            super(UnsafeUtil.unsafe().objectFieldOffset(f));
        }

        @Override
        public void copy(Object original, Object copy) {
            UnsafeUtil.unsafe().putInt(copy, this.offset, UnsafeUtil.unsafe().getInt(original, this.offset));
        }
    }

    static abstract class UnsafeCachedField
    extends CachedField {
        UnsafeCachedField(long offset) {
            this.offset = offset;
        }
    }
}

