/*
 * Decompiled with CFR 0.152.
 */
package com.brucecloud.fastclone.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class UnsafeUtil {
    private static Logger logger = LoggerFactory.getLogger(UnsafeUtil.class);
    private static final Unsafe _unsafe;
    private static final long byteArrayBaseOffset;
    private static final long floatArrayBaseOffset;
    private static final long doubleArrayBaseOffset;
    private static final long intArrayBaseOffset;
    private static final long longArrayBaseOffset;
    private static final long shortArrayBaseOffset;
    private static final long charArrayBaseOffset;
    private static Constructor<? extends ByteBuffer> directByteBufferConstr;

    public static Unsafe unsafe() {
        return _unsafe;
    }

    public static Field[] sortFieldsByOffset(List<Field> allFields) {
        Field[] allFieldsArray = allFields.toArray(new Field[0]);
        Comparator fieldOffsetComparator = (f1, f2) -> {
            long offset2;
            long offset1 = UnsafeUtil.unsafe().objectFieldOffset((Field)f1);
            if (offset1 < (offset2 = UnsafeUtil.unsafe().objectFieldOffset((Field)f2))) {
                return -1;
            }
            if (offset1 == offset2) {
                return 0;
            }
            return 1;
        };
        Arrays.sort(allFieldsArray, fieldOffsetComparator);
        return allFieldsArray;
    }

    public static ByteBuffer getDirectBufferAt(long address, int size) {
        if (directByteBufferConstr == null) {
            return null;
        }
        try {
            return directByteBufferConstr.newInstance(address, size, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot allocate ByteBuffer at a given address: " + address, e);
        }
    }

    public static void releaseBuffer(ByteBuffer byteBuffer) {
        Cleaner cleaner;
        if (byteBuffer != null && byteBuffer.isDirect() && (cleaner = ((DirectBuffer)((Object)byteBuffer)).cleaner()) != null) {
            cleaner.clean();
        }
    }

    static {
        Unsafe tmpUnsafe = null;
        long tmpByteArrayBaseOffset = 0L;
        long tmpFloatArrayBaseOffset = 0L;
        long tmpDoubleArrayBaseOffset = 0L;
        long tmpIntArrayBaseOffset = 0L;
        long tmpLongArrayBaseOffset = 0L;
        long tmpShortArrayBaseOffset = 0L;
        long tmpCharArrayBaseOffset = 0L;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            tmpUnsafe = (Unsafe)field.get(null);
            tmpByteArrayBaseOffset = tmpUnsafe.arrayBaseOffset(byte[].class);
            tmpCharArrayBaseOffset = tmpUnsafe.arrayBaseOffset(char[].class);
            tmpShortArrayBaseOffset = tmpUnsafe.arrayBaseOffset(short[].class);
            tmpIntArrayBaseOffset = tmpUnsafe.arrayBaseOffset(int[].class);
            tmpFloatArrayBaseOffset = tmpUnsafe.arrayBaseOffset(float[].class);
            tmpLongArrayBaseOffset = tmpUnsafe.arrayBaseOffset(long[].class);
            tmpDoubleArrayBaseOffset = tmpUnsafe.arrayBaseOffset(double[].class);
        }
        catch (Exception e) {
            logger.error("sun.misc.Unsafe is not accessible or not available. Use of sun.misc.Unsafe should be disabled", (Throwable)e);
        }
        byteArrayBaseOffset = tmpByteArrayBaseOffset;
        charArrayBaseOffset = tmpCharArrayBaseOffset;
        shortArrayBaseOffset = tmpShortArrayBaseOffset;
        intArrayBaseOffset = tmpIntArrayBaseOffset;
        floatArrayBaseOffset = tmpFloatArrayBaseOffset;
        longArrayBaseOffset = tmpLongArrayBaseOffset;
        doubleArrayBaseOffset = tmpDoubleArrayBaseOffset;
        _unsafe = tmpUnsafe;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        try {
            directByteBufferConstr = byteBuffer.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
            directByteBufferConstr.setAccessible(true);
        }
        catch (Exception e) {
            directByteBufferConstr = null;
        }
    }
}

