/*
 * Decompiled with CFR 0.152.
 */
package com.github.bsideup.jabel;

import com.github.bsideup.jabel.Desugar;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;

class RecordsRetrofittingTaskListener
implements TaskListener {
    final TreeMaker make;
    final Symtab syms;
    final Names names;
    final Log log;
    TreeScanner<Void, Void> recordsScanner = new TreeScanner<Void, Void>(){

        @Override
        public Void visitClass(ClassTree node, Void aVoid) {
            if (!"RECORD".equals(node.getKind().toString())) {
                return (Void)super.visitClass(node, aVoid);
            }
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node;
            if (classDecl.extending == null) {
                classDecl.extending = RecordsRetrofittingTaskListener.this.make.Type(RecordsRetrofittingTaskListener.this.syms.objectType);
            }
            Name methodName = RecordsRetrofittingTaskListener.this.names.toString;
            List<Type> argTypes = List.nil();
            if (!this.containsMethod(classDecl, methodName)) {
                JCTree.JCMethodDecl methodDecl = RecordsRetrofittingTaskListener.this.make.MethodDef(new Symbol.MethodSymbol(1L, methodName, new Type.MethodType(argTypes, RecordsRetrofittingTaskListener.this.syms.stringType, List.nil(), RecordsRetrofittingTaskListener.this.syms.methodClass), RecordsRetrofittingTaskListener.this.syms.objectType.tsym), RecordsRetrofittingTaskListener.this.make.Block(0L, RecordsRetrofittingTaskListener.this.generateToString(classDecl)));
                classDecl.defs = classDecl.defs.append(methodDecl);
            }
            methodName = RecordsRetrofittingTaskListener.this.names.hashCode;
            argTypes = List.nil();
            if (!this.containsMethod(classDecl, methodName)) {
                classDecl.defs = classDecl.defs.append(RecordsRetrofittingTaskListener.this.make.MethodDef(new Symbol.MethodSymbol(1L, methodName, new Type.MethodType(argTypes, RecordsRetrofittingTaskListener.this.syms.intType, List.nil(), RecordsRetrofittingTaskListener.this.syms.methodClass), RecordsRetrofittingTaskListener.this.syms.objectType.tsym), RecordsRetrofittingTaskListener.this.make.Block(0L, RecordsRetrofittingTaskListener.this.generateHashCode(classDecl))));
            }
            methodName = RecordsRetrofittingTaskListener.this.names.equals;
            argTypes = List.of(RecordsRetrofittingTaskListener.this.syms.objectType);
            if (!this.containsMethod(classDecl, methodName)) {
                Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(17L, methodName, new Type.MethodType(argTypes, RecordsRetrofittingTaskListener.this.syms.booleanType, List.nil(), RecordsRetrofittingTaskListener.this.syms.methodClass), RecordsRetrofittingTaskListener.this.syms.objectType.tsym);
                Symbol.VarSymbol firstParameter = (Symbol.VarSymbol)methodSymbol.params().head;
                JCTree.JCMethodDecl methodDecl = RecordsRetrofittingTaskListener.this.make.MethodDef(methodSymbol, RecordsRetrofittingTaskListener.this.make.Block(0L, RecordsRetrofittingTaskListener.this.generateEquals(classDecl, firstParameter.name)));
                ((JCTree.JCVariableDecl)methodDecl.params.head).pos = classDecl.pos;
                classDecl.defs = classDecl.defs.append(methodDecl);
            }
            return (Void)super.visitClass(node, aVoid);
        }

        private boolean containsMethod(JCTree.JCClassDecl classDecl, Name name) {
            return classDecl.defs.stream().filter(JCTree.JCMethodDecl.class::isInstance).map(JCTree.JCMethodDecl.class::cast).anyMatch(def -> {
                if (def.getName() != name) {
                    return false;
                }
                if (name == RecordsRetrofittingTaskListener.this.names.equals) {
                    if (def.params.size() != 1) {
                        return false;
                    }
                    JCTree.JCVariableDecl param = def.params.get(0);
                    switch (param.getType().toString()) {
                        case "java.lang.Object": 
                        case "Object": {
                            return true;
                        }
                    }
                    return false;
                }
                return true;
            });
        }
    };

    public RecordsRetrofittingTaskListener(Context context) {
        this.make = TreeMaker.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
    }

    @Override
    public void started(TaskEvent e) {
        switch (e.getKind()) {
            case ENTER: {
                this.recordsScanner.scan(e.getCompilationUnit(), null);
                new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitClass(ClassTree node, Void aVoid) {
                        if ("RECORD".equals(node.getKind().toString())) {
                            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node;
                            if (classDecl.extending == null) {
                                classDecl.extending = RecordsRetrofittingTaskListener.this.make.Type(RecordsRetrofittingTaskListener.this.syms.objectType);
                            }
                        }
                        return (Void)super.visitClass(node, aVoid);
                    }
                }.scan(e.getCompilationUnit(), null);
                break;
            }
            case ANALYZE: {
                new MandatoryDesugarAnnotationTreeScanner(this.log, e.getCompilationUnit()).scan(e.getCompilationUnit(), null);
            }
        }
    }

    @Override
    public void finished(TaskEvent e) {
    }

    private Stream<JCTree.JCVariableDecl> getRecordComponents(JCTree.JCClassDecl classDecl) {
        return classDecl.getMembers().stream().filter(JCTree.JCVariableDecl.class::isInstance).map(JCTree.JCVariableDecl.class::cast).filter(it -> !it.getModifiers().getFlags().contains((Object)Modifier.STATIC));
    }

    private List<JCTree.JCStatement> generateToString(JCTree.JCClassDecl classDecl) {
        JCTree.JCPolyExpression stringBuilder = this.make.NewClass(null, null, this.make.QualIdent(this.syms.stringBuilderType.tsym), List.of(this.make.Literal(classDecl.name + "[")), null);
        Iterator iterator = this.getRecordComponents(classDecl).iterator();
        while (iterator.hasNext()) {
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)iterator.next();
            Name fieldName = fieldDecl.name;
            stringBuilder = this.make.App(this.make.Select((JCTree.JCExpression)stringBuilder, this.names.append).setType(this.syms.stringBuilderType), List.of(this.make.Literal(fieldName + "=")));
            stringBuilder = this.make.App(this.make.Select((JCTree.JCExpression)stringBuilder, this.names.append).setType(this.syms.stringBuilderType), List.of(this.make.Select(this.make.This(Type.noType), fieldName)));
            if (!iterator.hasNext()) continue;
            stringBuilder = this.make.App(this.make.Select((JCTree.JCExpression)stringBuilder, this.names.append).setType(this.syms.stringBuilderType), List.of(this.make.Literal(",")));
        }
        stringBuilder = this.make.App(this.make.Select((JCTree.JCExpression)stringBuilder, this.names.append).setType(this.syms.stringBuilderType), List.of(this.make.Literal("]")));
        return List.of(this.make.Return(this.make.App(this.make.Select((JCTree.JCExpression)stringBuilder, this.names.toString).setType(this.syms.stringType))));
    }

    private List<JCTree.JCStatement> generateEquals(JCTree.JCClassDecl classDecl, Name otherName) {
        ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
        statements.add(this.make.If(this.make.Binary(JCTree.Tag.EQ, this.make.This(Type.noType), this.make.Ident(otherName)), this.make.Return(this.make.Literal(true)), null));
        statements.add(this.make.If(this.make.Binary(JCTree.Tag.EQ, this.make.Ident(otherName), this.make.Literal(TypeTag.BOT, null)), this.make.Return(this.make.Literal(false)), null));
        statements.add(this.make.If(this.make.Binary(JCTree.Tag.EQ, this.make.App(this.make.Select((JCTree.JCExpression)this.make.Ident(otherName), this.names.getClass).setType(this.syms.classType)), this.make.App(this.make.Select(this.make.This(Type.noType), this.names.getClass).setType(this.syms.classType))), this.make.Block(0L, List.nil()), this.make.Return(this.make.Literal(false))));
        Iterator iterator = this.getRecordComponents(classDecl).iterator();
        while (iterator.hasNext()) {
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)iterator.next();
            JCTree.JCFieldAccess myFieldAccess = this.make.Select(this.make.This(Type.noType), fieldDecl.name);
            JCTree.JCFieldAccess otherFieldAccess = this.make.Select((JCTree.JCExpression)this.make.TypeCast(this.make.Ident(classDecl.name), (JCTree.JCExpression)this.make.Ident(otherName)), fieldDecl.name);
            JCTree.JCExpression condition = fieldDecl.getType() instanceof JCTree.JCPrimitiveTypeTree ? this.make.Binary(JCTree.Tag.EQ, otherFieldAccess, myFieldAccess) : this.make.App(this.make.Select(this.make.QualIdent(this.syms.objectsType.tsym), this.names.equals).setType(this.syms.objectsType), List.of(otherFieldAccess, myFieldAccess));
            statements.add(this.make.If(condition, this.make.Block(0L, List.nil()), this.make.Return(this.make.Literal(false))));
        }
        statements.add(this.make.Return(this.make.Literal(true)));
        return statements.toList();
    }

    private List<JCTree.JCStatement> generateHashCode(JCTree.JCClassDecl classDecl) {
        ListBuffer<JCTree.JCExpression> expressions = new ListBuffer<JCTree.JCExpression>();
        Iterator iterator = this.getRecordComponents(classDecl).iterator();
        block5: while (iterator.hasNext()) {
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)iterator.next();
            JCTree fType = fieldDecl.getType();
            JCTree.JCFieldAccess myFieldAccess = this.make.Select(this.make.This(Type.noType), fieldDecl.name);
            if (fType instanceof JCTree.JCPrimitiveTypeTree) {
                switch (((JCTree.JCPrimitiveTypeTree)fType).getPrimitiveTypeKind()) {
                    case LONG: {
                        expressions.append(this.longToIntForHashCode(myFieldAccess));
                        continue block5;
                    }
                    case FLOAT: {
                        expressions.append(this.make.Conditional(this.make.Binary(JCTree.Tag.NE, myFieldAccess, this.make.Literal(Float.valueOf(0.0f))), this.make.App(this.make.Select((JCTree.JCExpression)this.make.Ident(this.names.fromString("Float")), this.names.fromString("floatToIntBits")).setType(this.syms.intType), List.of(myFieldAccess)), this.make.Literal(TypeTag.INT, 0)));
                        continue block5;
                    }
                    case DOUBLE: {
                        expressions.append(this.longToIntForHashCode(this.make.App(this.make.Select((JCTree.JCExpression)this.make.Ident(this.names.fromString("Double")), this.names.fromString("doubleToLongBits")).setType(this.syms.intType), List.of(myFieldAccess))));
                        continue block5;
                    }
                }
                expressions.append(myFieldAccess);
                continue;
            }
            if (fType instanceof JCTree.JCArrayTypeTree) {
                expressions.append(this.make.App(this.make.Select((JCTree.JCExpression)this.make.Select((JCTree.JCExpression)this.make.Select((JCTree.JCExpression)this.make.Ident(this.names.fromString("java")), this.names.fromString("util")), this.names.fromString("Arrays")), this.names.fromString("hashCode")).setType(this.syms.intType), List.of(myFieldAccess)));
                continue;
            }
            expressions.append(this.make.Conditional(this.make.Binary(JCTree.Tag.NE, myFieldAccess, this.make.Literal(TypeTag.BOT, null)), this.make.App(this.make.Select((JCTree.JCExpression)myFieldAccess, this.names.hashCode).setType(this.syms.intType)), this.make.Literal(0)));
        }
        ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
        Name resultName = this.names.fromString("result");
        statements.append(this.make.VarDef(this.make.Modifiers(0L), resultName, this.make.TypeIdent(this.syms.intType.getTag()), this.make.Literal(0)));
        for (JCTree.JCExpression expression : expressions) {
            statements.append(this.make.Exec(this.make.Assign(this.make.Ident(resultName), this.make.Binary(JCTree.Tag.PLUS, this.make.Binary(JCTree.Tag.MUL, this.make.Literal(TypeTag.INT, 31), this.make.Ident(resultName)), expression))));
        }
        statements.append(this.make.Return(this.make.Ident(resultName)));
        return statements.toList();
    }

    public JCTree.JCExpression longToIntForHashCode(JCTree.JCExpression ref) {
        return this.make.TypeCast(this.make.TypeIdent(this.syms.intType.getTag()), (JCTree.JCExpression)this.make.Parens(this.make.Binary(JCTree.Tag.BITXOR, ref, this.make.Parens(this.make.Binary(JCTree.Tag.USR, ref, this.make.Literal(32))))));
    }

    private static class MandatoryDesugarAnnotationTreeScanner
    extends TreeScanner<Void, Void> {
        private final Log log;
        private final CompilationUnitTree compilationUnit;

        public MandatoryDesugarAnnotationTreeScanner(Log log, CompilationUnitTree compilationUnit) {
            this.log = log;
            this.compilationUnit = compilationUnit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitClass(ClassTree node, Void aVoid) {
            if ("RECORD".equals(node.getKind().toString()) && node.getModifiers().getAnnotations().stream().noneMatch(annotation -> {
                Type type = ((JCTree.JCAnnotation)annotation).type;
                return Desugar.class.getName().equals(type.toString());
            })) {
                JavaFileObject oldSource = this.log.useSource(this.compilationUnit.getSourceFile());
                try {
                    this.log.error((JCTree.JCClassDecl)node, new JCDiagnostic.Error("jabel", "missing.desugar.on.record", "Must be annotated with @Desugar"));
                }
                finally {
                    this.log.useSource(oldSource);
                }
            }
            return (Void)super.visitClass(node, aVoid);
        }
    }
}

