/*
 * Decompiled with CFR 0.152.
 */
package com.github.buckelieg.minify.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.maven.plugin.logging.Log;

public class SourceFilesEnumeration
implements Enumeration<InputStream> {
    private List<File> files;
    private int current = 0;
    private boolean appendEOL;

    public SourceFilesEnumeration(Log log, List<File> files, boolean verbose) {
        this.files = files;
        for (File file : files) {
            log.info((CharSequence)("Processing source file [" + (verbose ? file.getPath() : file.getName()) + "]."));
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.current < this.files.size();
    }

    @Override
    public InputStream nextElement() {
        InputStream is;
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more files!");
        }
        if (this.appendEOL) {
            is = new ByteArrayInputStream(System.lineSeparator().getBytes());
            this.appendEOL = false;
        } else {
            File nextElement = this.files.get(this.current);
            ++this.current;
            try {
                is = new FileInputStream(nextElement);
                this.appendEOL = true;
            }
            catch (FileNotFoundException e) {
                throw new NoSuchElementException("The path [" + nextElement.getPath() + "] cannot be found.");
            }
        }
        return is;
    }
}

