/*
 * Decompiled with CFR 0.152.
 */
package com.github.buckelieg.minify.plugin;

import com.github.buckelieg.minify.common.Aggregation;
import com.github.buckelieg.minify.common.AggregationConfiguration;
import com.github.buckelieg.minify.common.ClosureConfig;
import com.github.buckelieg.minify.common.YuiConfig;
import com.github.buckelieg.minify.plugin.ProcessCSSFilesTask;
import com.github.buckelieg.minify.plugin.ProcessFilesTask;
import com.github.buckelieg.minify.plugin.ProcessJSFilesTask;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="minify", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class MinifyMojo
extends AbstractMojo {
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="bufferSize", defaultValue="4096")
    private int bufferSize;
    @Parameter(property="charset", defaultValue="${project.build.sourceEncoding}")
    private String charset;
    @Parameter(property="suffix", defaultValue=".min")
    private String suffix;
    @Parameter(property="nosuffix", defaultValue="false")
    private boolean nosuffix;
    @Parameter(property="skipMerge", defaultValue="false")
    private boolean skipMerge;
    @Parameter(property="skipMinify", defaultValue="false")
    private boolean skipMinify;
    @Parameter(property="closureSkipErrors", defaultValue="false")
    private boolean closureSkipErrors;
    @Parameter(property="webappSourceDir", defaultValue="${basedir}/src/main/webapp")
    private String webappSourceDir;
    @Parameter(property="webappTargetDir", defaultValue="${project.build.directory}/${project.build.finalName}")
    private String webappTargetDir;
    @Parameter(property="bundleConfiguration")
    private String bundleConfiguration;
    @Parameter(property="cssSourceDir", defaultValue="css")
    private String cssSourceDir;
    @Parameter(property="cssSourceFiles", alias="cssFiles")
    private ArrayList<String> cssSourceFiles;
    @Parameter(property="cssSourceIncludes", alias="cssIncludes")
    private ArrayList<String> cssSourceIncludes;
    @Parameter(property="cssSourceExcludes", alias="cssExcludes")
    private ArrayList<String> cssSourceExcludes;
    @Parameter(property="cssTargetDir")
    private String cssTargetDir;
    @Parameter(property="cssFinalFile", defaultValue="style.css")
    private String cssFinalFile;
    @Parameter(property="cssEngine", defaultValue="YUI")
    private Engine cssEngine;
    @Parameter(property="jsSourceDir", defaultValue="js")
    private String jsSourceDir;
    @Parameter(property="jsSourceFiles", alias="jsFiles")
    private ArrayList<String> jsSourceFiles;
    @Parameter(property="jsSourceIncludes", alias="jsIncludes")
    private ArrayList<String> jsSourceIncludes;
    @Parameter(property="jsSourceExcludes", alias="jsExcludes")
    private ArrayList<String> jsSourceExcludes;
    @Parameter(property="jsTargetDir")
    private String jsTargetDir;
    @Parameter(property="jsFinalFile", defaultValue="script.js")
    private String jsFinalFile;
    @Parameter(property="jsEngine", defaultValue="YUI")
    private Engine jsEngine;
    @Parameter(property="yuiLineBreak", defaultValue="-1")
    private int yuiLineBreak;
    @Parameter(property="yuiNoMunge", defaultValue="false")
    private boolean yuiNoMunge;
    @Parameter(property="yuiPreserveSemicolons", defaultValue="false")
    private boolean yuiPreserveSemicolons;
    @Parameter(property="yuiDisableOptimizations", defaultValue="false")
    private boolean yuiDisableOptimizations;
    @Parameter(property="closureLanguageIn", defaultValue="STABLE")
    private String closureLanguageIn;
    @Parameter(property="closureLanguageOut", defaultValue="NO_TRANSPILE")
    private String closureLanguageOut;
    @Parameter(property="closureEnvironment", defaultValue="BROWSER")
    private CompilerOptions.Environment closureEnvironment;
    @Parameter(property="closureCompilationLevel", defaultValue="SIMPLE_OPTIMIZATIONS")
    private String closureCompilationLevel;
    @Parameter(property="closureExterns")
    private ArrayList<String> closureExterns;
    @Parameter(property="closureCreateSourceMap", defaultValue="false")
    private boolean closureCreateSourceMap;
    @Parameter(property="closureSortDependencies", defaultValue="false")
    private boolean closureSortDependencies;
    @Parameter(property="closureWarningLevels")
    private HashMap<String, String> closureWarningLevels;
    @Parameter(property="closureAngularPass", defaultValue="false")
    private boolean closureAngularPass;
    @Parameter(property="closureExtraAnnotations")
    private ArrayList<String> closureExtraAnnotations;
    @Parameter(property="closureDefine")
    private HashMap<String, String> closureDefine;
    @Parameter(defaultValue="PARALLEL")
    private Mode executionMode;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Collection<ProcessFilesTask> processFilesTasks;
        if (this.skipMerge && this.skipMinify) {
            this.getLog().warn((CharSequence)"Both merge and minify steps are configured to be skipped.");
            return;
        }
        this.fillOptionalValues();
        YuiConfig yuiConfig = this.fillYuiConfig();
        ClosureConfig closureConfig = this.fillClosureConfig();
        try {
            processFilesTasks = this.createTasks(yuiConfig, closureConfig);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        ExecutorService executor = Mode.PARALLEL == this.executionMode ? Executors.newFixedThreadPool(processFilesTasks.size()) : Executors.newSingleThreadExecutor();
        try {
            List futures = executor.invokeAll(processFilesTasks);
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            executor.shutdown();
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void fillOptionalValues() {
        if (Strings.isNullOrEmpty((String)this.cssTargetDir)) {
            this.cssTargetDir = this.cssSourceDir;
        }
        if (Strings.isNullOrEmpty((String)this.jsTargetDir)) {
            this.jsTargetDir = this.jsSourceDir;
        }
        if (Strings.isNullOrEmpty((String)this.charset)) {
            this.charset = Charset.defaultCharset().name();
        }
    }

    private YuiConfig fillYuiConfig() {
        return new YuiConfig(this.yuiLineBreak, !this.yuiNoMunge, this.yuiPreserveSemicolons, this.yuiDisableOptimizations);
    }

    private ClosureConfig fillClosureConfig() throws MojoFailureException {
        DependencyOptions dependencyOptions = this.closureSortDependencies ? DependencyOptions.sortOnly() : DependencyOptions.none();
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        for (String extern : this.closureExterns) {
            externs.add(SourceFile.fromFile((String)(this.webappSourceDir + File.separator + extern), (Charset)Charset.forName(this.charset)));
        }
        HashMap<DiagnosticGroup, CheckLevel> warningLevels = new HashMap<DiagnosticGroup, CheckLevel>();
        for (Map.Entry<String, String> warningLevel : this.closureWarningLevels.entrySet()) {
            DiagnosticGroup diagnosticGroup = DiagnosticGroups.forName((String)warningLevel.getKey());
            if (diagnosticGroup == null) {
                throw new MojoFailureException("Failed to process closureWarningLevels: " + warningLevel.getKey() + " is an invalid DiagnosticGroup");
            }
            try {
                CheckLevel checkLevel = CheckLevel.valueOf((String)warningLevel.getValue());
                warningLevels.put(diagnosticGroup, checkLevel);
            }
            catch (IllegalArgumentException e) {
                throw new MojoFailureException("Failed to process closureWarningLevels: " + warningLevel.getKey() + " is an invalid CheckLevel");
            }
        }
        return new ClosureConfig(CompilerOptions.LanguageMode.fromString((String)this.closureLanguageIn), CompilerOptions.LanguageMode.fromString((String)this.closureLanguageOut), this.closureEnvironment, CompilationLevel.fromString((String)this.closureCompilationLevel), dependencyOptions, externs, this.closureCreateSourceMap, warningLevels, this.closureAngularPass, this.closureExtraAnnotations, this.closureDefine);
    }

    private Collection<ProcessFilesTask> createTasks(YuiConfig yuiConfig, ClosureConfig closureConfig) throws MojoFailureException, FileNotFoundException {
        ArrayList tasks = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)this.bundleConfiguration)) {
            AggregationConfiguration aggregationConfiguration;
            try (FileReader bundleConfigurationReader = new FileReader(this.bundleConfiguration);){
                aggregationConfiguration = (AggregationConfiguration)new Gson().fromJson((Reader)bundleConfigurationReader, AggregationConfiguration.class);
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to open the bundle configuration file [" + this.bundleConfiguration + "].", (Throwable)e);
            }
            for (Aggregation aggregation : aggregationConfiguration.getBundles()) {
                if (Aggregation.AggregationType.css.equals((Object)aggregation.getType())) {
                    tasks.add(this.createCSSTask(yuiConfig, closureConfig, aggregation.getFiles(), Collections.emptyList(), Collections.emptyList(), aggregation.getName()));
                    continue;
                }
                if (!Aggregation.AggregationType.js.equals((Object)aggregation.getType())) continue;
                tasks.add(this.createJSTask(yuiConfig, closureConfig, aggregation.getFiles(), Collections.emptyList(), Collections.emptyList(), aggregation.getName()));
            }
        } else {
            tasks.add(this.createCSSTask(yuiConfig, closureConfig, this.cssSourceFiles, this.cssSourceIncludes, this.cssSourceExcludes, this.cssFinalFile));
            tasks.add(this.createJSTask(yuiConfig, closureConfig, this.jsSourceFiles, this.jsSourceIncludes, this.jsSourceExcludes, this.jsFinalFile));
        }
        return tasks;
    }

    private ProcessFilesTask createCSSTask(YuiConfig yuiConfig, ClosureConfig closureConfig, List<String> cssSourceFiles, List<String> cssSourceIncludes, List<String> cssSourceExcludes, String cssFinalFile) throws FileNotFoundException {
        return new ProcessCSSFilesTask(this.getLog(), this.verbose, this.bufferSize, Charset.forName(this.charset), this.suffix, this.nosuffix, this.skipMerge, this.skipMinify, this.closureSkipErrors, this.webappSourceDir, this.webappTargetDir, this.cssSourceDir, cssSourceFiles, cssSourceIncludes, cssSourceExcludes, this.cssTargetDir, cssFinalFile, this.cssEngine, yuiConfig);
    }

    private ProcessFilesTask createJSTask(YuiConfig yuiConfig, ClosureConfig closureConfig, List<String> jsSourceFiles, List<String> jsSourceIncludes, List<String> jsSourceExcludes, String jsFinalFile) throws FileNotFoundException {
        return new ProcessJSFilesTask(this.getLog(), this.verbose, this.bufferSize, Charset.forName(this.charset), this.suffix, this.nosuffix, this.skipMerge, this.skipMinify, this.closureSkipErrors, this.webappSourceDir, this.webappTargetDir, this.jsSourceDir, jsSourceFiles, jsSourceIncludes, jsSourceExcludes, this.jsTargetDir, jsFinalFile, this.jsEngine, yuiConfig, closureConfig);
    }

    public static enum Mode {
        PARALLEL,
        SEQUENTIAL;

    }

    public static enum Engine {
        YUI,
        CLOSURE;

    }
}

