/*
 * Decompiled with CFR 0.152.
 */
package com.github.buckelieg.minify.plugin;

import com.github.buckelieg.minify.common.ClosureConfig;
import com.github.buckelieg.minify.common.JavaScriptErrorReporter;
import com.github.buckelieg.minify.common.YuiConfig;
import com.github.buckelieg.minify.plugin.MinifyMojo;
import com.github.buckelieg.minify.plugin.ProcessFilesTask;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LightweightMessageFormatter;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;

public class ProcessJSFilesTask
extends ProcessFilesTask {
    private final ClosureConfig closureConfig;

    public ProcessJSFilesTask(Log log, boolean verbose, Integer bufferSize, Charset charset, String suffix, boolean nosuffix, boolean skipMerge, boolean skipMinify, boolean skipErrors, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, MinifyMojo.Engine engine, YuiConfig yuiConfig, ClosureConfig closureConfig) throws FileNotFoundException {
        super(log, verbose, bufferSize, charset, suffix, nosuffix, skipMerge, skipMinify, skipErrors, webappSourceDir, webappTargetDir, inputDir, sourceFiles, sourceIncludes, sourceExcludes, outputDir, outputFilename, engine, yuiConfig);
        this.closureConfig = closureConfig;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void minify(File mergedFile, File minifiedFile) throws IOException {
        if (!minifiedFile.getParentFile().exists() && !minifiedFile.getParentFile().mkdirs()) {
            throw new RuntimeException("Unable to create target directory for: " + minifiedFile.getParentFile());
        }
        try {
            in = new FileInputStream(mergedFile);
            try {
                out = new FileOutputStream(minifiedFile);
                try {
                    reader = new InputStreamReader((InputStream)in, this.charset);
                    try {
                        writer = new OutputStreamWriter((OutputStream)out, this.charset);
                        try {
                            this.log.info((CharSequence)("Creating the minified file [" + (this.verbose != false ? minifiedFile.getPath() : minifiedFile.getName()) + "]."));
                            switch (1.$SwitchMap$com$github$buckelieg$minify$plugin$MinifyMojo$Engine[this.engine.ordinal()]) {
                                case 1: {
                                    this.log.debug((CharSequence)"Using Google Closure Compiler engine.");
                                    options = new CompilerOptions();
                                    this.closureConfig.getCompilationLevel().setOptionsForCompilationLevel(options);
                                    options.setOutputCharset(this.charset);
                                    options.setLanguageIn(this.closureConfig.getLanguageIn());
                                    options.setLanguageOut(this.closureConfig.getLanguageOut());
                                    options.setDependencyOptions(this.closureConfig.getDependencyOptions());
                                    options.setColorizeErrorOutput(this.closureConfig.getColorizeErrorOutput().booleanValue());
                                    options.setAngularPass(this.closureConfig.getAngularPass().booleanValue());
                                    options.setExtraAnnotationNames(this.closureConfig.getExtraAnnotations());
                                    options.setDefineReplacements(this.closureConfig.getDefineReplacements());
                                    sourceMapResult = new File(minifiedFile.getPath() + ".map");
                                    if (this.closureConfig.getSourceMapFormat() != null) {
                                        options.setSourceMapFormat(this.closureConfig.getSourceMapFormat());
                                        options.setSourceMapOutputPath(sourceMapResult.getPath());
                                    }
                                    if (this.closureConfig.getWarningLevels() != null) {
                                        for (Map.Entry<DiagnosticGroup, CheckLevel> warningLevel : this.closureConfig.getWarningLevels().entrySet()) {
                                            options.setWarningLevel(warningLevel.getKey(), warningLevel.getValue());
                                        }
                                    }
                                    input = SourceFile.fromInputStream((String)mergedFile.getName(), (InputStream)in, (Charset)this.charset);
                                    externs = new ArrayList<SourceFile>();
                                    externs.addAll(CommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)this.closureConfig.getEnvironment()));
                                    externs.addAll(this.closureConfig.getExterns());
                                    compiler = new Compiler();
                                    compiler.compile(externs, (List)Lists.newArrayList((Object[])new SourceFile[]{input}), options);
                                    if (!this.skipErrors && (errors = compiler.getErrors()).size() > 0) {
                                        msg = new StringBuilder("JSCompiler errors\n");
                                        formatter = new LightweightMessageFormatter((SourceExcerptProvider)compiler);
                                        for (JSError e : errors) {
                                            msg.append(formatter.formatError(e));
                                        }
                                        throw new RuntimeException(msg.toString());
                                    }
                                    writer.append(compiler.toSource());
                                    if (this.closureConfig.getSourceMapFormat() != null) {
                                        this.log.info((CharSequence)("Creating the minified file map [" + (this.verbose != false ? sourceMapResult.getPath() : sourceMapResult.getName()) + "]."));
                                        if (sourceMapResult.createNewFile()) {
                                            this.flushSourceMap(sourceMapResult, minifiedFile.getName(), compiler.getSourceMap());
                                            writer.append(System.getProperty("line.separator"));
                                            writer.append("//# sourceMappingURL=").append(sourceMapResult.getName());
                                            ** break;
                                        }
                                    }
lbl62:
                                    // 5 sources

                                    break;
                                }
                                case 2: {
                                    this.log.debug((CharSequence)"Using YUI Compressor engine.");
                                    compressor = new JavaScriptCompressor((Reader)reader, (ErrorReporter)new JavaScriptErrorReporter(this.log, mergedFile.getName()));
                                    compressor.compress((Writer)writer, this.yuiConfig.getLineBreak(), this.yuiConfig.isMunge(), this.verbose, this.yuiConfig.isPreserveSemicolons(), this.yuiConfig.isDisableOptimizations());
                                    ** break;
lbl68:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    this.log.warn((CharSequence)"JavaScript engine not supported.");
                                    break;
                                }
                            }
                        }
                        finally {
                            writer.close();
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Failed to compress the JavaScript file [" + (this.verbose != false ? mergedFile.getPath() : mergedFile.getName()) + "]."), (Throwable)e);
            throw e;
        }
        this.logCompressionGains(mergedFile, minifiedFile);
    }

    private void flushSourceMap(File sourceMapOutputFile, String minifyFileName, SourceMap sourceMap) {
        try (FileWriter out = new FileWriter(sourceMapOutputFile);){
            sourceMap.appendTo((Appendable)out, minifyFileName);
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Failed to write the JavaScript Source Map file [" + (this.verbose ? sourceMapOutputFile.getPath() : sourceMapOutputFile.getName()) + "]."), (Throwable)e);
        }
    }
}

