/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.repackaged.com.google.common.base.Function;
import com.bumptech.glide.repackaged.com.google.common.base.Joiner;
import com.bumptech.glide.repackaged.com.google.common.base.Objects;
import com.bumptech.glide.repackaged.com.google.common.base.Preconditions;
import com.bumptech.glide.repackaged.com.google.common.base.Strings;
import com.bumptech.glide.repackaged.com.google.common.collect.FluentIterable;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableSet;
import com.bumptech.glide.repackaged.com.google.common.collect.Iterables;
import com.bumptech.glide.repackaged.com.google.common.collect.Lists;
import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.CodeBlock;
import com.bumptech.glide.repackaged.com.squareup.javapoet.FieldSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.MethodSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

final class RequestOptionsGenerator {
    private static final ClassName CHECK_RESULT_CLASS_NAME = ClassName.get("android.support.annotation", "CheckResult", new String[0]);
    private final ProcessingEnvironment processingEnvironment;
    private final ClassName requestOptionsName;
    private final TypeElement requestOptionsType;
    private final ProcessorUtil processorUtil;
    private ClassName glideOptionsName;
    private int nextStaticFieldUniqueId;

    RequestOptionsGenerator(ProcessingEnvironment processingEnvironment, ProcessorUtil processorUtil) {
        this.processingEnvironment = processingEnvironment;
        this.processorUtil = processorUtil;
        this.requestOptionsName = ClassName.get("com.bumptech.glide.request", "RequestOptions", new String[0]);
        this.requestOptionsType = processingEnvironment.getElementUtils().getTypeElement("com.bumptech.glide.request.RequestOptions");
    }

    TypeSpec generate(String generatedCodePackageName, Set<String> glideExtensionClassNames) {
        this.glideOptionsName = ClassName.get(generatedCodePackageName, "GlideOptions", new String[0]);
        List<MethodAndStaticVar> methodsForExtensions = this.generateMethodsForExtensions(glideExtensionClassNames);
        ImmutableSet<MethodSignature> extensionMethodSignatures = ImmutableSet.copyOf(Iterables.transform(methodsForExtensions, new Function<MethodAndStaticVar, MethodSignature>(){

            @Override
            public MethodSignature apply(MethodAndStaticVar f) {
                return new MethodSignature(f.method);
            }
        }));
        List<MethodAndStaticVar> staticOverrides = this.generateStaticMethodOverridesForRequestOptions();
        List<MethodSpec> instanceOverrides = this.generateInstanceMethodOverridesForRequestOptions();
        ArrayList<MethodAndStaticVar> allMethodsAndStaticVars = new ArrayList<MethodAndStaticVar>();
        for (MethodAndStaticVar item : staticOverrides) {
            if (extensionMethodSignatures.contains(new MethodSignature(item.method))) continue;
            allMethodsAndStaticVars.add(item);
        }
        for (MethodSpec methodSpec : instanceOverrides) {
            if (extensionMethodSignatures.contains(new MethodSignature(methodSpec))) continue;
            allMethodsAndStaticVars.add(new MethodAndStaticVar(methodSpec));
        }
        allMethodsAndStaticVars.addAll(methodsForExtensions);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder("GlideOptions").addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "deprecation").build()).addJavadoc(this.generateClassJavadoc(glideExtensionClassNames)).addModifiers(Modifier.FINAL).addModifiers(Modifier.PUBLIC).addSuperinterface((Type)((Object)Cloneable.class)).superclass(this.requestOptionsName);
        for (MethodAndStaticVar methodAndStaticVar : allMethodsAndStaticVars) {
            if (methodAndStaticVar.method != null) {
                classBuilder.addMethod(methodAndStaticVar.method);
            }
            if (methodAndStaticVar.staticField == null) continue;
            classBuilder.addField(methodAndStaticVar.staticField);
        }
        return classBuilder.build();
    }

    private CodeBlock generateClassJavadoc(Set<String> glideExtensionClassNames) {
        CodeBlock.Builder builder = CodeBlock.builder().add("Automatically generated from {@link $T} annotated classes.\n", GlideExtension.class).add("\n", new Object[0]).add("@see $T\n", this.requestOptionsName);
        for (String glideExtensionClass : glideExtensionClassNames) {
            builder.add("@see $T\n", ClassName.bestGuess(glideExtensionClass));
        }
        return builder.build();
    }

    private List<MethodAndStaticVar> generateMethodsForExtensions(Set<String> glideExtensionClassNames) {
        List<ExecutableElement> requestOptionExtensionMethods = this.processorUtil.findAnnotatedElementsInClasses(glideExtensionClassNames, GlideOption.class);
        ArrayList<MethodAndStaticVar> result = new ArrayList<MethodAndStaticVar>(requestOptionExtensionMethods.size());
        for (ExecutableElement requestOptionsExtensionMethod : requestOptionExtensionMethods) {
            result.addAll(this.generateMethodsForRequestOptionsExtension(requestOptionsExtensionMethod));
        }
        return result;
    }

    private List<MethodSpec> generateInstanceMethodOverridesForRequestOptions() {
        return Lists.transform(this.processorUtil.findInstanceMethodsReturning(this.requestOptionsType, this.requestOptionsType), new Function<ExecutableElement, MethodSpec>(){

            @Override
            public MethodSpec apply(ExecutableElement input) {
                return RequestOptionsGenerator.this.generateRequestOptionOverride(input);
            }
        });
    }

    private MethodSpec generateRequestOptionOverride(ExecutableElement methodToOverride) {
        MethodSpec.Builder result = ProcessorUtil.overriding(methodToOverride).returns(this.glideOptionsName).addModifiers(Modifier.FINAL);
        result.addCode(CodeBlock.builder().add("return ($T) super.$N(", this.glideOptionsName, methodToOverride.getSimpleName()).add(FluentIterable.from(result.build().parameters).transform(new Function<ParameterSpec, String>(){

            @Override
            public String apply(ParameterSpec input) {
                return input.name;
            }
        }).join(Joiner.on(", ")), new Object[0]).add(");\n", new Object[0]).build());
        if (methodToOverride.getSimpleName().toString().equals("transforms")) {
            result.addAnnotation(SafeVarargs.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "varargs").build());
        }
        for (AnnotationMirror annotationMirror : methodToOverride.getAnnotationMirrors()) {
            result.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
        return result.build();
    }

    private List<MethodAndStaticVar> generateMethodsForRequestOptionsExtension(ExecutableElement element) {
        if (element.getReturnType().getKind() == TypeKind.VOID) {
            this.processorUtil.warnLog("The " + element.getSimpleName() + " method annotated with @GlideOption in the " + element.getEnclosingElement().getSimpleName() + " @GlideExtension is using a legacy format. Support will be removed in a future version. Please change your method definition so that your @GlideModule annotated methods return RequestOptions objects instead of null.");
            return this.generateMethodsForRequestOptionsExtensionDeprecated(element);
        }
        return this.generateMethodsForRequestOptionsExtensionNew(element);
    }

    private List<MethodAndStaticVar> generateMethodsForRequestOptionsExtensionNew(ExecutableElement element) {
        String extensionRequestOptionsArgument;
        int overrideType = this.processorUtil.getOverrideType(element);
        String methodName = element.getSimpleName().toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(element)).varargs(element.isVarArgs()).returns(this.glideOptionsName);
        List<? extends VariableElement> paramElements = element.getParameters().subList(1, element.getParameters().size());
        List<ParameterSpec> parameters = ProcessorUtil.getParameters(paramElements);
        builder.addParameters(parameters);
        if (overrideType == 1) {
            builder.addJavadoc(this.processorUtil.generateSeeMethodJavadoc(this.requestOptionsName, methodName, paramElements)).addAnnotation(Override.class);
            ArrayList<String> methodArgs = new ArrayList<String>();
            methodArgs.add(element.getSimpleName().toString());
            StringBuilder methodLiterals = new StringBuilder();
            if (!parameters.isEmpty()) {
                for (ParameterSpec parameter : parameters) {
                    methodLiterals.append("$L, ");
                    methodArgs.add(parameter.name);
                }
                methodLiterals = new StringBuilder(methodLiterals.substring(0, methodLiterals.length() - 2));
            }
            extensionRequestOptionsArgument = CodeBlock.builder().add("super.$N(" + methodLiterals + ")", methodArgs.toArray(new Object[0])).build().toString();
        } else {
            extensionRequestOptionsArgument = "this";
        }
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder code = new StringBuilder("return ($T) $T.$L($L, ");
        args.add(this.glideOptionsName);
        args.add(ClassName.get(element.getEnclosingElement().asType()));
        args.add(element.getSimpleName().toString());
        args.add(extensionRequestOptionsArgument);
        if (!parameters.isEmpty()) {
            for (ParameterSpec parameter : parameters) {
                code.append("$L, ");
                args.add(parameter.name);
            }
        }
        code = new StringBuilder(code.substring(0, code.length() - 2));
        code.append(")");
        builder.addStatement(code.toString(), args.toArray(new Object[0]));
        builder.addAnnotation(AnnotationSpec.builder(CHECK_RESULT_CLASS_NAME).build()).addAnnotation(ProcessorUtil.nonNull());
        ArrayList<MethodAndStaticVar> result = new ArrayList<MethodAndStaticVar>();
        result.add(new MethodAndStaticVar(builder.build()));
        MethodAndStaticVar methodAndVar = this.generateStaticMethodEquivalentForExtensionMethod(element);
        if (methodAndVar != null) {
            result.add(methodAndVar);
        }
        return result;
    }

    private List<MethodAndStaticVar> generateMethodsForRequestOptionsExtensionDeprecated(ExecutableElement element) {
        int overrideType = this.processorUtil.getOverrideType(element);
        String methodName = element.getSimpleName().toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(element)).varargs(element.isVarArgs()).returns(this.glideOptionsName);
        List<? extends VariableElement> paramElements = element.getParameters().subList(1, element.getParameters().size());
        List<ParameterSpec> parameters = ProcessorUtil.getParameters(paramElements);
        builder.addParameters(parameters);
        ArrayList<String> methodArgs = new ArrayList<String>();
        methodArgs.add(element.getSimpleName().toString());
        StringBuilder methodLiterals = new StringBuilder();
        if (!parameters.isEmpty()) {
            for (ParameterSpec parameter : parameters) {
                methodLiterals.append("$L, ");
                methodArgs.add(parameter.name);
            }
            methodLiterals = new StringBuilder(methodLiterals.substring(0, methodLiterals.length() - 2));
        }
        builder.beginControlFlow("if (isAutoCloneEnabled())", new Object[0]).addStatement("return clone().$N(" + methodLiterals + ")", methodArgs.toArray(new Object[0])).endControlFlow();
        if (overrideType == 1) {
            String callSuper = "super.$L(" + methodLiterals + ")";
            builder.addStatement(callSuper, methodArgs.toArray(new Object[0])).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(this.requestOptionsName, methodName, paramElements)).addAnnotation(Override.class);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder code = new StringBuilder("$T.$L($L, ");
        args.add(ClassName.get(element.getEnclosingElement().asType()));
        args.add(element.getSimpleName().toString());
        args.add("this");
        if (!parameters.isEmpty()) {
            for (ParameterSpec parameter : parameters) {
                code.append("$L, ");
                args.add(parameter.name);
            }
        }
        code = new StringBuilder(code.substring(0, code.length() - 2));
        code.append(")");
        builder.addStatement(code.toString(), args.toArray(new Object[0]));
        builder.addStatement("return this", new Object[0]).addAnnotation(AnnotationSpec.builder(CHECK_RESULT_CLASS_NAME).build()).addAnnotation(ProcessorUtil.nonNull());
        ArrayList<MethodAndStaticVar> result = new ArrayList<MethodAndStaticVar>();
        result.add(new MethodAndStaticVar(builder.build()));
        MethodAndStaticVar methodAndVar = this.generateStaticMethodEquivalentForExtensionMethod(element);
        if (methodAndVar != null) {
            result.add(methodAndVar);
        }
        return result;
    }

    private List<MethodAndStaticVar> generateStaticMethodOverridesForRequestOptions() {
        List<ExecutableElement> staticMethodsThatReturnRequestOptions = this.processorUtil.findStaticMethodsReturning(this.requestOptionsType, this.requestOptionsType);
        ArrayList<MethodAndStaticVar> staticMethods = new ArrayList<MethodAndStaticVar>();
        for (ExecutableElement element : staticMethodsThatReturnRequestOptions) {
            if (element.getAnnotation(Deprecated.class) != null) continue;
            staticMethods.add(this.generateStaticMethodEquivalentForRequestOptionsStaticMethod(element));
        }
        return staticMethods;
    }

    private static String getInstanceMethodNameFromStaticMethodName(String staticMethodName) {
        String equivalentInstanceMethodName;
        if ("bitmapTransform".equals(staticMethodName)) {
            equivalentInstanceMethodName = "transform";
        } else if ("decodeTypeOf".equals(staticMethodName)) {
            equivalentInstanceMethodName = "decode";
        } else if (staticMethodName.endsWith("Transform")) {
            equivalentInstanceMethodName = staticMethodName.substring(0, staticMethodName.length() - 9);
        } else if (staticMethodName.endsWith("Of")) {
            equivalentInstanceMethodName = staticMethodName.substring(0, staticMethodName.length() - 2);
        } else if ("noTransformation".equals(staticMethodName)) {
            equivalentInstanceMethodName = "dontTransform";
        } else if ("noAnimation".equals(staticMethodName)) {
            equivalentInstanceMethodName = "dontAnimate";
        } else if (staticMethodName.equals("option")) {
            equivalentInstanceMethodName = "set";
        } else {
            throw new IllegalArgumentException("Unrecognized static method name: " + staticMethodName);
        }
        return equivalentInstanceMethodName;
    }

    private MethodAndStaticVar generateStaticMethodEquivalentForRequestOptionsStaticMethod(ExecutableElement staticMethod) {
        boolean memoize = RequestOptionsGenerator.memoizeStaticMethodFromArguments(staticMethod);
        String staticMethodName = staticMethod.getSimpleName().toString();
        String equivalentInstanceMethodName = RequestOptionsGenerator.getInstanceMethodNameFromStaticMethodName(staticMethodName);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder(staticMethodName).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(staticMethod)).returns(this.glideOptionsName);
        StringBuilder createNewOptionAndCall = this.createNewOptionAndCall(memoize, methodSpecBuilder, "new $T().$N(", ProcessorUtil.getParameters(staticMethod));
        FieldSpec requiredStaticField = null;
        if (memoize) {
            String staticVariableName = staticMethodName + this.nextStaticFieldUniqueId++;
            requiredStaticField = FieldSpec.builder(this.glideOptionsName, staticVariableName, new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC).build();
            methodSpecBuilder.beginControlFlow("if ($T.$N == null)", this.glideOptionsName, staticVariableName).addStatement("$T.$N =\n" + createNewOptionAndCall + ".$N", this.glideOptionsName, staticVariableName, this.glideOptionsName, equivalentInstanceMethodName, "autoClone()").endControlFlow().addStatement("return $T.$N", this.glideOptionsName, staticVariableName);
        } else {
            methodSpecBuilder.addStatement("return " + createNewOptionAndCall, this.glideOptionsName, equivalentInstanceMethodName);
        }
        List<? extends TypeParameterElement> typeParameters = staticMethod.getTypeParameters();
        for (TypeParameterElement typeParameterElement : typeParameters) {
            methodSpecBuilder.addTypeVariable(TypeVariableName.get(typeParameterElement.getSimpleName().toString()));
        }
        methodSpecBuilder.addAnnotation(AnnotationSpec.builder(CHECK_RESULT_CLASS_NAME).build()).addAnnotation(ProcessorUtil.nonNull());
        return new MethodAndStaticVar(methodSpecBuilder.build(), requiredStaticField);
    }

    private static boolean memoizeStaticMethodFromArguments(ExecutableElement staticMethod) {
        return staticMethod.getParameters().isEmpty() || staticMethod.getParameters().size() == 1 && staticMethod.getParameters().get(0).getSimpleName().toString().equals("android.content.Context");
    }

    private MethodAndStaticVar generateStaticMethodEquivalentForExtensionMethod(ExecutableElement instanceMethod) {
        boolean skipStaticMethod = RequestOptionsGenerator.skipStaticMethod(instanceMethod);
        if (skipStaticMethod) {
            return null;
        }
        String staticMethodName = RequestOptionsGenerator.getStaticMethodName(instanceMethod);
        String instanceMethodName = instanceMethod.getSimpleName().toString();
        if (Strings.isNullOrEmpty(staticMethodName)) {
            staticMethodName = instanceMethodName.startsWith("dont") ? "no" + instanceMethodName.replace("dont", "") : instanceMethodName + "Of";
        }
        boolean memoize = RequestOptionsGenerator.memoizeStaticMethodFromAnnotation(instanceMethod);
        Preconditions.checkNotNull(staticMethodName);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder(staticMethodName).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(instanceMethod)).varargs(instanceMethod.isVarArgs()).returns(this.glideOptionsName);
        List<? extends VariableElement> parameters = instanceMethod.getParameters();
        if (parameters.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty parameters for: " + instanceMethod);
        }
        parameters = parameters.subList(1, parameters.size());
        StringBuilder createNewOptionAndCall = this.createNewOptionAndCall(memoize, methodSpecBuilder, "new $T().$L(", ProcessorUtil.getParameters(parameters));
        FieldSpec requiredStaticField = null;
        if (memoize) {
            String staticVariableName = staticMethodName + this.nextStaticFieldUniqueId++;
            requiredStaticField = FieldSpec.builder(this.glideOptionsName, staticVariableName, new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC).build();
            methodSpecBuilder.beginControlFlow("if ($T.$N == null)", this.glideOptionsName, staticVariableName).addStatement("$T.$N =\n" + createNewOptionAndCall + ".$N", this.glideOptionsName, staticVariableName, this.glideOptionsName, instanceMethodName, "autoClone()").endControlFlow().addStatement("return $T.$N", this.glideOptionsName, staticVariableName);
        } else {
            methodSpecBuilder.addStatement("return " + createNewOptionAndCall, this.glideOptionsName, instanceMethodName);
        }
        List<? extends TypeParameterElement> typeParameters = instanceMethod.getTypeParameters();
        for (TypeParameterElement typeParameterElement : typeParameters) {
            methodSpecBuilder.addTypeVariable(TypeVariableName.get(typeParameterElement.getSimpleName().toString()));
        }
        methodSpecBuilder.addAnnotation(AnnotationSpec.builder(CHECK_RESULT_CLASS_NAME).build());
        return new MethodAndStaticVar(methodSpecBuilder.build(), requiredStaticField);
    }

    private StringBuilder createNewOptionAndCall(boolean memoize, MethodSpec.Builder methodSpecBuilder, String start, List<ParameterSpec> specs) {
        StringBuilder createNewOptionAndCall = new StringBuilder(start);
        if (!specs.isEmpty()) {
            methodSpecBuilder.addParameters(specs);
            for (ParameterSpec parameter : specs) {
                createNewOptionAndCall.append(parameter.name);
                if (memoize && this.isAndroidContext(parameter)) {
                    createNewOptionAndCall.append(".getApplicationContext()");
                }
                createNewOptionAndCall.append(", ");
            }
            createNewOptionAndCall = new StringBuilder(createNewOptionAndCall.substring(0, createNewOptionAndCall.length() - 2));
        }
        createNewOptionAndCall.append(")");
        return createNewOptionAndCall;
    }

    private boolean isAndroidContext(ParameterSpec parameter) {
        return parameter.type.toString().equals("android.content.Context");
    }

    private static String getStaticMethodName(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        String result = glideOption != null ? glideOption.staticMethodName() : null;
        return Strings.emptyToNull(result);
    }

    private static boolean memoizeStaticMethodFromAnnotation(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        return glideOption != null && glideOption.memoizeStaticMethod();
    }

    private static boolean skipStaticMethod(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        return glideOption != null && glideOption.skipStaticMethod();
    }

    private static final class MethodSignature {
        private final TypeName returnType;
        private final List<TypeName> parameterTypes;
        private final boolean isStatic;
        private final String name;

        MethodSignature(MethodSpec spec) {
            this.name = spec.name;
            this.isStatic = spec.modifiers.contains((Object)Modifier.STATIC);
            this.returnType = spec.returnType;
            this.parameterTypes = Lists.transform(spec.parameters, new Function<ParameterSpec, TypeName>(){

                @Override
                public TypeName apply(ParameterSpec parameterSpec) {
                    return parameterSpec.type;
                }
            });
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature other = (MethodSignature)o;
                return this.name.equals(other.name) && this.returnType.equals(other.returnType) && this.parameterTypes.equals(other.parameterTypes) && this.isStatic == other.isStatic;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.name, this.returnType, this.parameterTypes, this.isStatic);
        }
    }

    private static final class MethodAndStaticVar {
        final MethodSpec method;
        final FieldSpec staticField;

        MethodAndStaticVar(MethodSpec method) {
            this(method, null);
        }

        MethodAndStaticVar(MethodSpec method, FieldSpec staticField) {
            this.method = method;
            this.staticField = staticField;
        }
    }
}

