/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.annotation.compiler.RequestOptionsExtensionGenerator;
import com.bumptech.glide.annotation.compiler.RequestOptionsOverrideGenerator;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;

final class RequestOptionsGenerator {
    private static final String GENERATED_REQUEST_OPTIONS_SIMPLE_NAME = "GlideOptions";
    static final String REQUEST_OPTIONS_PACKAGE_NAME = "com.bumptech.glide.request";
    private static final String REQUEST_OPTIONS_SIMPLE_NAME = "RequestOptions";
    static final String REQUEST_OPTIONS_QUALIFIED_NAME = "com.bumptech.glide.request.RequestOptions";
    static final String BASE_REQUEST_OPTIONS_SIMPLE_NAME = "BaseRequestOptions";
    static final String BASE_REQUEST_OPTIONS_QUALIFIED_NAME = "com.bumptech.glide.request.BaseRequestOptions";
    private int nextFieldId;
    private final ClassName requestOptionsName;
    private final TypeElement requestOptionsType;
    private final ProcessorUtil processorUtil;
    private final RequestOptionsOverrideGenerator requestOptionsOverrideGenerator;
    private ClassName glideOptionsName;

    RequestOptionsGenerator(ProcessingEnvironment processingEnvironment, ProcessorUtil processorUtil) {
        this.processorUtil = processorUtil;
        this.requestOptionsName = ClassName.get((String)REQUEST_OPTIONS_PACKAGE_NAME, (String)REQUEST_OPTIONS_SIMPLE_NAME, (String[])new String[0]);
        this.requestOptionsType = processingEnvironment.getElementUtils().getTypeElement(REQUEST_OPTIONS_QUALIFIED_NAME);
        this.requestOptionsOverrideGenerator = new RequestOptionsOverrideGenerator(processingEnvironment, processorUtil);
    }

    TypeSpec generate(String generatedCodePackageName, Set<String> glideExtensionClassNames) {
        this.glideOptionsName = ClassName.get((String)generatedCodePackageName, (String)GENERATED_REQUEST_OPTIONS_SIMPLE_NAME, (String[])new String[0]);
        RequestOptionsExtensionGenerator requestOptionsExtensionGenerator = new RequestOptionsExtensionGenerator((TypeName)this.glideOptionsName, this.processorUtil);
        ImmutableList instanceMethodsForExtensions = FluentIterable.from(requestOptionsExtensionGenerator.generateInstanceMethodsForExtensions(glideExtensionClassNames)).transform((Function)new Function<MethodSpec, MethodAndStaticVar>(){

            public MethodAndStaticVar apply(MethodSpec input) {
                return new MethodAndStaticVar(input);
            }
        }).toList();
        ImmutableList staticMethodsForExtensions = FluentIterable.from(requestOptionsExtensionGenerator.getRequestOptionExtensionMethods(glideExtensionClassNames)).filter((Predicate)new Predicate<ExecutableElement>(){

            public boolean apply(ExecutableElement input) {
                return !RequestOptionsGenerator.skipStaticMethod(input);
            }
        }).transform((Function)new Function<ExecutableElement, MethodAndStaticVar>(){

            public MethodAndStaticVar apply(ExecutableElement input) {
                return RequestOptionsGenerator.this.generateStaticMethodEquivalentForExtensionMethod(input);
            }
        }).toList();
        ArrayList methodsForExtensions = new ArrayList();
        methodsForExtensions.addAll(instanceMethodsForExtensions);
        methodsForExtensions.addAll(staticMethodsForExtensions);
        ImmutableSet extensionMethodSignatures = ImmutableSet.copyOf((Iterable)Iterables.transform(methodsForExtensions, (Function)new Function<MethodAndStaticVar, MethodSignature>(){

            public MethodSignature apply(MethodAndStaticVar f) {
                return new MethodSignature(f.method);
            }
        }));
        List<MethodAndStaticVar> staticOverrides = this.generateStaticMethodOverridesForRequestOptions();
        List<MethodSpec> instanceOverrides = this.requestOptionsOverrideGenerator.generateInstanceMethodOverridesForRequestOptions((TypeName)this.glideOptionsName);
        ArrayList<MethodAndStaticVar> allMethodsAndStaticVars = new ArrayList<MethodAndStaticVar>();
        for (MethodAndStaticVar item : staticOverrides) {
            if (extensionMethodSignatures.contains(new MethodSignature(item.method))) continue;
            allMethodsAndStaticVars.add(item);
        }
        for (MethodSpec methodSpec : instanceOverrides) {
            if (extensionMethodSignatures.contains(new MethodSignature(methodSpec))) continue;
            allMethodsAndStaticVars.add(new MethodAndStaticVar(methodSpec));
        }
        allMethodsAndStaticVars.addAll(methodsForExtensions);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)GENERATED_REQUEST_OPTIONS_SIMPLE_NAME).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"deprecation"}).build()).addJavadoc(this.generateClassJavadoc(glideExtensionClassNames)).addModifiers(new Modifier[]{Modifier.FINAL}).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(Cloneable.class).superclass((TypeName)this.requestOptionsName);
        for (MethodAndStaticVar methodAndStaticVar : allMethodsAndStaticVars) {
            if (methodAndStaticVar.method != null) {
                classBuilder.addMethod(methodAndStaticVar.method);
            }
            if (methodAndStaticVar.staticField == null) continue;
            classBuilder.addField(methodAndStaticVar.staticField);
        }
        return classBuilder.build();
    }

    private CodeBlock generateClassJavadoc(Set<String> glideExtensionClassNames) {
        CodeBlock.Builder builder = CodeBlock.builder().add("Automatically generated from {@link $T} annotated classes.\n", new Object[]{GlideExtension.class}).add("\n", new Object[0]).add("@see $T\n", new Object[]{this.requestOptionsName});
        for (String glideExtensionClass : glideExtensionClassNames) {
            builder.add("@see $T\n", new Object[]{ClassName.bestGuess((String)glideExtensionClass)});
        }
        return builder.build();
    }

    private List<MethodAndStaticVar> generateStaticMethodOverridesForRequestOptions() {
        List<ExecutableElement> staticMethodsThatReturnRequestOptions = this.processorUtil.findStaticMethodsReturning(this.requestOptionsType, this.requestOptionsType);
        ArrayList<MethodAndStaticVar> staticMethods = new ArrayList<MethodAndStaticVar>();
        for (ExecutableElement element : staticMethodsThatReturnRequestOptions) {
            if (element.getAnnotation(Deprecated.class) != null) continue;
            staticMethods.add(this.generateStaticMethodEquivalentForRequestOptionsStaticMethod(element));
        }
        return staticMethods;
    }

    private static String getInstanceMethodNameFromStaticMethodName(String staticMethodName) {
        String equivalentInstanceMethodName;
        if ("bitmapTransform".equals(staticMethodName)) {
            equivalentInstanceMethodName = "transform";
        } else if ("decodeTypeOf".equals(staticMethodName)) {
            equivalentInstanceMethodName = "decode";
        } else if (staticMethodName.endsWith("Transform")) {
            equivalentInstanceMethodName = staticMethodName.substring(0, staticMethodName.length() - 9);
        } else if (staticMethodName.endsWith("Of")) {
            equivalentInstanceMethodName = staticMethodName.substring(0, staticMethodName.length() - 2);
        } else if ("noTransformation".equals(staticMethodName)) {
            equivalentInstanceMethodName = "dontTransform";
        } else if ("noAnimation".equals(staticMethodName)) {
            equivalentInstanceMethodName = "dontAnimate";
        } else if (staticMethodName.equals("option")) {
            equivalentInstanceMethodName = "set";
        } else {
            throw new IllegalArgumentException("Unrecognized static method name: " + staticMethodName);
        }
        return equivalentInstanceMethodName;
    }

    private MethodAndStaticVar generateStaticMethodEquivalentForRequestOptionsStaticMethod(ExecutableElement staticMethod) {
        boolean memoize = RequestOptionsGenerator.memoizeStaticMethodFromArguments(staticMethod);
        String staticMethodName = staticMethod.getSimpleName().toString();
        String equivalentInstanceMethodName = RequestOptionsGenerator.getInstanceMethodNameFromStaticMethodName(staticMethodName);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)staticMethodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(staticMethod)).returns((TypeName)this.glideOptionsName);
        StringBuilder createNewOptionAndCall = this.createNewOptionAndCall(memoize, methodSpecBuilder, "new $T().$N(", this.processorUtil.getParameters(staticMethod));
        FieldSpec requiredStaticField = null;
        if (memoize) {
            String staticVariableName = staticMethodName + this.nextFieldId++;
            requiredStaticField = FieldSpec.builder((TypeName)this.glideOptionsName, (String)staticVariableName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();
            methodSpecBuilder.beginControlFlow("if ($T.$N == null)", new Object[]{this.glideOptionsName, staticVariableName}).addStatement("$T.$N =\n" + String.valueOf(createNewOptionAndCall) + ".$N", new Object[]{this.glideOptionsName, staticVariableName, this.glideOptionsName, equivalentInstanceMethodName, "autoClone()"}).endControlFlow().addStatement("return $T.$N", new Object[]{this.glideOptionsName, staticVariableName});
        } else {
            methodSpecBuilder.addStatement("return " + String.valueOf(createNewOptionAndCall), new Object[]{this.glideOptionsName, equivalentInstanceMethodName});
        }
        List<? extends TypeParameterElement> typeParameters = staticMethod.getTypeParameters();
        for (TypeParameterElement typeParameterElement : typeParameters) {
            methodSpecBuilder.addTypeVariable(TypeVariableName.get((String)typeParameterElement.getSimpleName().toString()));
        }
        methodSpecBuilder.addAnnotation(this.processorUtil.checkResult()).addAnnotation(this.processorUtil.nonNull());
        return new MethodAndStaticVar(methodSpecBuilder.build(), requiredStaticField);
    }

    private static boolean memoizeStaticMethodFromArguments(ExecutableElement staticMethod) {
        return staticMethod.getParameters().isEmpty() || staticMethod.getParameters().size() == 1 && staticMethod.getParameters().get(0).getSimpleName().toString().equals("android.content.Context");
    }

    private StringBuilder createNewOptionAndCall(boolean memoize, MethodSpec.Builder methodSpecBuilder, String start, List<ParameterSpec> specs) {
        StringBuilder createNewOptionAndCall = new StringBuilder(start);
        if (!specs.isEmpty()) {
            methodSpecBuilder.addParameters(specs);
            for (ParameterSpec parameter : specs) {
                createNewOptionAndCall.append(parameter.name);
                if (memoize && this.isAndroidContext(parameter)) {
                    createNewOptionAndCall.append(".getApplicationContext()");
                }
                createNewOptionAndCall.append(", ");
            }
            createNewOptionAndCall = new StringBuilder(createNewOptionAndCall.substring(0, createNewOptionAndCall.length() - 2));
        }
        createNewOptionAndCall.append(")");
        return createNewOptionAndCall;
    }

    private boolean isAndroidContext(ParameterSpec parameter) {
        return parameter.type.toString().equals("android.content.Context");
    }

    private MethodAndStaticVar generateStaticMethodEquivalentForExtensionMethod(ExecutableElement instanceMethod) {
        Object staticMethodName = RequestOptionsGenerator.getStaticMethodName(instanceMethod);
        String instanceMethodName = instanceMethod.getSimpleName().toString();
        if (Strings.isNullOrEmpty((String)staticMethodName)) {
            staticMethodName = instanceMethodName.startsWith("dont") ? "no" + instanceMethodName.replace("dont", "") : instanceMethodName + "Of";
        }
        boolean memoize = RequestOptionsGenerator.memoizeStaticMethodFromAnnotation(instanceMethod);
        Preconditions.checkNotNull((Object)staticMethodName);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)staticMethodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(instanceMethod)).varargs(instanceMethod.isVarArgs()).returns((TypeName)this.glideOptionsName);
        List<? extends VariableElement> parameters = instanceMethod.getParameters();
        if (parameters.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty parameters for: " + String.valueOf(instanceMethod));
        }
        parameters = parameters.subList(1, parameters.size());
        StringBuilder createNewOptionAndCall = this.createNewOptionAndCall(memoize, methodSpecBuilder, "new $T().$L(", this.processorUtil.getParameters(parameters));
        FieldSpec requiredStaticField = null;
        if (memoize) {
            String staticVariableName = (String)staticMethodName + this.nextFieldId++;
            requiredStaticField = FieldSpec.builder((TypeName)this.glideOptionsName, (String)staticVariableName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();
            methodSpecBuilder.beginControlFlow("if ($T.$N == null)", new Object[]{this.glideOptionsName, staticVariableName}).addStatement("$T.$N =\n" + String.valueOf(createNewOptionAndCall) + ".$N", new Object[]{this.glideOptionsName, staticVariableName, this.glideOptionsName, instanceMethodName, "autoClone()"}).endControlFlow().addStatement("return $T.$N", new Object[]{this.glideOptionsName, staticVariableName});
        } else {
            methodSpecBuilder.addStatement("return " + String.valueOf(createNewOptionAndCall), new Object[]{this.glideOptionsName, instanceMethodName});
        }
        List<? extends TypeParameterElement> typeParameters = instanceMethod.getTypeParameters();
        for (TypeParameterElement typeParameterElement : typeParameters) {
            methodSpecBuilder.addTypeVariable(TypeVariableName.get((String)typeParameterElement.getSimpleName().toString()));
        }
        methodSpecBuilder.addAnnotation(this.processorUtil.checkResult());
        return new MethodAndStaticVar(methodSpecBuilder.build(), requiredStaticField);
    }

    @Nullable
    private static String getStaticMethodName(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        String result = glideOption != null ? glideOption.staticMethodName() : null;
        return Strings.emptyToNull((String)result);
    }

    private static boolean memoizeStaticMethodFromAnnotation(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        return glideOption != null && glideOption.memoizeStaticMethod();
    }

    private static boolean skipStaticMethod(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        return glideOption != null && glideOption.skipStaticMethod();
    }

    private static final class MethodAndStaticVar {
        @Nullable
        final MethodSpec method;
        @Nullable
        final FieldSpec staticField;

        MethodAndStaticVar(@Nullable MethodSpec method) {
            this(method, null);
        }

        MethodAndStaticVar(@Nullable MethodSpec method, @Nullable FieldSpec staticField) {
            this.method = method;
            this.staticField = staticField;
        }
    }

    private static final class MethodSignature {
        private final TypeName returnType;
        private final List<TypeName> parameterTypes;
        private final boolean isStatic;
        private final String name;

        MethodSignature(MethodSpec spec) {
            this.name = spec.name;
            this.isStatic = spec.modifiers.contains((Object)Modifier.STATIC);
            this.returnType = spec.returnType;
            this.parameterTypes = Lists.transform((List)spec.parameters, (Function)new Function<ParameterSpec, TypeName>(){

                @Nullable
                public TypeName apply(ParameterSpec parameterSpec) {
                    return parameterSpec.type;
                }
            });
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature other = (MethodSignature)o;
                return this.name.equals(other.name) && this.returnType.equals((Object)other.returnType) && this.parameterTypes.equals(other.parameterTypes) && this.isStatic == other.isStatic;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.returnType, this.parameterTypes, this.isStatic});
        }
    }
}

