/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.okhttp3;

import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.HttpException;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import com.bumptech.glide.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpStreamFetcher
implements DataFetcher<InputStream>,
Callback {
    private static final String TAG = "OkHttpFetcher";
    private final Call.Factory client;
    private final GlideUrl url;
    InputStream stream;
    ResponseBody responseBody;
    private volatile Call call;
    private DataFetcher.DataCallback<? super InputStream> callback;

    public OkHttpStreamFetcher(Call.Factory client, GlideUrl url) {
        this.client = client;
        this.url = url;
    }

    public void loadData(Priority priority, DataFetcher.DataCallback<? super InputStream> callback) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url.toStringUrl());
        for (Map.Entry headerEntry : this.url.getHeaders().entrySet()) {
            String key = (String)headerEntry.getKey();
            requestBuilder.addHeader(key, (String)headerEntry.getValue());
        }
        Request request = requestBuilder.build();
        this.callback = callback;
        this.call = this.client.newCall(request);
        if (Build.VERSION.SDK_INT != 26) {
            this.call.enqueue((Callback)this);
        } else {
            try {
                this.onResponse(this.call, this.call.execute());
            }
            catch (IOException e) {
                this.onFailure(this.call, e);
            }
            catch (ClassCastException e) {
                this.onFailure(this.call, new IOException("Workaround for framework bug on O", e));
            }
        }
    }

    public void onFailure(@NonNull Call call, @NonNull IOException e) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"OkHttp failed to obtain result", (Throwable)e);
        }
        this.callback.onLoadFailed((Exception)e);
    }

    public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
        this.responseBody = response.body();
        if (response.isSuccessful()) {
            long contentLength = ((ResponseBody)Preconditions.checkNotNull((Object)this.responseBody)).contentLength();
            this.stream = ContentLengthInputStream.obtain((InputStream)this.responseBody.byteStream(), (long)contentLength);
            this.callback.onDataReady((Object)this.stream);
        } else {
            this.callback.onLoadFailed((Exception)new HttpException(response.message(), response.code()));
        }
    }

    public void cleanup() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responseBody != null) {
            this.responseBody.close();
        }
        this.callback = null;
    }

    public void cancel() {
        Call local = this.call;
        if (local != null) {
            local.cancel();
        }
    }

    @NonNull
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @NonNull
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }
}

