/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.recyclerview;

import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.AbsListView;

public final class RecyclerToListViewScrollListener
extends RecyclerView.OnScrollListener {
    public static final int UNKNOWN_SCROLL_STATE = Integer.MIN_VALUE;
    private final AbsListView.OnScrollListener scrollListener;
    private int lastFirstVisible = -1;
    private int lastVisibleCount = -1;
    private int lastItemCount = -1;

    public RecyclerToListViewScrollListener(@NonNull AbsListView.OnScrollListener scrollListener) {
        this.scrollListener = scrollListener;
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        int listViewState;
        switch (newState) {
            case 1: {
                listViewState = 1;
                break;
            }
            case 0: {
                listViewState = 0;
                break;
            }
            case 2: {
                listViewState = 2;
                break;
            }
            default: {
                listViewState = Integer.MIN_VALUE;
            }
        }
        this.scrollListener.onScrollStateChanged(null, listViewState);
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
        int firstVisible = layoutManager.findFirstVisibleItemPosition();
        int visibleCount = Math.abs(firstVisible - layoutManager.findLastVisibleItemPosition());
        int itemCount = recyclerView.getAdapter().getItemCount();
        if (firstVisible != this.lastFirstVisible || visibleCount != this.lastVisibleCount || itemCount != this.lastItemCount) {
            this.scrollListener.onScroll(null, firstVisible, visibleCount, itemCount);
            this.lastFirstVisible = firstVisible;
            this.lastVisibleCount = visibleCount;
            this.lastItemCount = itemCount;
        }
    }
}

