/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.PaintEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import javax.swing.JComponent;
import sun.awt.AWTAccessor;

abstract class CacioContainerPeer<AWTComponentType extends Component, SwingComponentType extends JComponent>
extends CacioComponentPeer<AWTComponentType, SwingComponentType>
implements ContainerPeer {
    private boolean isLayouting;

    public CacioContainerPeer(AWTComponentType awtC, PlatformWindowFactory pwf) {
        super(awtC, pwf);
    }

    @Override
    boolean isLayouting() {
        return this.isLayouting;
    }

    @Override
    public void beginLayout() {
        this.isLayouting = true;
    }

    @Override
    public void endLayout() {
        if (!this.getPaintArea().isEmpty() && !AWTAccessor.getComponentAccessor().getIgnoreRepaint((Component)this.getAWTComponent())) {
            this.handlePeerEvent(new PaintEvent((Component)this.getAWTComponent(), 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    @Override
    public void beginValidate() {
    }

    @Override
    public void endValidate() {
    }

    @Override
    public Insets getInsets() {
        return this.platformWindow.getInsets();
    }

    public boolean isRestackSupported() {
        return this.platformWindow.isRestackSupported();
    }

    public void restack() {
        this.platformWindow.restack();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        Container c = (Container)this.getAWTComponent();
        int count = c.getComponentCount();
        for (int i = 0; i < count; ++i) {
            CacioComponentPeer ccp;
            ComponentPeer peer;
            Component comp = c.getComponent(i);
            if (AWTAccessor.getComponentAccessor().getFont(comp) != null || !((peer = CacioContainerPeer.getPeer(comp)) instanceof CacioComponentPeer) || (ccp = (CacioComponentPeer)peer).getFont() == font) continue;
            ccp.setFont(font);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        Container c = (Container)this.getAWTComponent();
        int count = c.getComponentCount();
        for (int i = 0; i < count; ++i) {
            CacioComponentPeer ccp;
            ComponentPeer peer;
            Component comp = c.getComponent(i);
            if (AWTAccessor.getComponentAccessor().getForeground(comp) != null || !((peer = CacioContainerPeer.getPeer(comp)) instanceof CacioComponentPeer) || (ccp = (CacioComponentPeer)peer).getForeground() == fg) continue;
            ccp.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        Container c = (Container)this.getAWTComponent();
        int count = c.getComponentCount();
        for (int i = 0; i < count; ++i) {
            CacioComponentPeer ccp;
            ComponentPeer peer;
            Component comp = c.getComponent(i);
            if (AWTAccessor.getComponentAccessor().getBackground(comp) != null || !((peer = CacioContainerPeer.getPeer(comp)) instanceof CacioComponentPeer) || (ccp = (CacioComponentPeer)peer).getBackground() == bg) continue;
            ccp.setBackground(bg);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable && !this.isParentsEnabled()) {
            return;
        }
        this.setEnabledImpl(enable);
    }

    @Override
    void setEnabledImpl(boolean enable) {
        super.setEnabledImpl(enable);
        Container c = (Container)this.getAWTComponent();
        int count = c.getComponentCount();
        for (int i = 0; i < count; ++i) {
            CacioComponentPeer ccp;
            ComponentPeer peer;
            Component comp = c.getComponent(i);
            if (enable && !AWTAccessor.getComponentAccessor().isEnabled(comp) || !((peer = CacioContainerPeer.getPeer(comp)) instanceof CacioComponentPeer) || (ccp = (CacioComponentPeer)peer).isEnabled() == enable) continue;
            ccp.setEnabledImpl(enable);
        }
    }

    @Override
    protected void peerPaint(Graphics g, boolean update) {
        if (!update) {
            super.peerPaint(g, update);
        }
    }
}

