/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.peer.MouseInfoPeer;

public class CacioMouseInfoPeer
implements MouseInfoPeer {
    private static CacioMouseInfoPeer instance = new CacioMouseInfoPeer();
    private int x;
    private int y;

    public static CacioMouseInfoPeer getInstance() {
        return instance;
    }

    @Override
    public int fillPointWithCoords(Point point) {
        point.x = this.x;
        point.y = this.y;
        return 0;
    }

    public void setMouseScreenCoordinates(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean isWindowUnderMouse(Window w) {
        Window[] windows = Window.getWindows();
        Window found = null;
        for (Window window : windows) {
            if (!window.isVisible() || !this.isMouseInWindowRegion(w) || !window.isActive()) continue;
            found = window;
            break;
        }
        return found == w;
    }

    private boolean isMouseInWindowRegion(Window w) {
        Point l = w.getLocationOnScreen();
        Dimension size = w.getSize();
        return l.x <= this.x && this.x < l.x + size.width && l.y <= this.y && this.y < l.y + size.height;
    }
}

