/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.auditing.plugins;

import com.hpe.caf.auditing.plugins.XMLToJavaTransform;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="xmltojava", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class XMLToJavaMojo
extends AbstractMojo {
    private static final String TRANSFORM_XSD_FILEPATH = "schema/AuditedApplication.xsd";
    private static final String TRANSFORM_TEMPLATE_NAME = "AuditTransform.vm";
    private static final String TRANSFORM_OUTPUT_FILENAME = "AuditLog.java";
    private static final String TRANSFORM_GENSOURCES_DIRECTORY = "/generated-sources/src/";
    private static final String TRANSFORM_GENSOURCES_TEST_DIRECTORY = "/generated-test-sources/src/";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="auditXMLConfig", defaultValue="${project.basedir}/AuditConfig.xml")
    private File auditXMLConfig;
    @Parameter(property="packageName", defaultValue="${project.groupId}.auditing")
    private String packageName;
    @Parameter(property="generateAsTestResource", defaultValue="false")
    private boolean generateAsTestResource;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            XMLToJavaTransform transform = new XMLToJavaTransform(this.auditXMLConfig, this.packageName);
            String transformGenSourcesDir = this.generateAsTestResource ? TRANSFORM_GENSOURCES_TEST_DIRECTORY : TRANSFORM_GENSOURCES_DIRECTORY;
            Path path = Paths.get(this.project.getBuild().getDirectory(), transformGenSourcesDir, this.packageName.replace(".", File.separator));
            File outputDirectory = new File(path.toString());
            transform.doTransform(outputDirectory, TRANSFORM_XSD_FILEPATH, TRANSFORM_TEMPLATE_NAME, TRANSFORM_OUTPUT_FILENAME);
            Path buildPath = Paths.get(this.project.getBuild().getDirectory(), transformGenSourcesDir);
            if (buildPath.toFile().exists() && this.project != null) {
                if (this.generateAsTestResource) {
                    this.project.addTestCompileSourceRoot(buildPath.toString());
                } else {
                    this.project.addCompileSourceRoot(buildPath.toString());
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception : " + e);
        }
    }
}

