/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.auditing.plugins;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XMLToJavaTransform {
    private final File auditXMLConfig;
    private final String packageName;

    public XMLToJavaTransform(File auditXMLConfig, String packageName) {
        this.auditXMLConfig = auditXMLConfig;
        this.packageName = packageName;
    }

    public void doTransform(File outputDirectory, String xsdName, String templateName, String outputFilename) throws Exception {
        block47: {
            boolean bool = false;
            if (this.auditXMLConfig == null || !this.auditXMLConfig.exists()) {
                throw new MojoExecutionException("The audit events XML configuration file cannot be found.");
            }
            try (FileInputStream xmlInputStream = new FileInputStream(this.auditXMLConfig);
                 InputStream xsdInputStream = this.getClass().getClassLoader().getResourceAsStream(xsdName);){
                bool = XMLToJavaTransform.validateXMLAgainstXSD(xmlInputStream, xsdInputStream);
                if (!bool) {
                    throw new MojoExecutionException("The audit events XML configuration file does not conform to the schema.");
                }
                if (!outputDirectory.exists() && !(bool = outputDirectory.mkdirs())) {
                    throw new Exception("Generated java sources directory cannot be created.");
                }
                Velocity.setProperty((String)"resource.loader", (Object)"classpath");
                Velocity.setProperty((String)"classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
                Velocity.init();
                Document root = null;
                try {
                    SAXBuilder builder = new SAXBuilder();
                    root = builder.build(this.auditXMLConfig.getAbsolutePath());
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException("Error parsing document : " + ioe);
                }
                catch (JDOMException jdome) {
                    throw new MojoExecutionException("Error parsing document : " + (Object)((Object)jdome));
                }
                VelocityContext context = new VelocityContext();
                context.put("root", (Object)root);
                context.put("packageName", (Object)this.packageName);
                Template template = null;
                try {
                    template = Velocity.getTemplate((String)templateName);
                }
                catch (ResourceNotFoundException rnfe) {
                    throw new MojoExecutionException("The audit events transform template cannot be found.");
                }
                String transformOutputFile = outputDirectory + File.separator + outputFilename;
                File f = new File(transformOutputFile);
                if (f.exists()) {
                    f.delete();
                }
                if (!(bool = f.createNewFile())) break block47;
                String outFileName = f.getAbsolutePath();
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outFileName)));){
                    template.merge((Context)context, (Writer)writer);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Exception : " + e);
            }
        }
    }

    private static boolean validateXMLAgainstXSD(InputStream xml, InputStream xsd) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(xsd));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

