/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.languagedetection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class LanguageDetectorSettings {
    private boolean detectMultipleLanguages;
    private Collection<String> hints;
    private String encodingHint;

    public LanguageDetectorSettings() {
    }

    public LanguageDetectorSettings(String encodingHint, boolean detectMultipleLanguages, String ... hints) {
        Objects.requireNonNull(encodingHint);
        Objects.requireNonNull(hints);
        this.setDetectMultipleLanguages(detectMultipleLanguages);
        this.setHints(hints);
        this.setEncodingHint(encodingHint);
    }

    public LanguageDetectorSettings(boolean detectMultipleLanguages, String ... hints) {
        this("", detectMultipleLanguages, hints);
    }

    public LanguageDetectorSettings(String encodingHint, boolean detectMultipleLanguages) {
        this(encodingHint, detectMultipleLanguages, "");
    }

    public LanguageDetectorSettings(boolean detectMultipleLanguages) {
        this("", detectMultipleLanguages, "");
    }

    public boolean isDetectMultipleLanguages() {
        return this.detectMultipleLanguages;
    }

    public void setDetectMultipleLanguages(boolean detectMultipleLanguages) {
        this.detectMultipleLanguages = detectMultipleLanguages;
    }

    public Collection<String> getHints() {
        return this.hints;
    }

    public void setHints(String ... hints) {
        this.hints = Arrays.asList(hints);
    }

    public String getEncodingHint() {
        return this.encodingHint;
    }

    public void setEncodingHint(String encodingHint) {
        this.encodingHint = encodingHint;
    }
}

