/*
 * Copyright 2016-2020 Micro Focus or one of its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hpe.caf.worker.document;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import java.util.List;
import java.util.Map;

@JsonInclude(Include.NON_NULL)
public final class DocumentWorkerChange
{
    public SetReferenceParams setReference;

    @JsonInclude(Include.NON_NULL)
    public static final class SetReferenceParams
    {
        public String value;
    }

    public Map<String, List<DocumentWorkerFieldValue>> addFields;

    public Map<String, List<DocumentWorkerFieldValue>> setFields;

    public List<String> removeFields;

    public DocumentWorkerFailure addFailure;

    public List<DocumentWorkerFailure> setFailures;

    public DocumentWorkerDocument addSubdocument;

    public InsertSubdocumentParams insertSubdocument;

    @JsonInclude(Include.NON_NULL)
    public static final class InsertSubdocumentParams
    {
        public int index;
        public DocumentWorkerDocument subdocument;
    }

    public UpdateSubdocumentParams updateSubdocument;

    @JsonInclude(Include.NON_NULL)
    public static final class UpdateSubdocumentParams
    {
        public int index;
        public String reference;
        public List<DocumentWorkerChange> changes;
    }

    public RemoveSubdocumentParams removeSubdocument;

    @JsonInclude(Include.NON_NULL)
    public static final class RemoveSubdocumentParams
    {
        public int index;
        public String reference;
    }
}
