/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.Settings;
import tuwien.auto.calimero.device.KnxDevice;
import tuwien.auto.calimero.device.KnxDeviceServiceLogic;
import tuwien.auto.calimero.device.ManagementService;
import tuwien.auto.calimero.device.ManagementServiceNotifier;
import tuwien.auto.calimero.device.ProcessCommunicationService;
import tuwien.auto.calimero.device.ProcessServiceNotifier;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.device.ios.InterfaceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.device.ios.PropertyEvent;
import tuwien.auto.calimero.knxnetip.ConnectionBase;
import tuwien.auto.calimero.knxnetip.KNXnetIPRouting;
import tuwien.auto.calimero.link.AbstractLink;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Description;

public class BaseKnxDevice
implements KnxDevice {
    private static final int objectInstance = 1;
    private static final int defMfrId = 0;
    private static final byte[] defMfrData = new byte[]{98, 109, 50, 48, 49, 49, 32, 32};
    private static final int pidHardwareType = 78;
    static final int INCOMING_EVENTS_THREADED = 1;
    static final int OUTGOING_EVENTS_THREADED = 2;
    int threadingPolicy = 2;
    private static final ThreadFactory factory = Executors.defaultThreadFactory();
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
        Thread thread = factory.newThread(runnable);
        thread.setName("Calimero Device Task (" + thread.getName() + ")");
        thread.setDaemon(true);
        return thread;
    });
    private boolean taskSubmitted;
    private final List<Runnable> tasks = new ArrayList<Runnable>();
    private final String name;
    private final DeviceDescriptor dd;
    private final InterfaceObjectServer ios;
    private final Logger logger;
    private final ProcessCommunicationService process;
    private final ManagementService mgmt;
    private ProcessServiceNotifier procNotifier;
    private ManagementServiceNotifier mgmtNotifier;
    private KNXNetworkLink link;
    private IndividualAddress self = new IndividualAddress(new byte[]{2, -1});
    private static final int deviceMemorySize = 50000;
    private final byte[] memory = new byte[50000];

    BaseKnxDevice(String string, DeviceDescriptor deviceDescriptor, ProcessCommunicationService processCommunicationService, ManagementService managementService) throws KnxPropertyException {
        this.name = string;
        this.dd = deviceDescriptor;
        this.ios = new InterfaceObjectServer(false);
        this.ios.addServerListener(this::propertyChanged);
        this.logger = LogService.getLogger((String)("calimero.device." + string));
        this.process = processCommunicationService;
        this.mgmt = managementService;
        this.initDeviceInfo();
    }

    BaseKnxDevice(String string, DeviceDescriptor deviceDescriptor, IndividualAddress individualAddress, KNXNetworkLink kNXNetworkLink) throws KNXLinkClosedException, KnxPropertyException {
        this(string, deviceDescriptor, (ProcessCommunicationService)null, null);
        this.setDeviceLink(kNXNetworkLink);
        this.setAddress(individualAddress);
    }

    public BaseKnxDevice(String string, DeviceDescriptor deviceDescriptor, IndividualAddress individualAddress, KNXNetworkLink kNXNetworkLink, ProcessCommunicationService processCommunicationService, ManagementService managementService) throws KNXLinkClosedException, KnxPropertyException {
        this(string, deviceDescriptor, processCommunicationService, managementService);
        this.setDeviceLink(kNXNetworkLink);
        this.setAddress(individualAddress);
    }

    public BaseKnxDevice(String string, KnxDeviceServiceLogic knxDeviceServiceLogic) throws KnxPropertyException {
        this(string, (DeviceDescriptor)DeviceDescriptor.DD0.TYPE_5705, knxDeviceServiceLogic, knxDeviceServiceLogic);
        knxDeviceServiceLogic.setDevice(this);
    }

    public BaseKnxDevice(String string, KnxDeviceServiceLogic knxDeviceServiceLogic, KNXNetworkLink kNXNetworkLink) throws KNXLinkClosedException, KnxPropertyException {
        this(string, (DeviceDescriptor)DeviceDescriptor.DD0.TYPE_5705, kNXNetworkLink.getKNXMedium().getDeviceAddress(), kNXNetworkLink, knxDeviceServiceLogic, knxDeviceServiceLogic);
    }

    protected final synchronized void setAddress(IndividualAddress individualAddress) {
        if (individualAddress == null) {
            throw new NullPointerException("device address cannot be null");
        }
        if (individualAddress.getRawAddress() == 0 || this.self.equals((Object)individualAddress)) {
            return;
        }
        this.self = individualAddress;
        KNXMediumSettings kNXMediumSettings = this.getDeviceLink().getKNXMedium();
        kNXMediumSettings.setDeviceAddress(individualAddress);
        byte[] byArray = this.self.toByteArray();
        this.setDeviceProperty(57, byArray[0]);
        this.setDeviceProperty(58, byArray[1]);
        try {
            this.setIpProperty(52, byArray);
        }
        catch (KnxPropertyException knxPropertyException) {
            // empty catch block
        }
    }

    @Override
    public final synchronized IndividualAddress getAddress() {
        return this.self;
    }

    @Override
    public final synchronized void setDeviceLink(KNXNetworkLink kNXNetworkLink) throws KNXLinkClosedException {
        IndividualAddress individualAddress;
        this.link = kNXNetworkLink;
        if (kNXNetworkLink == null) {
            return;
        }
        this.setDeviceProperty(56, BaseKnxDevice.fromWord(kNXNetworkLink.getKNXMedium().maxApduLength()));
        int n = kNXNetworkLink.getKNXMedium().getMedium();
        this.ios.setProperty(8, 1, 51, 1, 1, 0, (byte)n);
        if (n == 32) {
            this.initKnxipProperties();
        }
        if ((individualAddress = kNXNetworkLink.getKNXMedium().getDeviceAddress()).getDevice() != 0) {
            this.setAddress(individualAddress);
        }
        if (this.process instanceof KnxDeviceServiceLogic) {
            ((KnxDeviceServiceLogic)this.process).setDevice(this);
        }
        this.resetNotifiers();
    }

    @Override
    public final synchronized KNXNetworkLink getDeviceLink() {
        return this.link;
    }

    @Override
    public final InterfaceObjectServer getInterfaceObjectServer() {
        return this.ios;
    }

    public ExecutorService taskExecutor() {
        return executor;
    }

    public String toString() {
        return this.name + " " + this.self;
    }

    void dispatch(EventObject eventObject, Supplier<ServiceResult> supplier, BiConsumer<EventObject, ServiceResult> biConsumer) {
        if (this.threadingPolicy == 1) {
            this.submitTask(() -> {
                try {
                    Optional.ofNullable((ServiceResult)supplier.get()).ifPresent(serviceResult -> biConsumer.accept(eventObject, (ServiceResult)serviceResult));
                }
                finally {
                    this.taskDone();
                }
            });
        } else {
            Optional.ofNullable(supplier.get()).ifPresent(serviceResult -> this.submitTask(() -> {
                try {
                    biConsumer.accept(eventObject, (ServiceResult)serviceResult);
                }
                finally {
                    this.taskDone();
                }
            }));
        }
    }

    DeviceDescriptor deviceDescriptor() {
        return this.dd;
    }

    Logger logger() {
        return this.logger;
    }

    private synchronized void resetNotifiers() throws KNXLinkClosedException {
        if (this.procNotifier != null) {
            this.procNotifier.close();
        }
        ProcessServiceNotifier processServiceNotifier = this.procNotifier = this.link != null && this.process != null ? new ProcessServiceNotifier(this, this.process) : null;
        if (this.mgmtNotifier != null) {
            this.mgmtNotifier.close();
        }
        this.mgmtNotifier = this.link != null && this.mgmt != null ? new ManagementServiceNotifier(this, this.mgmt) : null;
    }

    private void initDeviceInfo() throws KnxPropertyException {
        Object object;
        byte[] byArray = this.name.getBytes(Charset.forName("ISO-8859-1"));
        this.ios.setProperty(0, 1, 21, 1, byArray.length, byArray);
        String[] stringArray = Settings.getLibraryVersion().split("\\.| |-", -1);
        int n = 0;
        try {
            n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n2 = Integer.parseInt(stringArray[0]) << 12 | Integer.parseInt(stringArray[1]) << 6 | n;
        this.setDeviceProperty(25, BaseKnxDevice.fromWord(n2));
        this.setDeviceProperty(9, 1);
        byte[] byArray2 = new byte[6];
        this.setDeviceProperty(11, byArray2);
        this.setDeviceProperty(54, 0);
        this.setMemory(96, 0);
        this.setDeviceProperty(12, BaseKnxDevice.fromWord(0));
        this.ios.setProperty(0, 1, 19, 1, defMfrData.length / 4, defMfrData);
        byte[] byArray3 = new byte[6];
        this.setDeviceProperty(78, byArray3);
        if (this.dd instanceof DeviceDescriptor.DD0) {
            this.setDeviceProperty(83, this.dd.toByteArray());
            object = (DeviceDescriptor.DD0)this.dd;
            int n3 = object.maskVersion();
            if ((n3 == 37 || n3 == 1797) && byArray3[0] != 0) {
                this.logger.error("manufacturer-specific device identification of hardware type should be 0 for this mask!");
            }
        }
        this.ios.setDescription(new Description(0, 0, 56, 0, 0, false, 0, 1, 3, 0), true);
        this.setDeviceProperty(56, BaseKnxDevice.fromWord(15));
        object = new byte[10];
        this.setDeviceProperty(15, (byte[])object);
        this.setDeviceProperty(16, 0);
        this.ios.setProperty(8, 1, 51, 1, 1, 0, 2);
        this.ios.addInterfaceObject(3);
        this.ios.setProperty(3, 1, 16, 1, 1, BaseKnxDevice.fromByte(0));
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5};
        int n4 = nArray[1];
        this.ios.setProperty(3, 1, 6, 1, 1, BaseKnxDevice.fromWord(n4));
        byte[] byArray4 = new byte[5];
        this.ios.setProperty(3, 1, 13, 1, 1, byArray4);
    }

    private void setDeviceProperty(int n, byte ... byArray) throws KnxPropertyException {
        this.ios.setProperty(0, 1, n, 1, 1, byArray);
    }

    private void setIpProperty(int n, byte ... byArray) {
        this.ios.setProperty(11, 1, n, 1, 1, byArray);
    }

    private Object[] ipInfo() throws ReflectiveOperationException {
        KNXnetIPRouting kNXnetIPRouting = (KNXnetIPRouting)this.accessField(AbstractLink.class, "conn", this.link);
        if (kNXnetIPRouting == null) {
            throw new RuntimeException("no KNX IP routing connection found in link " + this.link.getName());
        }
        MulticastSocket multicastSocket = (MulticastSocket)this.accessField(ConnectionBase.class, "socket", kNXnetIPRouting);
        return new Object[]{kNXnetIPRouting, multicastSocket, kNXnetIPRouting.getRemoteAddress().getAddress()};
    }

    private <T, U> T accessField(Class<? extends U> clazz, String string, U u) throws ReflectiveOperationException, SecurityException {
        Class<?> clazz2;
        for (clazz2 = u.getClass(); clazz2 != null && !clazz.equals(clazz2); clazz2 = clazz2.getSuperclass()) {
        }
        if (clazz2 == null) {
            return null;
        }
        Field field = clazz2.getDeclaredField(string);
        field.setAccessible(true);
        return (T)field.get(u);
    }

    /*
     * WARNING - void declaration
     */
    private void initKnxipProperties() {
        void var5_15;
        void var2_7;
        Object object;
        Object object2;
        Object[] objectArray;
        boolean bl = false;
        for (InterfaceObject interfaceObject : this.ios.getInterfaceObjects()) {
            bl |= interfaceObject.getType() == 11;
        }
        if (!bl) {
            this.ios.addInterfaceObject(11);
        }
        this.setIpProperty(51, BaseKnxDevice.fromWord(0));
        this.setIpProperty(52, this.self.toByteArray());
        this.setIpProperty(54, 1);
        this.setIpProperty(55, 1);
        this.setIpProperty(56, 0);
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[6];
        byte[] byArray4 = new byte[4];
        try {
            List<InterfaceAddress> list;
            Optional<InterfaceAddress> optional;
            byte[] byArray5 = InetAddress.getLocalHost().getAddress();
            objectArray = this.ipInfo();
            object2 = (MulticastSocket)objectArray[1];
            byte[] byArray6 = ((InetAddress)objectArray[2]).getAddress();
            object = ((MulticastSocket)object2).getNetworkInterface();
            if (NetworkInterface.getByName(((NetworkInterface)object).getName()) != null && (optional = (list = ((NetworkInterface)object).getInterfaceAddresses()).stream().filter(interfaceAddress -> interfaceAddress.getAddress() instanceof Inet4Address).findFirst()).isPresent()) {
                byte[] byArray7 = optional.get().getAddress().getAddress();
                short s = optional.get().getNetworkPrefixLength();
                long l = 0xFFFFFFFFL ^ 0xFFFFFFFFL >> s;
                ByteBuffer.wrap(byArray2).putInt((int)l);
            }
            byArray3 = Optional.ofNullable(((NetworkInterface)object).getHardwareAddress()).orElse(byArray3);
        }
        catch (IOException | ReflectiveOperationException | RuntimeException exception) {
            this.logger.warn("initializing KNX IP properties, {}", (Object)exception.toString());
        }
        this.setIpProperty(57, (byte[])var2_7);
        this.setIpProperty(58, byArray2);
        objectArray = new byte[4];
        this.setIpProperty(59, (byte[])objectArray);
        this.setIpProperty(60, (byte[])var2_7);
        this.setIpProperty(61, byArray2);
        this.setIpProperty(62, (byte[])objectArray);
        this.setIpProperty(64, byArray3);
        try {
            object2 = InetAddress.getByName("224.0.23.12");
            this.setIpProperty(65, ((InetAddress)object2).getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.setIpProperty(66, (byte[])var5_15);
        this.setIpProperty(67, 16);
        this.setIpProperty(68, BaseKnxDevice.fromWord(4));
        this.setIpProperty(69, 0);
        this.setIpProperty(72, BaseKnxDevice.fromWord(0));
        this.setIpProperty(74, new byte[4]);
        object = Arrays.copyOf(this.name.getBytes(Charset.forName("ISO-8859-1")), 30);
        this.ios.setProperty(11, 1, 76, 1, ((Object)object).length, (byte[])object);
        this.setIpProperty(78, BaseKnxDevice.fromWord(100));
    }

    private void propertyChanged(PropertyEvent propertyEvent) {
        try {
            if (propertyEvent.getInterfaceObject().getType() == 11) {
                int n = propertyEvent.getPropertyId();
                if (n == 67) {
                    KNXnetIPRouting kNXnetIPRouting = (KNXnetIPRouting)this.ipInfo()[0];
                    kNXnetIPRouting.setHopCount((int)propertyEvent.getNewData()[0]);
                } else if (n == 52) {
                    this.setAddress(new IndividualAddress(propertyEvent.getNewData()));
                }
            }
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            this.logger.warn("updating {} PID {} with [{}]: {}", new Object[]{propertyEvent.getInterfaceObject(), propertyEvent.getPropertyId(), DataUnitBuilder.toHex((byte[])propertyEvent.getNewData(), (String)""), exception.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitTask(Runnable runnable) {
        List<Runnable> list = this.tasks;
        synchronized (list) {
            if (this.taskSubmitted) {
                this.tasks.add(runnable);
            } else {
                this.taskSubmitted = true;
                this.taskExecutor().submit(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskDone() {
        List<Runnable> list = this.tasks;
        synchronized (list) {
            if (this.tasks.isEmpty()) {
                this.taskSubmitted = false;
            } else {
                this.taskExecutor().submit(this.tasks.remove(0));
            }
        }
    }

    synchronized byte[] deviceMemory() {
        return this.memory;
    }

    byte[] deviceMemory(int n, int n2) {
        return Arrays.copyOfRange(this.deviceMemory(), n, n + n2);
    }

    private synchronized void setMemory(int n, byte ... byArray) {
        System.arraycopy(byArray, 0, this.memory, n, byArray.length);
    }

    private static byte[] fromWord(int n) {
        return new byte[]{(byte)(n >> 8), (byte)n};
    }

    private static byte[] fromByte(int n) {
        return new byte[]{(byte)n};
    }
}

