/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.DatapointMap;
import tuwien.auto.calimero.datapoint.DatapointModel;
import tuwien.auto.calimero.device.BaseKnxDevice;
import tuwien.auto.calimero.device.KnxDevice;
import tuwien.auto.calimero.device.ManagementService;
import tuwien.auto.calimero.device.ProcessCommunicationService;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.PLSettings;
import tuwien.auto.calimero.link.medium.RFSettings;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.process.ProcessEvent;

public abstract class KnxDeviceServiceLogic
implements ProcessCommunicationService,
ManagementService {
    protected KnxDevice device;
    private Logger logger;
    private final DatapointModel<Datapoint> datapoints = new DatapointMap();
    private byte[] domainAddress;
    private static byte[] defaultAuthKey = new byte[]{-1, -1, -1, -1};
    final byte[][] authKeys = new byte[16][4];
    final WeakHashMap<Destination, Integer> accessLevels = new WeakHashMap();
    int minAccessLevel = 3;
    private static final int addrGroupAddrTable = 278;

    public void setDevice(KnxDevice knxDevice) {
        this.device = knxDevice;
        this.logger = knxDevice instanceof BaseKnxDevice ? ((BaseKnxDevice)knxDevice).logger() : LoggerFactory.getLogger(KnxDeviceServiceLogic.class);
        this.domainAddress = new byte[0];
        KNXNetworkLink kNXNetworkLink = knxDevice.getDeviceLink();
        if (kNXNetworkLink != null) {
            KNXMediumSettings kNXMediumSettings = kNXNetworkLink.getKNXMedium();
            if (kNXMediumSettings.getMedium() == 4) {
                this.domainAddress = ((PLSettings)kNXMediumSettings).getDomainAddress();
            } else if (kNXMediumSettings.getMedium() == 16) {
                this.domainAddress = ((RFSettings)kNXMediumSettings).getDomainAddress();
            }
        }
        for (int i = 0; i < 16; ++i) {
            this.authKeys[i] = defaultAuthKey;
        }
    }

    public final DatapointModel<Datapoint> getDatapointModel() {
        return this.datapoints;
    }

    public abstract void updateDatapointValue(Datapoint var1, DPTXlator var2);

    public abstract DPTXlator requestDatapointValue(Datapoint var1) throws KNXException;

    byte[] getDeviceMemory() {
        return ((BaseKnxDevice)this.device).deviceMemory();
    }

    public final void setProgrammingMode(boolean bl) {
        byte[] byArray = this.getDeviceMemory();
        int n = byArray[96];
        n = bl ? n | 1 : n & 0xFFFFFFFE;
        byArray[96] = (byte)n;
    }

    public final boolean inProgrammingMode() {
        byte[] byArray = this.getDeviceMemory();
        return (byArray[96] & 1) == 1;
    }

    @Override
    public ServiceResult groupReadRequest(ProcessEvent processEvent) {
        GroupAddress groupAddress = processEvent.getDestination();
        Datapoint datapoint = this.getDatapointModel().get(groupAddress);
        if (datapoint != null) {
            try {
                DPTXlator dPTXlator = this.requestDatapointValue(datapoint);
                if (dPTXlator != null) {
                    return new ServiceResult(dPTXlator.getData(), dPTXlator.getTypeSize() == 0);
                }
            }
            catch (RuntimeException | KNXException throwable) {
                this.logger.warn("on group read request {}->{}: {}", new Object[]{processEvent.getSourceAddr(), groupAddress, DataUnitBuilder.toHex((byte[])processEvent.getASDU(), (String)" "), throwable});
            }
        }
        return null;
    }

    @Override
    public void groupWrite(ProcessEvent processEvent) {
        GroupAddress groupAddress = processEvent.getDestination();
        Datapoint datapoint = this.getDatapointModel().get(groupAddress);
        if (datapoint == null) {
            return;
        }
        try {
            DPTXlator dPTXlator = TranslatorTypes.createTranslator((int)0, (String)datapoint.getDPT());
            dPTXlator.setData(processEvent.getASDU());
            this.updateDatapointValue(datapoint, dPTXlator);
        }
        catch (RuntimeException | KNXException throwable) {
            this.logger.warn("on group write {}->{}: {}", new Object[]{processEvent.getSourceAddr(), groupAddress, DataUnitBuilder.toHex((byte[])processEvent.getASDU(), (String)" "), throwable});
        }
    }

    @Override
    public void groupResponse(ProcessEvent processEvent) {
    }

    @Override
    public ServiceResult readProperty(Destination destination, int n, int n2, int n3, int n4) {
        Object object;
        InterfaceObjectServer interfaceObjectServer = this.device.getInterfaceObjectServer();
        try {
            object = interfaceObjectServer.getDescription(n, n2);
            Integer n5 = this.accessLevel(destination);
            if (n5 > object.getReadLevel()) {
                this.logger.warn("deny {} read access to property {}|{} (access level {}, requires {})", new Object[]{destination.getAddress(), n, n2, n5, object.getReadLevel()});
                return null;
            }
        }
        catch (KnxPropertyException knxPropertyException) {
            // empty catch block
        }
        object = interfaceObjectServer.getProperty(n, n2, n3, n4);
        return new ServiceResult((byte[])object);
    }

    @Override
    public ServiceResult writeProperty(Destination destination, int n, int n2, int n3, int n4, byte[] byArray) {
        Description description;
        InterfaceObjectServer interfaceObjectServer;
        block6: {
            interfaceObjectServer = this.device.getInterfaceObjectServer();
            description = null;
            try {
                description = interfaceObjectServer.getDescription(n, n2);
            }
            catch (KnxPropertyException knxPropertyException) {
                int n5 = interfaceObjectServer.getInterfaceObjects()[n].getType();
                PropertyClient.Property property = interfaceObjectServer.propertyDefinitions().get(new PropertyClient.PropertyKey(n5, n2));
                if (property == null) break block6;
                description = new Description(n, n5, n2, 0, property.getPDT(), !property.readOnly(), 0, 1, property.readLevel(), property.writeLevel());
            }
        }
        if (description != null) {
            if (!description.isWriteEnabled()) {
                this.logger.warn("property {}|{} is {}", new Object[]{n, n2, CEMIDevMgmt.getErrorMessage((int)5)});
                return null;
            }
            Integer n6 = this.accessLevel(destination);
            if (n6 > description.getWriteLevel()) {
                this.logger.warn("deny {} write access to property {}|{} (access level {}, requires {})", new Object[]{destination.getAddress(), n, n2, n6, description.getWriteLevel()});
                return null;
            }
        }
        interfaceObjectServer.setProperty(n, n2, n3, n4, byArray);
        if (n2 == 54) {
            this.setProgrammingMode((byArray[0] & 1) == 1);
        }
        return new ServiceResult(byArray);
    }

    @Override
    public ServiceResult readPropertyDescription(int n, int n2, int n3) {
        InterfaceObjectServer interfaceObjectServer = this.device.getInterfaceObjectServer();
        Description description = n2 > 0 ? interfaceObjectServer.getDescription(n, n2) : interfaceObjectServer.getDescriptionByIndex(n, n3);
        return new ServiceResult(description.toByteArray());
    }

    @Override
    public ServiceResult readMemory(int n, int n2) {
        if (n >= this.getDeviceMemory().length) {
            return ServiceResult.Empty;
        }
        Collection collection = ((DatapointMap)this.datapoints).getDatapoints();
        int n3 = 3 + collection.size() * 2;
        if (n >= 278 && n < 278 + n3) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
            byteBuffer.put((byte)collection.size());
            byteBuffer.put(this.device.getAddress().toByteArray());
            collection.forEach(datapoint -> byteBuffer.put(datapoint.getMainAddress().toByteArray()));
            int n4 = n - 278;
            return new ServiceResult(Arrays.copyOfRange(byteBuffer.array(), n4, n4 + n2));
        }
        return new ServiceResult(Arrays.copyOfRange(this.getDeviceMemory(), n, n + n2));
    }

    @Override
    public ServiceResult writeMemory(int n, byte[] byArray) {
        byte[] byArray2 = this.getDeviceMemory();
        for (int i = 0; i < byArray.length; ++i) {
            byte by;
            byArray2[n + i] = by = byArray[i];
        }
        return new ServiceResult(byArray);
    }

    @Override
    public ServiceResult readAddress() {
        if (this.inProgrammingMode()) {
            return ServiceResult.Empty;
        }
        return null;
    }

    @Override
    public ServiceResult readAddressSerial(byte[] byArray) {
        byte[] byArray2 = this.device.getInterfaceObjectServer().getProperty(0, 11, 1, 1);
        if (Arrays.equals(byArray2, byArray)) {
            return ServiceResult.Empty;
        }
        return null;
    }

    @Override
    public ServiceResult writeAddress(IndividualAddress individualAddress) {
        if (!this.inProgrammingMode()) {
            return null;
        }
        IndividualAddress individualAddress2 = this.device.getAddress();
        KNXMediumSettings kNXMediumSettings = this.device.getDeviceLink().getKNXMedium();
        kNXMediumSettings.setDeviceAddress(individualAddress);
        if (this.device instanceof BaseKnxDevice) {
            ((BaseKnxDevice)this.device).setAddress(individualAddress);
        }
        this.logger.info("set new device address {} (old {})", (Object)individualAddress, (Object)individualAddress2);
        return null;
    }

    @Override
    public ServiceResult writeAddressSerial(byte[] byArray, IndividualAddress individualAddress) {
        byte[] byArray2 = this.device.getInterfaceObjectServer().getProperty(0, 11, 1, 1);
        if (Arrays.equals(byArray2, byArray)) {
            KNXMediumSettings kNXMediumSettings = this.device.getDeviceLink().getKNXMedium();
            kNXMediumSettings.setDeviceAddress(individualAddress);
        }
        return null;
    }

    @Override
    public ServiceResult readDomainAddress() {
        if (this.inProgrammingMode()) {
            return new ServiceResult(this.domainAddress);
        }
        return null;
    }

    @Override
    public ServiceResult readDomainAddress(byte[] byArray, IndividualAddress individualAddress, int n) {
        int n2;
        int n3;
        if (Arrays.equals(byArray, this.domainAddress) && (n3 = this.device.getAddress().getRawAddress()) >= (n2 = individualAddress.getRawAddress()) && n3 <= n2 + n) {
            int n4 = (n3 - n2) * this.device.getDeviceLink().getKNXMedium().timeFactor();
            this.logger.trace("read domain address: wait " + n4 + " ms before sending response");
            try {
                Thread.sleep(n4);
                return new ServiceResult(this.domainAddress);
            }
            catch (InterruptedException interruptedException) {
                this.logger.warn("read domain address got interrupted, response is canceled");
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    @Override
    public ServiceResult readDomainAddress(byte[] byArray, byte[] byArray2) {
        long l = ByteBuffer.wrap(byArray).getLong();
        long l2 = ByteBuffer.wrap(byArray2).getLong();
        long l3 = ByteBuffer.wrap(this.domainAddress).getLong();
        if (l3 >= l && l3 <= l2) {
            int n = new Random().nextInt(2001);
            this.logger.trace("read domain address: wait " + n + " ms before sending response");
            try {
                Thread.sleep(n);
                return new ServiceResult(this.domainAddress);
            }
            catch (InterruptedException interruptedException) {
                this.logger.warn("read domain address got interrupted, response is canceled");
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    @Override
    public ServiceResult writeDomainAddress(byte[] byArray) {
        if (this.inProgrammingMode()) {
            this.domainAddress = byArray;
            int n = byArray.length == 2 ? 70 : 82;
            try {
                this.device.getInterfaceObjectServer().setProperty(0, n, 1, 1, byArray);
            }
            catch (KnxPropertyException knxPropertyException) {
                this.logger.error("setting DoA {} in interface object server", (Object)DataUnitBuilder.toHex((byte[])byArray, (String)" "), (Object)knxPropertyException);
            }
        }
        return null;
    }

    @Override
    public ServiceResult readDescriptor(int n) {
        DeviceDescriptor deviceDescriptor;
        if (n == 0) {
            return new ServiceResult(this.device.getInterfaceObjectServer().getProperty(0, 83, 1, 1));
        }
        if (this.device instanceof BaseKnxDevice && (deviceDescriptor = ((BaseKnxDevice)this.device).deviceDescriptor()) instanceof DeviceDescriptor.DD2) {
            return new ServiceResult(deviceDescriptor.toByteArray());
        }
        return null;
    }

    @Override
    public ServiceResult readADC(int n, int n2) {
        return new ServiceResult((byte)n, (byte)n2, 1, 0);
    }

    @Override
    public ServiceResult writeAuthKey(Destination destination, int n, byte[] byArray) {
        if (n >= this.minAccessLevel) {
            return new ServiceResult((byte)this.minAccessLevel);
        }
        if (this.accessLevel(destination) > n) {
            return new ServiceResult(-1);
        }
        this.authKeys[n] = byArray;
        return new ServiceResult((byte)n);
    }

    @Override
    public ServiceResult authorize(Destination destination, byte[] byArray) {
        int n = this.minAccessLevel;
        if (!Arrays.equals(byArray, defaultAuthKey)) {
            for (int i = 0; i < this.authKeys.length; ++i) {
                if (!Arrays.equals(byArray, this.authKeys[i])) continue;
                n = i;
                break;
            }
        }
        this.setAccessLevel(destination, n);
        return new ServiceResult((byte)n);
    }

    @Override
    public ServiceResult restart(boolean bl, int n, int n2) {
        this.logger.info("received request to restart");
        this.setProgrammingMode(false);
        return null;
    }

    @Override
    public ServiceResult management(int n, byte[] byArray, KNXAddress kNXAddress, Destination destination, TransportLayer transportLayer) {
        this.logger.info("{}->{} {} {}", new Object[]{destination.getAddress(), kNXAddress, DataUnitBuilder.decodeAPCI((int)n), DataUnitBuilder.toHex((byte[])byArray, (String)"")});
        return null;
    }

    @Override
    public boolean isVerifyModeEnabled() {
        return false;
    }

    void destinationDisconnected(Destination destination) {
        Integer n = this.accessLevels.remove(destination);
        if (n != null) {
            this.logger.info("endpoint {} disconnected, reset access level {} to {}", new Object[]{destination.getAddress(), n, this.minAccessLevel});
        }
    }

    protected int accessLevel(Destination destination) {
        return this.accessLevels.getOrDefault(destination, this.minAccessLevel);
    }

    private void setAccessLevel(Destination destination, int n) {
        this.accessLevels.put(destination, n);
        this.logger.info("authorize {} for access level {}", (Object)destination.getAddress(), (Object)n);
    }
}

