/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.ManagementClient;

public final class LinkProcedure
implements Runnable {
    private static final EnumSet<Action> actuator = EnumSet.of(Action.EnterConfigMode, new Action[]{Action.ChannelFunctionActuator, Action.SetChannelParam, Action.BeginConnection, Action.LinkResponse, Action.QuitConfigMode});
    private static final EnumSet<Action> sensor = EnumSet.of(Action.StartLink, Action.ChannelFunctionSensor, Action.ChannelParamResponse, Action.SetDeleteLink, Action.StopLink);
    private static final int deviceObjectType = 0;
    private static final int pidConfigLink = 59;
    private static final long timeout = 3000L;
    private static final Logger logger = LoggerFactory.getLogger((String)"calimero.device.LinkProcedure");
    private final boolean isActuator;
    private final boolean reset;
    private Action state = Action.None;
    private final ManagementClient mgmt;
    private final IndividualAddress self;
    private final IndividualAddress remote;
    private final int mfId;
    private final boolean unidir;
    private int expectedGroupObjects;
    private static final boolean paramIndicator = false;
    private static final int subFunction = 0;
    private final int channelCode;
    private final int subFunc = 0;
    private final Map<Integer, GroupAddress> groupObjects;
    private int activeConnectionCode;
    public static final int LinkAdded = 0;
    public static final int UseExistingAddress = 1;
    public static final int LinkDeleted = 2;
    public static final int LinkNotAdded = 3;
    public static final int Error = 4;
    private boolean abort;
    private boolean noChannel;
    private boolean timerExpired;
    private boolean wrongService;
    private BiFunction<Integer, Map<Integer, GroupAddress>, Integer> linkFunction = (n, map) -> 0;
    private volatile int linkResponseStatus;
    private static final int NetworkParamWrite = 996;

    public static LinkProcedure forActuator(ManagementClient managementClient, IndividualAddress individualAddress, Destination destination, int n) {
        return new LinkProcedure(true, false, managementClient, individualAddress, destination, false, 0, n, new HashMap<Integer, GroupAddress>());
    }

    public static LinkProcedure forSensor(ManagementClient managementClient, IndividualAddress individualAddress, Destination destination, boolean bl, int n, Map<Integer, GroupAddress> map) {
        return new LinkProcedure(false, false, managementClient, individualAddress, destination, bl, n, 0, map);
    }

    public static LinkProcedure resetInstallation(ManagementClient managementClient) {
        return new LinkProcedure(false, true, managementClient, new IndividualAddress(0), null, false, 0, 0, Collections.emptyMap());
    }

    public static boolean isEnterConfigMode(byte[] byArray) {
        int n = byArray[0] & 0xFF00 | byArray[1] & 0xFF;
        int n2 = byArray[2] & 0xFF;
        if (n == 0 && n2 == 59) {
            int n3 = (byArray[3] & 0xFF) >> 4;
            Action action = Action.values()[n3];
            return action == Action.EnterConfigMode;
        }
        return false;
    }

    private LinkProcedure(boolean bl, boolean bl2, ManagementClient managementClient, IndividualAddress individualAddress, Destination destination, boolean bl3, int n2, int n3, Map<Integer, GroupAddress> map2) {
        this.isActuator = bl;
        this.reset = bl2;
        this.mgmt = managementClient;
        this.self = individualAddress;
        this.remote = destination != null ? destination.getAddress() : null;
        this.unidir = bl3;
        this.mfId = n2;
        this.channelCode = n3;
        this.groupObjects = Collections.synchronizedMap(map2);
    }

    public void setLinkFunction(BiFunction<Integer, Map<Integer, GroupAddress>, Integer> biFunction) {
        this.linkFunction = biFunction;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void onCommand(Action action) {
        logger.debug("on {}", (Object)action);
    }

    private byte[] create(Action action) {
        int n = action.ordinal() << 4;
        byte[] byArray = new byte[]{(byte)n, 0, 0, 0};
        int n2 = 0;
        switch (action) {
            case StartLink: {
                n2 = (this.unidir ? 8 : 0) | 0 | 0;
                byArray[1] = (byte)(this.mfId >> 8);
                byArray[2] = (byte)this.mfId;
                byArray[3] = (byte)this.groupObjects.size();
                break;
            }
            case ChannelFunctionActuator: 
            case ChannelFunctionSensor: {
                byArray[1] = (byte)(this.channelCode >> 8);
                byArray[2] = (byte)this.channelCode;
                break;
            }
            case SetDeleteLink: 
            case LinkResponse: {
                n2 = action == Action.SetDeleteLink ? 0 : this.linkResponseStatus;
                GroupAddress groupAddress = this.groupObjects.get(this.activeConnectionCode);
                byte[] byArray2 = groupAddress.toByteArray();
                byArray[1] = (byte)this.activeConnectionCode;
                byArray[2] = byArray2[0];
                byArray[3] = byArray2[1];
                logger.info("create {}: connection code {} ==> {}", new Object[]{action, this.activeConnectionCode, groupAddress});
                break;
            }
            case StopLink: {
                n2 = (this.abort ? 4 : 0) | (this.noChannel ? 2 : 0) | (this.timerExpired ? 1 : 0);
                break;
            }
            case QuitConfigMode: {
                n2 = this.timerExpired ? 1 : (this.noChannel ? 2 : (this.wrongService ? 3 : 0));
                break;
            }
        }
        byArray[0] = (byte)(byArray[0] | n2);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Action action) throws KNXLinkClosedException, KNXTimeoutException {
        byte[] byArray = this.create(action);
        logger.info("send {}", (Object)action);
        LinkProcedure linkProcedure = this;
        synchronized (linkProcedure) {
            this.mgmt.writeNetworkParameter(this.remote, 0, 59, byArray);
            this.state = action;
        }
        LinkProcedure.onCommand(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedManagementService(FrameEvent frameEvent) {
        byte[] byArray = frameEvent.getFrame().getPayload();
        int n = DataUnitBuilder.getAPDUService((byte[])byArray);
        if (n == 996) {
            if (((CEMILData)frameEvent.getFrame()).getSource().equals((Object)this.self)) {
                logger.debug("received management service sent by us ({}) -- ignore", (Object)this.self);
                return;
            }
            byte[] byArray2 = DataUnitBuilder.extractASDU((byte[])byArray);
            int n2 = byArray2[0] & 0xFF00 | byArray2[1] & 0xFF;
            int n3 = byArray2[2] & 0xFF;
            if (n2 == 0 && n3 == 59) {
                int n4 = (byArray2[3] & 0xFF) >> 4;
                Action action = Action.values()[n4];
                this.parseAction(action, byArray2);
                LinkProcedure linkProcedure = this;
                synchronized (linkProcedure) {
                    this.state = action;
                    this.notifyAll();
                }
            }
        }
    }

    private void parseAction(Action action, byte[] byArray) {
        int n = byArray[3] & 0xF;
        switch (action) {
            case StartLink: {
                int n2 = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
                int n3 = byArray[6] & 0xFF;
                boolean bl = (n & 8) == 8;
                boolean bl2 = (n & 4) == 4;
                int n4 = n & 3;
                logger.debug("received {}: unidir {}, params {}, subfunc {}, manufacturer code {}, group objects to link: {}", new Object[]{action, bl, bl2, n4, n2, n3});
                this.expectedGroupObjects = Math.max(1, n3);
                break;
            }
            case ChannelFunctionActuator: 
            case ChannelFunctionSensor: {
                int n5 = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
                logger.debug("received {}: E-mode channel code {}", (Object)action, (Object)n5);
                break;
            }
            case SetDeleteLink: 
            case LinkResponse: {
                int n6 = byArray[4] & 0xFF;
                GroupAddress groupAddress = new GroupAddress((byArray[5] & 0xFF) << 8 | byArray[6] & 0xFF);
                this.groupObjects.put(n6, groupAddress);
                logger.info("received {}: flags {}, connection code {} ==> {}", new Object[]{action, n, n6, groupAddress});
                if (action == Action.SetDeleteLink) {
                    this.activeConnectionCode = n6;
                } else {
                    if (this.activeConnectionCode != n6) {
                        logger.error("link response connection code {} does not match {}", (Object)n6, (Object)this.activeConnectionCode);
                    }
                    if ((n & 4) == 4) {
                        this.abort = true;
                    }
                }
                this.linkResponseStatus = this.linkFunction.apply(n, this.groupObjects);
                break;
            }
            case StopLink: 
            case QuitConfigMode: {
                int n7 = byArray[3] & 7;
                logger.debug("received {}: status {}", (Object)action, (Object)n7);
                break;
            }
        }
    }

    private void stopLink(Exception exception) {
        logger.error("stop link procedure with {}", (Object)this.remote, (Object)exception);
        try {
            if (this.state.ordinal() >= Action.EnterConfigMode.ordinal()) {
                this.write(Action.StopLink);
            }
        }
        catch (KNXTimeoutException | KNXLinkClosedException throwable) {
            // empty catch block
        }
    }

    private synchronized void waitFor(Action action) throws InterruptedException, KNXTimeoutException {
        logger.trace("wait for command {}", (Object)action);
        long l = System.currentTimeMillis();
        for (long i = 3000L; i > 0L; i -= System.currentTimeMillis() - l) {
            if (this.state == action) {
                LinkProcedure.onCommand(action);
                return;
            }
            this.wait(i);
        }
        this.timerExpired = true;
        throw new KNXTimeoutException("pairing timeout waiting for " + (Object)((Object)action));
    }

    static enum Action {
        None,
        EnterConfigMode,
        StartLink,
        ChannelFunctionActuator,
        ChannelFunctionSensor,
        SetChannelParam,
        ChannelParamResponse,
        BeginConnection,
        SetDeleteLink,
        LinkResponse,
        StopLink,
        QuitConfigMode,
        ResetInstallation,
        Features;

    }
}

