/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.util.Arrays;
import java.util.EventObject;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.device.BaseKnxDevice;
import tuwien.auto.calimero.device.KnxDeviceServiceLogic;
import tuwien.auto.calimero.device.ManagementService;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.KNXDisconnectException;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.mgmt.TransportLayerImpl;
import tuwien.auto.calimero.mgmt.TransportListener;

final class ManagementServiceNotifier
implements TransportListener,
AutoCloseable {
    private static final int ADC_READ = 384;
    private static final int ADC_RESPONSE = 448;
    private static final int AUTHORIZE_READ = 977;
    private static final int AUTHORIZE_RESPONSE = 978;
    private static final int DOA_WRITE = 992;
    private static final int DOA_READ = 993;
    private static final int DOA_RESPONSE = 994;
    private static final int DOA_SELECTIVE_READ = 995;
    private static final int IND_ADDR_READ = 256;
    private static final int IND_ADDR_RESPONSE = 320;
    private static final int IND_ADDR_WRITE = 192;
    private static final int IND_ADDR_SN_READ = 988;
    private static final int IND_ADDR_SN_RESPONSE = 989;
    private static final int IND_ADDR_SN_WRITE = 990;
    private static final int DEVICE_DESC_READ = 768;
    private static final int DEVICE_DESC_RESPONSE = 832;
    private static final int KEY_WRITE = 979;
    private static final int KEY_RESPONSE = 980;
    private static final int MEMORY_READ = 512;
    private static final int MEMORY_RESPONSE = 576;
    private static final int MEMORY_WRITE = 640;
    private static final int PROPERTY_DESC_READ = 984;
    private static final int PROPERTY_DESC_RESPONSE = 985;
    private static final int PROPERTY_READ = 981;
    private static final int PROPERTY_RESPONSE = 982;
    private static final int PROPERTY_WRITE = 983;
    private static final int RESTART = 896;
    private static final int defaultMaxApduLength = 15;
    private boolean missingApduLength;
    private final BaseKnxDevice device;
    private final TransportLayer tl;
    private final ManagementService mgmtSvc;
    private final Logger logger;
    private final int lengthDoA;

    ManagementServiceNotifier(BaseKnxDevice baseKnxDevice, ManagementService managementService) throws KNXLinkClosedException {
        this.device = baseKnxDevice;
        this.tl = new TransportLayerImpl(baseKnxDevice.getDeviceLink(), true);
        this.tl.addTransportListener((TransportListener)this);
        this.mgmtSvc = managementService;
        this.logger = baseKnxDevice.logger();
        int n = baseKnxDevice.getDeviceLink().getKNXMedium().getMedium();
        this.lengthDoA = n == 4 ? 2 : (n == 16 ? 6 : 0);
    }

    public void broadcast(FrameEvent frameEvent) {
        this.dispatchAndRespond(frameEvent);
    }

    public void dataConnected(FrameEvent frameEvent) {
        this.dispatchAndRespond(frameEvent);
    }

    public void dataIndividual(FrameEvent frameEvent) {
        this.dispatchAndRespond(frameEvent);
    }

    public void disconnected(Destination destination) {
        destination.destroy();
        ((KnxDeviceServiceLogic)this.mgmtSvc).destinationDisconnected(destination);
    }

    public void group(FrameEvent frameEvent) {
    }

    public void detached(DetachEvent detachEvent) {
    }

    public void linkClosed(CloseEvent closeEvent) {
        this.logger.info("attached link was closed");
    }

    public ServiceResult dispatch(EventObject eventObject) {
        return new ServiceResult();
    }

    public void respond(EventObject eventObject, ServiceResult serviceResult) {
        FrameEvent frameEvent = (FrameEvent)eventObject;
        byte[] byArray = frameEvent.getFrame().getPayload();
        int n = DataUnitBuilder.getAPDUService((byte[])byArray);
        byte[] byArray2 = DataUnitBuilder.extractASDU((byte[])byArray);
        CEMILData cEMILData = (CEMILData)frameEvent.getFrame();
        IndividualAddress individualAddress = cEMILData.getSource();
        KNXAddress kNXAddress = cEMILData.getDestination();
        if (byArray.length - 1 > this.getMaxApduLength()) {
            this.logger.error("discard {}->{} {}: exceeds max. allowed APDU length of {}", new Object[]{individualAddress, kNXAddress, DataUnitBuilder.decode((byte[])byArray, (KNXAddress)kNXAddress), this.getMaxApduLength()});
            return;
        }
        TransportLayerImpl transportLayerImpl = (TransportLayerImpl)this.tl;
        Destination destination = transportLayerImpl.getDestination(individualAddress);
        if (destination == null) {
            destination = transportLayerImpl.createDestination(individualAddress, false);
        }
        try {
            this.dispatchToService(n, byArray2, kNXAddress, destination);
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("failed to execute service {}->{} {}: {}", new Object[]{individualAddress, kNXAddress, DataUnitBuilder.decode((byte[])byArray, (KNXAddress)kNXAddress), DataUnitBuilder.toHex((byte[])byArray2, (String)" "), runtimeException});
        }
    }

    @Override
    public void close() {
        this.tl.detach();
    }

    private void dispatchAndRespond(FrameEvent frameEvent) {
        this.device.dispatch((EventObject)frameEvent, () -> this.dispatch((EventObject)frameEvent), this::respond);
    }

    private void dispatchToService(int n, byte[] byArray, KNXAddress kNXAddress, Destination destination) {
        this.logger.trace(DataUnitBuilder.decodeAPCI((int)n));
        if (n == 512) {
            this.onMemoryRead(destination, byArray);
        } else if (n == 640) {
            this.onMemoryWrite(destination, byArray);
        } else if (n == 984) {
            this.onPropDescRead(destination, byArray);
        } else if (n == 981) {
            this.onPropertyRead(destination, byArray);
        } else if (n == 983) {
            this.onPropertyWrite(destination, byArray);
        } else if (n == 768) {
            this.onDeviceDescRead(destination, byArray);
        } else if (n == 384) {
            this.onAdcRead(destination, byArray);
        } else if (n == 977) {
            this.onAuthorize(destination, byArray);
        } else if (n == 256) {
            this.onIndAddrRead(destination, byArray);
        } else if (n == 192) {
            this.onIndAddrWrite(destination, byArray);
        } else if (n == 988) {
            this.onIndAddrSnRead(destination, byArray);
        } else if (n == 990) {
            this.onIndAddrSnWrite(destination, byArray);
        } else if (n == 993) {
            this.onDoARead(destination, byArray);
        } else if (n == 995) {
            this.onDoASelectiveRead(destination, byArray);
        } else if (n == 992) {
            this.onDoAWrite(destination, byArray);
        } else if (n == 979) {
            this.onKeyWrite(destination, byArray);
        } else if (n == 896) {
            this.onRestart(destination, byArray);
        } else {
            this.onManagement(n, byArray, kNXAddress, destination);
        }
    }

    private void onRestart(Destination destination, byte[] byArray) {
        int n;
        int n2;
        if (!this.verifyLength(byArray.length, 1, 3, "restart")) {
            return;
        }
        int n3 = byArray[0] & 0x1E;
        if (n3 != 0) {
            return;
        }
        boolean bl = (byArray[0] & 1) == 1;
        ServiceResult serviceResult = this.mgmtSvc.restart(bl, n2 = bl ? byArray[1] & 0xFF : 0, n = bl ? byArray[2] & 0xFF : 0);
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        byte[] byArray2 = serviceResult.getResult();
        byte[] byArray3 = new byte[]{33, byArray2[0], byArray2[1], byArray2[2]};
        byte[] byArray4 = DataUnitBuilder.createLengthOptimizedAPDU((int)896, (byte[])byArray3);
        this.send(destination, byArray4, serviceResult.getPriority(), DataUnitBuilder.decodeAPCI((int)896));
    }

    private void onKeyWrite(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 5, 5, "key write (access level)")) {
            return;
        }
        if (!destination.isConnectionOriented()) {
            return;
        }
        int n = byArray[0] & 0xFF;
        byte[] byArray2 = Arrays.copyOfRange(byArray, 1, 5);
        ServiceResult serviceResult = this.mgmtSvc.writeAuthKey(destination, n, byArray2);
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        this.send(destination, 980, serviceResult.getResult(), serviceResult.getPriority());
    }

    private void onIndAddrSnWrite(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 12, 12, "individual address SN write")) {
            return;
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 6);
        byte[] byArray3 = Arrays.copyOfRange(byArray, 6, 8);
        byte[] byArray4 = Arrays.copyOfRange(byArray, 8, 12);
        for (int i = 0; i < byArray4.length; ++i) {
            byte by = byArray4[i];
            if (by == 0) continue;
            this.logger.warn("byte " + (16 + i) + " not 0 (reserved area)");
        }
        IndividualAddress individualAddress = new IndividualAddress(byArray3);
        this.mgmtSvc.writeAddressSerial(byArray2, individualAddress);
    }

    private void onIndAddrSnRead(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 6, 6, "individual address SN read")) {
            return;
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 6);
        ServiceResult serviceResult = this.mgmtSvc.readAddressSerial(byArray2);
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        byte[] byArray3 = new byte[10];
        for (int i = 0; i < byArray2.length; ++i) {
            byte by;
            byArray3[i] = by = byArray2[i];
        }
        byte[] byArray4 = DataUnitBuilder.createAPDU((int)989, (byte[])byArray3);
        this.sendBroadcast(false, byArray4, Priority.SYSTEM, DataUnitBuilder.decodeAPCI((int)989));
    }

    private void onIndAddrWrite(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 2, 2, "individual address write")) {
            return;
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 2);
        IndividualAddress individualAddress = new IndividualAddress(byArray2);
        this.mgmtSvc.writeAddress(individualAddress);
    }

    private void onIndAddrRead(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 1, 1, "individual address read")) {
            return;
        }
        ServiceResult serviceResult = this.mgmtSvc.readAddress();
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = DataUnitBuilder.createAPDU((int)320, (byte[])byArray2);
        this.sendBroadcast(false, byArray3, Priority.SYSTEM, DataUnitBuilder.decodeAPCI((int)320));
    }

    private void onDoARead(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 0, 0, "domain address read")) {
            return;
        }
        ServiceResult serviceResult = this.mgmtSvc.readDomainAddress();
        this.sendDoAresponse(destination, serviceResult);
    }

    private void onDoASelectiveRead(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 5, 14, "domain address selective read")) {
            return;
        }
        if (byArray[0] == 0 && byArray.length == 5) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 2);
            IndividualAddress individualAddress = new IndividualAddress(Arrays.copyOfRange(byArray, 2, 4));
            int n = byArray[4] & 0xFF;
            ServiceResult serviceResult = this.mgmtSvc.readDomainAddress(byArray2, individualAddress, n);
            this.sendDoAresponse(destination, serviceResult);
        } else if (byArray[0] == 1 && byArray.length == 14) {
            byte[] byArray3 = Arrays.copyOfRange(byArray, 1, 7);
            byte[] byArray4 = Arrays.copyOfRange(byArray, 7, 13);
            ServiceResult serviceResult = this.mgmtSvc.readDomainAddress(byArray3, byArray4);
            this.sendDoAresponse(destination, serviceResult);
        }
    }

    private void sendDoAresponse(Destination destination, ServiceResult serviceResult) {
        byte[] byArray;
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        byte[] byArray2 = serviceResult.getResult();
        if (byArray2.length != this.lengthDoA) {
            this.logger.error("length of domain address is {} bytes, should be {} - ignore", (Object)byArray2.length, (Object)this.lengthDoA);
            return;
        }
        if (this.lengthDoA == 2) {
            byArray = byArray2;
        } else if (this.lengthDoA == 6) {
            byArray = new byte[]{1, byArray2[0], byArray2[1], byArray2[2], byArray2[3], byArray2[4], byArray2[5]};
        } else {
            return;
        }
        this.send(destination, 994, byArray, serviceResult.getPriority());
    }

    private void onDoAWrite(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, this.lengthDoA, this.lengthDoA, "domain address write")) {
            return;
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, this.lengthDoA);
        this.mgmtSvc.writeDomainAddress(byArray2);
    }

    private void onAuthorize(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 5, 5, "authorize request")) {
            return;
        }
        if (destination.getState() != Destination.State.OpenIdle) {
            return;
        }
        int n = byArray[0] & 0xFF;
        if (n != 0) {
            this.logger.warn("first byte in authorize request not zero");
            return;
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 1, 5);
        ServiceResult serviceResult = this.mgmtSvc.authorize(destination, byArray2);
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        this.send(destination, 978, serviceResult.getResult(), serviceResult.getPriority());
    }

    private void onAdcRead(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 2, 2, "AD converter read")) {
            return;
        }
        int n = byArray[0] & 0x3F;
        int n2 = byArray[1] & 0xFF;
        ServiceResult serviceResult = this.mgmtSvc.readADC(n, n2);
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        byte[] byArray2 = serviceResult.getResult();
        byte[] byArray3 = DataUnitBuilder.createLengthOptimizedAPDU((int)448, (byte[])byArray2);
        this.send(destination, byArray3, serviceResult.getPriority(), DataUnitBuilder.decodeAPCI((int)448));
    }

    private void onDeviceDescRead(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 1, 1, "device descriptor read")) {
            return;
        }
        int n = byArray[0] & 0xFF;
        if (n != 0 && n != 2) {
            this.logger.warn("device descriptor read: unsupported type " + n);
            return;
        }
        ServiceResult serviceResult = this.mgmtSvc.readDescriptor(n);
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        byte[] byArray2 = serviceResult.getResult();
        byte[] byArray3 = DataUnitBuilder.createAPDU((int)832, (byte[])byArray2);
        byArray3[1] = (byte)(byArray3[1] | n);
        this.send(destination, byArray3, serviceResult.getPriority(), DataUnitBuilder.decodeAPCI((int)832));
    }

    private void onPropertyRead(Destination destination, byte[] byArray) {
        ServiceResult serviceResult;
        if (!this.verifyLength(byArray.length, 4, 4, "property-read")) {
            return;
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = (byArray[2] & 0xFF) >> 4;
        int n4 = (byArray[2] & 0xF) << 8 | byArray[3] & 0xFF;
        try {
            serviceResult = this.mgmtSvc.readProperty(destination, n, n2, n4, n3);
            if (serviceResult == null) {
                serviceResult = ServiceResult.Empty;
            }
            if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
                return;
            }
        }
        catch (KNXIllegalArgumentException | KnxPropertyException throwable) {
            this.logger.warn("{}", (Object)throwable.getMessage());
            serviceResult = ServiceResult.Empty;
        }
        byte[] byArray2 = serviceResult.getResult();
        byte[] byArray3 = new byte[4 + byArray2.length];
        if (byArray2.length == 0) {
            n3 = 0;
        }
        byArray3[0] = (byte)n;
        byArray3[1] = (byte)n2;
        byArray3[2] = (byte)(n3 << 4 | n4 >>> 8 & 0xF);
        byArray3[3] = (byte)n4;
        for (int i = 0; i < byArray2.length; ++i) {
            byArray3[i + 4] = byArray2[i];
        }
        this.send(destination, 982, byArray3, serviceResult.getPriority());
    }

    private void onPropertyWrite(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 5, this.getMaxApduLength() - 1, "property-write")) {
            return;
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = (byArray[2] & 0xFF) >> 4;
        int n4 = (byArray[2] & 0xF) << 8 | byArray[3] & 0xFF;
        byte[] byArray2 = Arrays.copyOfRange(byArray, 4, byArray.length);
        ServiceResult serviceResult = null;
        try {
            serviceResult = this.mgmtSvc.writeProperty(destination, n, n2, n4, n3, byArray2);
            if (serviceResult == null) {
                serviceResult = ServiceResult.Empty;
            }
            if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
                return;
            }
        }
        catch (KNXIllegalArgumentException | KnxPropertyException throwable) {
            this.logger.warn("{}", (Object)throwable.getMessage());
            serviceResult = ServiceResult.Empty;
        }
        byte[] byArray3 = serviceResult.getResult();
        int n5 = byArray3.length;
        if (byArray3.length != byArray2.length) {
            n3 = 0;
            n5 = 0;
        }
        byte[] byArray4 = new byte[4 + n5];
        byArray4[0] = (byte)n;
        byArray4[1] = (byte)n2;
        byArray4[2] = (byte)(n3 << 4 | n4 >>> 8 & 0xF);
        byArray4[3] = (byte)n4;
        for (int i = 0; i < n5; ++i) {
            byArray4[4 + i] = byArray3[i];
        }
        this.send(destination, 982, byArray4, serviceResult.getPriority());
    }

    private void onPropDescRead(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 3, 3, "property description read")) {
            return;
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        ServiceResult serviceResult = null;
        try {
            serviceResult = this.mgmtSvc.readPropertyDescription(n, n2, n3);
        }
        catch (KNXIllegalArgumentException | KnxPropertyException throwable) {
            this.logger.warn("read property description: {}", (Object)throwable.getMessage());
        }
        if (serviceResult == null) {
            byte[] byArray2 = new byte[7];
            byArray2[0] = (byte)n;
            byArray2[1] = (byte)n2;
            byArray2[2] = (byte)n3;
            this.send(destination, 985, byArray2, Priority.LOW);
            return;
        }
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        Description description = new Description(0, serviceResult.getResult());
        n2 = description.getPID();
        int n4 = description.getPropIndex();
        int n5 = description.isWriteEnabled() ? 128 : 0;
        int n6 = description.getMaxElements();
        int n7 = description.getReadLevel() << 4 | description.getWriteLevel();
        byte[] byArray3 = new byte[]{(byte)n, (byte)n2, (byte)n4, (byte)(n5 |= description.getPDT()), (byte)(n6 >>> 8), (byte)n6, (byte)n7};
        this.send(destination, 985, byArray3, serviceResult.getPriority());
    }

    private void onMemoryWrite(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 4, 66, "memory-write")) {
            return;
        }
        int n = byArray[0];
        int n2 = (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
        if (n > this.getMaxApduLength() - 3) {
            this.logger.error("memory-write of length {} > max. {} bytes - ignore", (Object)n, (Object)(this.getMaxApduLength() - 3));
            return;
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 3, byArray.length);
        if (byArray2.length != n) {
            this.logger.warn("ill-formed memory write: number field = {} but memory length = {}", (Object)n, (Object)byArray2);
        } else {
            this.logger.trace("write memory: start address 0x{}, {} bytes: {}", new Object[]{Integer.toHexString(n2), n, DataUnitBuilder.toHex((byte[])byArray2, (String)" ")});
            ServiceResult serviceResult = this.mgmtSvc.writeMemory(n2, byArray2);
            if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
                return;
            }
            byte[] byArray3 = serviceResult.getResult();
            if (byArray3.length == 0) {
                n = 0;
            } else if (byArray3.length != n) {
                this.logger.warn("wrong implementation of memory-write?");
                n = 0;
            }
            boolean bl = this.mgmtSvc.isVerifyModeEnabled();
            if (bl) {
                byte[] byArray4 = new byte[3 + n];
                byArray4[0] = (byte)n;
                byArray4[1] = (byte)(n2 >>> 8);
                byArray4[2] = (byte)n2;
                for (int i = 0; i < n; ++i) {
                    byArray4[3 + i] = byArray3[i];
                }
                this.send(destination, 576, byArray4, serviceResult.getPriority());
            }
        }
    }

    private void onMemoryRead(Destination destination, byte[] byArray) {
        if (!this.verifyLength(byArray.length, 3, 3, "memory-read")) {
            return;
        }
        int n = byArray[0];
        int n2 = (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
        if (n > this.getMaxApduLength() - 3) {
            this.logger.warn("memory-read request of length {} > max. {} bytes - ignored", (Object)n, (Object)(this.getMaxApduLength() - 3));
            return;
        }
        this.logger.trace("read memory: start address 0x{}, {} bytes", (Object)Integer.toHexString(n2), (Object)n);
        ServiceResult serviceResult = this.mgmtSvc.readMemory(n2, n);
        if (ManagementServiceNotifier.ignoreOrSchedule(serviceResult)) {
            return;
        }
        byte[] byArray2 = serviceResult.getResult();
        int n3 = n;
        if (byArray2 == null || byArray2.length != n3) {
            n3 = 0;
        }
        byte[] byArray3 = new byte[3 + n3];
        byArray3[0] = (byte)n3;
        byArray3[1] = (byte)(n2 >> 8);
        byArray3[2] = (byte)n2;
        if (byArray2 != null) {
            for (int i = 0; i < n3; ++i) {
                byArray3[3 + i] = byArray2[i];
            }
        }
        byte[] byArray4 = DataUnitBuilder.createLengthOptimizedAPDU((int)576, (byte[])byArray3);
        this.send(destination, byArray4, serviceResult.getPriority(), DataUnitBuilder.decodeAPCI((int)576));
    }

    private void onManagement(int n, byte[] byArray, KNXAddress kNXAddress, Destination destination) {
        ServiceResult serviceResult = this.mgmtSvc.management(n, byArray, kNXAddress, destination, this.tl);
        if (serviceResult != null) {
            serviceResult.run();
        }
    }

    private boolean verifyLength(int n, int n2, int n3, String string) {
        if (n < n2) {
            this.logger.error(string + " SDU of length " + n + " too short, expected " + n2);
        } else if (n > n3) {
            this.logger.error(string + " SDU of length " + n + " too long, maximum " + n3);
        }
        return n >= n2 && n <= n3;
    }

    private static boolean ignoreOrSchedule(ServiceResult serviceResult) {
        if (serviceResult == null) {
            return true;
        }
        if (serviceResult.getResult() != null) {
            return false;
        }
        serviceResult.run();
        return true;
    }

    private void sendBroadcast(boolean bl, byte[] byArray, Priority priority, String string) {
        String string2 = bl ? "system" : "domain";
        this.logger.trace("{}->[{} broadcast] {} {}", new Object[]{this.device.getAddress(), string2, string, DataUnitBuilder.toHex((byte[])byArray, (String)" ")});
        try {
            this.tl.broadcast(bl, priority, byArray);
        }
        catch (KNXTimeoutException | KNXLinkClosedException throwable) {
            this.logger.error("{}->[{} broadcast] {} {}: {}", new Object[]{this.device.getAddress(), string2, string, DataUnitBuilder.toHex((byte[])byArray, (String)" "), throwable.getMessage()});
        }
    }

    private void send(Destination destination, int n, byte[] byArray, Priority priority) {
        byte[] byArray2 = DataUnitBuilder.createAPDU((int)n, (byte[])byArray);
        this.send(destination, byArray2, priority, DataUnitBuilder.decodeAPCI((int)n));
    }

    private void send(Destination destination, byte[] byArray, Priority priority, String string) {
        if (destination.getState() == Destination.State.Destroyed) {
            this.logger.warn("cannot respond with {}, {}", (Object)string, (Object)destination);
            return;
        }
        IndividualAddress individualAddress = destination.getAddress();
        this.logger.trace("{}->{} {} {}", new Object[]{this.device.getAddress(), individualAddress, string, DataUnitBuilder.toHex((byte[])byArray, (String)" ")});
        try {
            if (destination.isConnectionOriented()) {
                this.tl.sendData(destination, priority, byArray);
            } else {
                this.tl.sendData((KNXAddress)individualAddress, priority, byArray);
            }
        }
        catch (KNXTimeoutException | KNXLinkClosedException | KNXDisconnectException throwable) {
            this.logger.error("{}->{} {} {}: {}, {}", new Object[]{this.device.getAddress(), individualAddress, string, DataUnitBuilder.toHex((byte[])byArray, (String)" "), throwable.getMessage(), destination});
        }
    }

    private int getMaxApduLength() {
        try {
            byte[] byArray = this.device.getInterfaceObjectServer().getProperty(0, 56, 1, 1);
            return ManagementServiceNotifier.toUnsigned(byArray);
        }
        catch (KnxPropertyException knxPropertyException) {
            if (!this.missingApduLength) {
                this.missingApduLength = true;
                this.logger.error("device has no maximum APDU length set (PID.MAX_APDULENGTH), using 15");
            }
            return 15;
        }
    }

    private static int toUnsigned(byte[] byArray) {
        if (byArray.length == 2) {
            return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        }
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }
}

