/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator2ByteFloat;
import tuwien.auto.calimero.dptxlator.DPTXlator3BitControlled;
import tuwien.auto.calimero.dptxlator.DPTXlator4ByteFloat;
import tuwien.auto.calimero.dptxlator.DPTXlator8BitUnsigned;
import tuwien.auto.calimero.dptxlator.DPTXlatorBoolean;
import tuwien.auto.calimero.dptxlator.DPTXlatorString;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.process.ProcessCommunicationBase;
import tuwien.auto.calimero.process.ProcessListener;

public class ProcessCommunicationResponder
implements ProcessCommunicationBase {
    private static final int GROUP_RESPONSE = 64;
    private final KNXNetworkLink lnk;
    private final EventListeners<ProcessListener> listeners;
    private volatile Priority priority = Priority.LOW;
    private volatile boolean detached;
    private final Logger logger;

    public ProcessCommunicationResponder(KNXNetworkLink kNXNetworkLink) throws KNXLinkClosedException {
        if (!kNXNetworkLink.isOpen()) {
            throw new KNXLinkClosedException("cannot initialize process communication using closed link " + kNXNetworkLink.getName());
        }
        this.lnk = kNXNetworkLink;
        this.logger = LogService.getLogger((String)("calimero.device.communication " + kNXNetworkLink.getName()));
        this.listeners = new EventListeners(this.logger);
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void addProcessListener(ProcessListener processListener) {
        this.listeners.add((Object)processListener);
    }

    public void removeProcessListener(ProcessListener processListener) {
        this.listeners.remove((Object)processListener);
    }

    public void write(GroupAddress groupAddress, boolean bl) throws KNXTimeoutException, KNXLinkClosedException {
        try {
            DPTXlatorBoolean dPTXlatorBoolean = new DPTXlatorBoolean(DPTXlatorBoolean.DPT_BOOL);
            dPTXlatorBoolean.setValue(bl);
            this.write(groupAddress, this.priority, (DPTXlator)dPTXlatorBoolean);
        }
        catch (KNXFormatException kNXFormatException) {
            // empty catch block
        }
    }

    public void write(GroupAddress groupAddress, int n, String string) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        DPTXlator8BitUnsigned dPTXlator8BitUnsigned = new DPTXlator8BitUnsigned(string);
        dPTXlator8BitUnsigned.setValue(n);
        this.write(groupAddress, this.priority, (DPTXlator)dPTXlator8BitUnsigned);
    }

    public void write(GroupAddress groupAddress, boolean bl, int n) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        DPTXlator3BitControlled dPTXlator3BitControlled = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);
        dPTXlator3BitControlled.setValue(bl, n);
        this.write(groupAddress, this.priority, (DPTXlator)dPTXlator3BitControlled);
    }

    public void write(GroupAddress groupAddress, double d, boolean bl) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        if (bl) {
            DPTXlator4ByteFloat dPTXlator4ByteFloat = new DPTXlator4ByteFloat(DPTXlator4ByteFloat.DPT_TEMPERATURE_DIFFERENCE);
            dPTXlator4ByteFloat.setValue((float)d);
            this.write(groupAddress, this.priority, (DPTXlator)dPTXlator4ByteFloat);
        } else {
            DPTXlator2ByteFloat dPTXlator2ByteFloat = new DPTXlator2ByteFloat(DPTXlator2ByteFloat.DPT_RAIN_AMOUNT);
            dPTXlator2ByteFloat.setValue(d);
            this.write(groupAddress, this.priority, (DPTXlator)dPTXlator2ByteFloat);
        }
    }

    public void write(GroupAddress groupAddress, String string) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        DPTXlatorString dPTXlatorString = new DPTXlatorString(DPTXlatorString.DPT_STRING_8859_1);
        dPTXlatorString.setValue(string);
        this.write(groupAddress, this.priority, (DPTXlator)dPTXlatorString);
    }

    public void write(GroupAddress groupAddress, byte[] byArray, boolean bl) throws KNXTimeoutException, KNXLinkClosedException {
        if (this.detached) {
            throw new IllegalStateException("process communicator detached");
        }
        byte[] byArray2 = bl ? DataUnitBuilder.createLengthOptimizedAPDU((int)64, (byte[])byArray) : DataUnitBuilder.createAPDU((int)64, (byte[])byArray);
        this.lnk.sendRequest((KNXAddress)groupAddress, this.priority, byArray2);
    }

    public void write(GroupAddress groupAddress, DPTXlator dPTXlator) throws KNXException {
        this.write(groupAddress, this.priority, dPTXlator);
    }

    public void write(Datapoint datapoint, String string) throws KNXException {
        DPTXlator dPTXlator = TranslatorTypes.createTranslator((int)datapoint.getMainNumber(), (String)datapoint.getDPT());
        dPTXlator.setValue(string);
        this.write(datapoint.getMainAddress(), datapoint.getPriority(), dPTXlator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KNXNetworkLink detach() {
        ProcessCommunicationResponder processCommunicationResponder = this;
        synchronized (processCommunicationResponder) {
            if (this.detached) {
                return null;
            }
            this.detached = true;
        }
        this.fireDetached();
        this.logger.info("detached from " + this.lnk.getName());
        return this.lnk;
    }

    private void write(GroupAddress groupAddress, Priority priority, DPTXlator dPTXlator) throws KNXTimeoutException, KNXLinkClosedException {
        if (this.detached) {
            throw new IllegalStateException("process communicator detached");
        }
        this.lnk.sendRequest((KNXAddress)groupAddress, priority, ProcessCommunicationResponder.createGroupAPDU(64, dPTXlator));
    }

    private void fireDetached() {
        DetachEvent detachEvent = new DetachEvent((Object)this);
        this.listeners.fire(processListener -> processListener.detached(detachEvent));
    }

    private static byte[] createGroupAPDU(int n, DPTXlator dPTXlator) {
        if (n == 0) {
            return new byte[2];
        }
        if (n != 64 && n != 128) {
            throw new KNXIllegalArgumentException("not an APDU group service");
        }
        int n2 = dPTXlator.getItems() == 1 && dPTXlator.getTypeSize() == 0 ? 1 : 2;
        byte[] byArray = new byte[dPTXlator.getItems() * Math.max(1, dPTXlator.getTypeSize()) + n2];
        byArray[0] = (byte)(n >> 8);
        byArray[1] = (byte)n;
        return dPTXlator.getData(byArray, n2);
    }
}

