/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.util.EventObject;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.device.BaseKnxDevice;
import tuwien.auto.calimero.device.ProcessCommunicationResponder;
import tuwien.auto.calimero.device.ProcessCommunicationService;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.process.ProcessCommunicator;
import tuwien.auto.calimero.process.ProcessCommunicatorImpl;
import tuwien.auto.calimero.process.ProcessEvent;
import tuwien.auto.calimero.process.ProcessListener;

final class ProcessServiceNotifier
implements ProcessListener,
AutoCloseable {
    private static final int GROUP_READ = 0;
    private static final int GROUP_RESPONSE = 64;
    private static final int GROUP_WRITE = 128;
    private final BaseKnxDevice device;
    private final ProcessCommunicationService svc;
    private final ProcessCommunicator recv;
    private final ProcessCommunicationResponder res;

    ProcessServiceNotifier(BaseKnxDevice baseKnxDevice, ProcessCommunicationService processCommunicationService) throws KNXLinkClosedException {
        if (baseKnxDevice.getDeviceLink() == null) {
            throw new NullPointerException("KNX device network link is required");
        }
        this.device = baseKnxDevice;
        this.svc = processCommunicationService;
        this.recv = new ProcessCommunicatorImpl(baseKnxDevice.getDeviceLink());
        this.recv.addProcessListener((ProcessListener)this);
        this.res = new ProcessCommunicationResponder(baseKnxDevice.getDeviceLink());
    }

    public void groupReadRequest(ProcessEvent processEvent) {
        this.device.dispatch((EventObject)processEvent, () -> this.dispatch((EventObject)processEvent), this::respond);
    }

    public void groupReadResponse(ProcessEvent processEvent) {
        this.device.dispatch((EventObject)processEvent, () -> this.dispatch((EventObject)processEvent), this::respond);
    }

    public void groupWrite(ProcessEvent processEvent) {
        this.device.dispatch((EventObject)processEvent, () -> this.dispatch((EventObject)processEvent), this::respond);
    }

    public void detached(DetachEvent detachEvent) {
    }

    public ServiceResult dispatch(EventObject eventObject) {
        ProcessEvent processEvent = (ProcessEvent)eventObject;
        int n = processEvent.getServiceCode();
        if (n == 0) {
            return this.svc.groupReadRequest(processEvent);
        }
        if (n == 128) {
            this.svc.groupWrite(processEvent);
        } else if (n == 64) {
            this.svc.groupResponse(processEvent);
        } else {
            throw new KNXIllegalArgumentException("no KNX process service of type " + n);
        }
        return null;
    }

    public void respond(EventObject eventObject, ServiceResult serviceResult) {
        GroupAddress groupAddress = ((ProcessEvent)eventObject).getDestination();
        if (serviceResult.getResult() != null) {
            try {
                this.res.setPriority(serviceResult.getPriority());
                this.res.write(groupAddress, serviceResult.getResult(), serviceResult.compact);
            }
            catch (KNXTimeoutException | KNXLinkClosedException throwable) {
                this.device.logger().error("responding to {}: {}", new Object[]{groupAddress, DataUnitBuilder.toHex((byte[])serviceResult.getResult(), (String)" "), throwable});
            }
        } else {
            serviceResult.run();
        }
    }

    @Override
    public void close() {
        this.recv.close();
        this.res.close();
    }
}

