/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device.ios;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.PropertyClient;

public class InterfaceObject {
    public static final int DEVICE_OBJECT = 0;
    public static final int ADDRESSTABLE_OBJECT = 1;
    public static final int ASSOCIATIONTABLE_OBJECT = 2;
    public static final int APPLICATIONPROGRAM_OBJECT = 3;
    public static final int INTERFACEPROGRAM_OBJECT = 4;
    public static final int ROUTER_OBJECT = 6;
    public static final int LTE_ADDRESS_FILTER_TABLE_OBJECT = 7;
    public static final int CEMI_SERVER_OBJECT = 8;
    public static final int GROUP_OBJECT_TABLE_OBJECT = 9;
    public static final int POLLING_MASTER = 10;
    public static final int KNXNETIP_PARAMETER_OBJECT = 11;
    public static final int APPLICATION_CONTROLLER = 12;
    public static final int FILE_SERVER_OBJECT = 13;
    public static final int SECURITY_OBJECT = 17;
    public static final int RF_MEDIUM_OBJECT = 19;
    List<Description> descriptions = new ArrayList<Description>();
    Map<PropertyClient.PropertyKey, byte[]> values = new HashMap<PropertyClient.PropertyKey, byte[]>();
    private final int type;
    private volatile int idx;

    public InterfaceObject(int n) {
        this.type = n;
    }

    InterfaceObject(int n, int n2) {
        this(n);
        this.setIndex(n2);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return PropertyClient.getObjectTypeName((int)this.type);
    }

    public int getIndex() {
        return this.idx;
    }

    void load(InterfaceObjectServer.IosResourceHandler iosResourceHandler, String string) throws KNXException {
        ArrayList<Description> arrayList = new ArrayList<Description>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        iosResourceHandler.loadProperties(string, arrayList, arrayList2);
        Iterator iterator = arrayList2.iterator();
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext() && iterator.hasNext()) {
            Description description = (Description)iterator2.next();
            byte[] byArray = (byte[])iterator.next();
            this.setDescription(description);
            this.values.put(new PropertyClient.PropertyKey(description.getObjectType(), description.getPID()), byArray);
        }
    }

    void save(InterfaceObjectServer.IosResourceHandler iosResourceHandler, String string) throws KNXException {
        ArrayList<Description> arrayList = new ArrayList<Description>(this.descriptions);
        arrayList.removeAll(Arrays.asList(new Object[]{null}));
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        HashMap<PropertyClient.PropertyKey, byte[]> hashMap = new HashMap<PropertyClient.PropertyKey, byte[]>(this.values);
        byte[] byArray = new byte[]{};
        for (Description description : arrayList) {
            PropertyClient.PropertyKey propertyKey = new PropertyClient.PropertyKey(description.getObjectType(), description.getPID());
            byte[] byArray2 = this.values.get(propertyKey);
            if (byArray2 == null) {
                arrayList2.add(byArray);
                continue;
            }
            hashMap.remove(propertyKey);
            arrayList2.add((byte[])byArray2.clone());
        }
        for (Description description : hashMap.keySet()) {
            arrayList.add(new Description(this.idx, this.type, description.getPID(), arrayList2.size(), 0, true, 0, 0, 0, 0));
            arrayList2.add((byte[])((byte[])hashMap.get(description)).clone());
        }
        iosResourceHandler.saveProperties(string, arrayList, arrayList2);
    }

    public String toString() {
        return PropertyClient.getObjectTypeName((int)this.type) + " (index " + this.idx + ")";
    }

    void setDescription(Description description) {
        int n = description.getPropIndex();
        while (n >= this.descriptions.size()) {
            this.descriptions.add(null);
        }
        this.descriptions.set(n, description);
        this.truncateValueArray(description.getPID(), description.getMaxElements());
    }

    void setIndex(int n) {
        this.idx = n;
    }

    void truncateValueArray(int n, int n2) {
        PropertyClient.PropertyKey propertyKey = new PropertyClient.PropertyKey(this.getType(), n);
        byte[] byArray = this.values.get(propertyKey);
        if (byArray != null) {
            if (n2 == 0) {
                this.values.put(propertyKey, null);
                return;
            }
            int n3 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            if (n3 > n2) {
                int n4 = (byArray.length - 2) / n3;
                byte[] byArray2 = new byte[2 + n2 * n4];
                System.arraycopy(byArray, 2, byArray2, 2, byArray2.length - 2);
                byArray2[0] = (byte)(n2 >> 8);
                byArray2[1] = (byte)n2;
                this.values.put(propertyKey, byArray2);
            }
        }
    }
}

