/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device.ios;

import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.Settings;
import tuwien.auto.calimero.device.ios.InterfaceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServerListener;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.device.ios.PropertyEvent;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.PropertyTypes;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.PropertyAccess;
import tuwien.auto.calimero.mgmt.PropertyAdapter;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlInputFactory;
import tuwien.auto.calimero.xml.XmlOutputFactory;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlWriter;

public class InterfaceObjectServer
implements PropertyAccess {
    private final Logger logger = LogService.getLogger((String)"calimero.device.Interface Object Server");
    private IosResourceHandler rh;
    private final List<InterfaceObject> objects = new ArrayList<InterfaceObject>();
    private final IosAdapter adapter = new IosAdapter();
    private final PropertyClient client;
    private final boolean strictMode;
    private final EventListeners<InterfaceObjectServerListener> listeners = new EventListeners(this.logger);

    public InterfaceObjectServer(boolean bl) {
        this.strictMode = bl;
        try {
            this.client = new PropertyClient((PropertyAdapter)this.adapter);
        }
        catch (KNXFormatException kNXFormatException) {
            throw new KNXIllegalArgumentException("cannot create property client", (Throwable)kNXFormatException);
        }
        try {
            URL uRL = this.getClass().getResource("/properties.xml");
            if (uRL != null) {
                this.loadDefinitions(uRL.toString());
            }
        }
        catch (KNXException | KNXMLException throwable) {
            this.logger.info("could not load the Interface Object Server KNX property definitions");
        }
        this.addInterfaceObject(0);
        this.addInterfaceObject(8);
    }

    public synchronized void setResourceHandler(IosResourceHandler iosResourceHandler) {
        this.rh = iosResourceHandler;
    }

    public void loadDefinitions(String string) throws KNXException {
        PropertyClient.XmlPropertyDefinitions xmlPropertyDefinitions = new PropertyClient.XmlPropertyDefinitions();
        this.client.addDefinitions(xmlPropertyDefinitions.load(string));
    }

    public Map<PropertyClient.PropertyKey, PropertyClient.Property> propertyDefinitions() {
        return this.client.getDefinitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInterfaceObjects(String string) throws KNXException {
        IosResourceHandler iosResourceHandler;
        Object object = this;
        synchronized (object) {
            if (this.rh == null) {
                this.setResourceHandler(new XmlSerializer(this.logger));
            }
            iosResourceHandler = this.rh;
        }
        object = iosResourceHandler.loadInterfaceObjects(string);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            InterfaceObject interfaceObject = (InterfaceObject)iterator.next();
            List<InterfaceObject> list = this.objects;
            synchronized (list) {
                int n = this.objects.size();
                interfaceObject.setIndex(n);
                this.objects.add(interfaceObject);
            }
            this.initIoProperties(interfaceObject, false);
        }
        this.updateIoList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInterfaceObjects(String string) throws KNXException {
        InterfaceObject[] interfaceObjectArray = this;
        synchronized (this) {
            if (this.rh == null) {
                this.setResourceHandler(new XmlSerializer(this.logger));
            }
            IosResourceHandler iosResourceHandler = this.rh;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            interfaceObjectArray = this.getInterfaceObjects();
            iosResourceHandler.saveInterfaceObjects(string, Arrays.asList(interfaceObjectArray));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceObject[] getInterfaceObjects() {
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            return this.objects.toArray(new InterfaceObject[this.objects.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterfaceObject(int n) {
        InterfaceObject interfaceObject;
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            int n2 = this.objects.size();
            interfaceObject = new InterfaceObject(n, n2);
            this.objects.add(interfaceObject);
            this.updateIoList();
        }
        this.initIoProperties(interfaceObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterfaceObject(InterfaceObject interfaceObject) {
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            this.objects.remove(interfaceObject);
        }
    }

    public void addServerListener(InterfaceObjectServerListener interfaceObjectServerListener) {
        this.listeners.add((Object)interfaceObjectServerListener);
    }

    public void removeServerListener(InterfaceObjectServerListener interfaceObjectServerListener) {
        this.listeners.remove((Object)interfaceObjectServerListener);
    }

    public byte[] getProperty(int n, int n2, int n3, int n4) throws KnxPropertyException {
        return this.adapter.getProperty(n, n2, n3, n4);
    }

    public void setProperty(int n, int n2, int n3, int n4, byte ... byArray) throws KnxPropertyException {
        this.adapter.setProperty(n, n2, n3, n4, byArray);
    }

    public void setProperty(int n, int n2, int n3, int n4, int n5, byte ... byArray) throws KnxPropertyException {
        this.adapter.setProperty(n, n2, n3, n4, n5, byArray);
    }

    public byte[] getProperty(int n, int n2, int n3, int n4, int n5) throws KnxPropertyException {
        return this.adapter.getProperty(n, n2, n3, n4, n5);
    }

    public void setProperty(int n, int n2, int n3, String string) throws KNXException {
        try {
            this.client.setProperty(n, n2, n3, string);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("IOS adapter does not throw InterruptedException", interruptedException);
        }
    }

    public DPTXlator getPropertyTranslated(int n, int n2, int n3, int n4) throws KNXException {
        try {
            return this.client.getPropertyTranslated(n, n2, n3, n4);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("IOS adapter does not throw InterruptedException", interruptedException);
        }
    }

    public void setDescription(Description description, boolean bl) {
        int n;
        Description description2;
        int n2;
        int n3;
        int n4;
        InterfaceObject interfaceObject;
        boolean bl2;
        block17: {
            bl2 = false;
            interfaceObject = this.getIfObject(description.getObjectIndex());
            n4 = interfaceObject.getType();
            if (description.getObjectType() != n4) {
                if (!bl) {
                    throw new KNXIllegalArgumentException("interface object type differs");
                }
                bl2 = true;
            }
            n3 = 0;
            n2 = 0;
            try {
                description2 = this.getDescription(description.getObjectIndex(), description.getPID());
                n = n3 = description2.getPropIndex();
                n2 = description2.getPDT();
            }
            catch (KnxPropertyException knxPropertyException) {
                n = interfaceObject.descriptions.indexOf(null);
                if (n != -1) break block17;
                n = interfaceObject.descriptions.size();
            }
        }
        if (description.getPID() == 1) {
            if (description.getPropIndex() != 0) {
                if (!bl) {
                    throw new KNXIllegalArgumentException("property 'object type' (PID 1) only allowed at index 0");
                }
                bl2 = true;
                n = 0;
            }
        } else if (description.getPropIndex() == 0) {
            if (!bl) {
                throw new KNXIllegalArgumentException("only property 'object type' (PID 1) allowed at index 0");
            }
            bl2 = true;
        } else {
            n = description.getPropIndex();
        }
        if (description.getMaxElements() < description.getCurrentElements() && !bl) {
            throw new KNXIllegalArgumentException("maximum elements less than current elements");
        }
        if (description.getPDT() == 0 && bl) {
            if (n2 == 0 && (description2 = this.getDefinition(n4, description.getPID())) != null) {
                n2 = description2.getPDT();
            }
            if (n2 != 0) {
                bl2 = true;
            }
        } else {
            n2 = description.getPDT();
        }
        if (n3 != 0) {
            interfaceObject.descriptions.set(n3, null);
        }
        description2 = bl2 ? new Description(description.getObjectIndex(), n4, description.getPID(), n, n2, description.isWriteEnabled(), description.getCurrentElements(), description.getMaxElements(), description.getReadLevel(), description.getWriteLevel()) : description;
        interfaceObject.setDescription(description2);
    }

    public Description getDescription(int n, int n2) throws KnxPropertyException {
        try {
            return this.client.getDescription(n, n2);
        }
        catch (KNXException kNXException) {
            KnxPropertyException knxPropertyException = new KnxPropertyException(kNXException.getMessage());
            knxPropertyException.setStackTrace(kNXException.getStackTrace());
            throw knxPropertyException;
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("IOS adapter does not throw InterruptedException", interruptedException);
        }
    }

    public Description getDescriptionByIndex(int n, int n2) throws KnxPropertyException {
        try {
            return this.client.getDescriptionByIndex(n, n2);
        }
        catch (KNXException kNXException) {
            KnxPropertyException knxPropertyException = new KnxPropertyException(kNXException.getMessage());
            knxPropertyException.setStackTrace(kNXException.getStackTrace());
            throw knxPropertyException;
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("IOS adapter does not throw InterruptedException", interruptedException);
        }
    }

    private void updateIoList() {
        InterfaceObject interfaceObject = this.objects.get(0);
        if (interfaceObject == null || interfaceObject.getType() != 0) {
            throw new IllegalStateException("IOS is missing mandatory device object");
        }
        int n = this.objects.size();
        int[] nArray = new int[n];
        int n2 = 0;
        Object object = this.objects.iterator();
        while (object.hasNext()) {
            nArray[n2++] = object.next().getType();
        }
        Arrays.sort(nArray);
        object = new byte[(n + 1) * 2];
        object[0] = (byte)(n >> 8);
        object[1] = (byte)n;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            object[2 + 2 * i] = (byte)(n3 >> 8);
            object[2 + 2 * i + 1] = (byte)n3;
        }
        this.objects.get((int)0).values.put(new PropertyClient.PropertyKey(0, 71), (byte[])object);
    }

    void initIoProperties(InterfaceObject interfaceObject, boolean bl) {
        int n = interfaceObject.getType();
        int n2 = interfaceObject.getIndex();
        interfaceObject.values.put(new PropertyClient.PropertyKey(n, 1), new byte[]{0, 1, (byte)(n >> 8), (byte)n});
        if (bl) {
            this.adapter.createNewDescription(n2, 1, false);
        }
        byte[] byArray = interfaceObject.getTypeName().getBytes(Charset.forName("ISO-8859-1"));
        byte[] byArray2 = ByteBuffer.allocate(2 + byArray.length).put((byte)0).put((byte)byArray.length).put(byArray).array();
        interfaceObject.values.put(new PropertyClient.PropertyKey(n, 2), byArray2);
        if (bl) {
            this.adapter.createNewDescription(n2, 2, false);
        }
        interfaceObject.values.put(new PropertyClient.PropertyKey(n, 29), new byte[]{0, 1, (byte)(n2 >> 8), (byte)n2});
        if (bl) {
            this.adapter.createNewDescription(n2, 29, false);
        }
    }

    private void firePropertyChanged(InterfaceObject interfaceObject, int n, int n2, int n3, byte[] byArray) {
        PropertyEvent propertyEvent = new PropertyEvent(this, interfaceObject, n, n2, n3, byArray);
        this.listeners.fire(interfaceObjectServerListener -> interfaceObjectServerListener.onPropertyValueChanged(propertyEvent));
    }

    private PropertyClient.Property getDefinition(int n, int n2) {
        Map map = this.client.getDefinitions();
        PropertyClient.Property property = (PropertyClient.Property)map.get(new PropertyClient.PropertyKey(n, n2));
        if (property == null && n2 < 50) {
            property = (PropertyClient.Property)map.get(new PropertyClient.PropertyKey(n2));
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterfaceObject getIfObject(int n) {
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            for (InterfaceObject interfaceObject : this.objects) {
                if (interfaceObject.getIndex() != n) continue;
                return interfaceObject;
            }
        }
        throw new KNXIllegalArgumentException("interface object index " + n + " past last interface object");
    }

    private InterfaceObject findByObjectType(int n, int n2) throws KnxPropertyException {
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            int n3 = 0;
            for (InterfaceObject interfaceObject : this.objects) {
                if (interfaceObject.getType() != n || ++n3 != n2) continue;
                return interfaceObject;
            }
            throw new KnxPropertyException("no object instance " + n2 + " of " + PropertyClient.getObjectTypeName((int)n) + " in IOS");
        }
    }

    private static int toInt(byte[] byArray) {
        if (byArray.length == 1) {
            return byArray[0] & 0xFF;
        }
        if (byArray.length == 2) {
            return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        }
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private static class XmlSerializer
    implements IosResourceHandler {
        private static final String TAG_IOS = "interfaceObjects";
        private static final String TAG_OBJECT = "object";
        private static final String ATTR_OBJECTTYPE = "type";
        private static final String TAG_PROPERTY = "property";
        private static final String ATTR_PID = "pid";
        private static final String ATTR_INDEX = "index";
        private static final String ATTR_PDT = "pdt";
        private static final String ATTR_RW = "rw";
        private static final String ATTR_WRITE = "writeEnabled";
        private static final String ATTR_ELEMS = "elements";
        private static final String ATTR_MAXELEMS = "maxElements";
        private static final String TAG_DATA = "data";
        private XmlReader r;
        private XmlWriter w;
        private final Logger logger;

        XmlSerializer(Logger logger) {
            this.logger = logger;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<InterfaceObject> loadInterfaceObjects(String string) throws KNXException {
            ArrayList<InterfaceObject> arrayList = new ArrayList<InterfaceObject>();
            try (XmlReader xmlReader = XmlInputFactory.newInstance().createXMLReader(string);){
                this.r = xmlReader;
                if (xmlReader.nextTag() != 1) throw new KNXMLException("no interface objects");
                if (!this.r.getLocalName().equals(TAG_IOS)) {
                    throw new KNXMLException("no interface objects");
                }
                while (this.r.next() != 8) {
                    if (this.r.getEventType() == 1) {
                        if (!this.r.getLocalName().equals(TAG_OBJECT)) continue;
                        int n = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_OBJECTTYPE));
                        int n2 = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_INDEX));
                        InterfaceObject interfaceObject = new InterfaceObject(n, n2);
                        arrayList.add(interfaceObject);
                        interfaceObject.load(this, string);
                        continue;
                    }
                    if (this.r.getEventType() != 2 || !this.r.getLocalName().equals(TAG_IOS)) continue;
                }
                ArrayList<InterfaceObject> arrayList2 = arrayList;
                return arrayList2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new KNXFormatException("loading interface objects", numberFormatException.getMessage());
            }
        }

        @Override
        public void saveInterfaceObjects(String string, Collection<InterfaceObject> collection) throws KNXException {
            try (XmlWriter xmlWriter = XmlOutputFactory.newInstance().createXMLWriter(string);){
                this.w = xmlWriter;
                xmlWriter.writeStartDocument("UTF-8", "1.0");
                this.w.writeComment("Calimero v" + Settings.getLibraryVersion() + " interface objects, saved on " + ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
                this.w.writeStartElement(TAG_IOS);
                for (InterfaceObject interfaceObject : collection) {
                    this.w.writeStartElement(TAG_OBJECT);
                    this.w.writeAttribute(ATTR_OBJECTTYPE, Integer.toString(interfaceObject.getType()));
                    this.w.writeAttribute(ATTR_INDEX, Integer.toString(interfaceObject.getIndex()));
                    interfaceObject.save(this, string);
                    this.w.writeEndElement();
                }
                this.w.writeEndDocument();
            }
        }

        @Override
        public void loadProperties(String string, Collection<Description> collection, Collection<byte[]> collection2) throws KNXException {
            try {
                int n = 0;
                int n2 = 0;
                if (this.r.getLocalName().equals(TAG_OBJECT)) {
                    n = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_OBJECTTYPE));
                    n2 = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_INDEX));
                }
                boolean bl = false;
                byte[] byArray = new byte[]{};
                while (this.r.next() != 8) {
                    if (this.r.getEventType() == 1) {
                        int n3;
                        if (this.r.getLocalName().equals(TAG_PROPERTY)) {
                            int n4 = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_INDEX));
                            n3 = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_ELEMS));
                            int n5 = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_MAXELEMS));
                            int[] nArray = XmlSerializer.parseRW(this.r.getAttributeValue(null, ATTR_RW));
                            Description description = new Description(n2, n, XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_PID)), n4, XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_PDT)), XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_WRITE)) == 1, n3, n5, nArray[0], nArray[1]);
                            collection.add(description);
                            if (bl) {
                                collection2.add(byArray);
                            }
                            bl = true;
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace(description.toString());
                            continue;
                        }
                        if (!this.r.getLocalName().equals(TAG_DATA)) continue;
                        String string2 = this.r.getElementText();
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace(string2);
                        }
                        n3 = string2.length() % 2;
                        byte[] byArray2 = new byte[string2.length() / 2 + n3];
                        if (n3 == 1) {
                            byArray2[0] = Byte.parseByte(string2.substring(0, 1), 16);
                        }
                        for (int i = 1; i < byArray2.length; ++i) {
                            byArray2[i] = Byte.parseByte(string2.substring(i * 2 - n3, i * 2 + 2 - n3), 16);
                        }
                        collection2.add(byArray2);
                        bl = false;
                        continue;
                    }
                    if (this.r.getEventType() != 2 || !this.r.getLocalName().equals(TAG_OBJECT)) continue;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new KNXFormatException("loading properties", numberFormatException.getMessage());
            }
        }

        @Override
        public void saveProperties(String string, Collection<Description> collection, Collection<byte[]> collection2) {
            if (collection2.size() < collection.size()) {
                throw new KNXIllegalArgumentException("values size " + collection2.size() + " less than descriptions size " + collection.size());
            }
            Iterator<byte[]> iterator = collection2.iterator();
            for (Description description : collection) {
                byte[] byArray = iterator.next();
                this.w.writeStartElement(TAG_PROPERTY);
                this.w.writeAttribute(ATTR_INDEX, Integer.toString(description.getPropIndex()));
                this.w.writeAttribute(ATTR_PID, Integer.toString(description.getPID()));
                this.w.writeAttribute(ATTR_PDT, description.getPDT() == -1 ? "<tbd>" : Integer.toString(description.getPDT()));
                this.w.writeAttribute(ATTR_ELEMS, Integer.toString(description.getCurrentElements()));
                this.w.writeAttribute(ATTR_MAXELEMS, Integer.toString(description.getMaxElements()));
                this.w.writeAttribute(ATTR_RW, Integer.toString(description.getReadLevel()) + "/" + description.getWriteLevel());
                this.w.writeAttribute(ATTR_WRITE, description.isWriteEnabled() ? "1" : "0");
                this.w.writeStartElement(TAG_DATA);
                this.w.writeCharacters(DataUnitBuilder.toHex((byte[])byArray, (String)""));
                this.w.writeEndElement();
                this.w.writeEndElement();
            }
            while (iterator.hasNext()) {
                Object object = iterator.next();
                this.w.writeStartElement(TAG_PROPERTY);
                this.w.writeStartElement(TAG_DATA);
                this.w.writeCharacters(DataUnitBuilder.toHex((byte[])object, (String)""));
                this.w.writeEndElement();
                this.w.writeEndElement();
            }
        }

        private static int[] parseRW(String string) {
            String string2 = string.toLowerCase();
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '/') {
                    bl = true;
                    continue;
                }
                if (c < '0' || c > '9') continue;
                if (bl) {
                    n2 = n2 * 10 + c - 48;
                    continue;
                }
                n = n * 10 + c - 48;
            }
            return new int[]{n, n2};
        }

        private static int toInt(String string) throws NumberFormatException {
            if (string != null) {
                if (string.equals("<tbd>")) {
                    return -1;
                }
                return string.length() == 0 ? 0 : Integer.decode(string);
            }
            throw new NumberFormatException("no integer number: " + string);
        }
    }

    public static interface IosResourceHandler {
        public Collection<InterfaceObject> loadInterfaceObjects(String var1) throws KNXException;

        public void saveInterfaceObjects(String var1, Collection<InterfaceObject> var2) throws KNXException;

        public void loadProperties(String var1, Collection<Description> var2, Collection<byte[]> var3) throws KNXException;

        public void saveProperties(String var1, Collection<Description> var2, Collection<byte[]> var3) throws KNXException;
    }

    private final class IosAdapter
    implements PropertyAdapter {
        private IosAdapter() {
        }

        public void setProperty(int n, int n2, int n3, int n4, byte ... byArray) throws KnxPropertyException {
            this.setProperty(InterfaceObjectServer.this.getIfObject(n), n2, n3, n4, byArray);
        }

        public void setProperty(int n, int n2, int n3, int n4, int n5, byte ... byArray) throws KnxPropertyException {
            this.setProperty(InterfaceObjectServer.this.findByObjectType(n, n2), n3, n4, n5, byArray);
        }

        public byte[] getProperty(int n, int n2, int n3, int n4) throws KnxPropertyException {
            return this.getProperty(InterfaceObjectServer.this.getIfObject(n), n2, n3, n4);
        }

        public byte[] getProperty(int n, int n2, int n3, int n4, int n5) throws KnxPropertyException {
            return this.getProperty(InterfaceObjectServer.this.findByObjectType(n, n2), n3, n4, n5);
        }

        public byte[] getDescription(int n, int n2, int n3) throws KnxPropertyException {
            InterfaceObject interfaceObject = InterfaceObjectServer.this.getIfObject(n);
            Description description = null;
            if (n2 != 0) {
                description = this.findByPid(interfaceObject.descriptions, n2);
            } else if (n3 < interfaceObject.descriptions.size()) {
                description = interfaceObject.descriptions.get(n3);
            }
            if (description != null) {
                int n4 = 0;
                try {
                    n4 = InterfaceObjectServer.toInt(this.getProperty(n, n2, 0, 1));
                }
                catch (KnxPropertyException knxPropertyException) {
                    // empty catch block
                }
                return new Description(n, description.getObjectType(), description.getPID(), description.getPropIndex(), description.getPDT(), description.isWriteEnabled(), n4, description.getMaxElements(), description.getReadLevel(), description.getWriteLevel()).toByteArray();
            }
            throw new KnxPropertyException("no description found for " + PropertyClient.getObjectTypeName((int)interfaceObject.getType()) + " (" + interfaceObject.getType() + ")" + (n2 != 0 ? " PID " + n2 : " property index " + n3));
        }

        public String getName() {
            return "Calimero IOS adapter";
        }

        public boolean isOpen() {
            return true;
        }

        public void close() {
        }

        private void setProperty(InterfaceObject interfaceObject, int n, int n2, int n3, byte[] byArray) throws KnxPropertyException {
            int n4;
            boolean bl;
            Description description;
            String string;
            int n5;
            int n6;
            byte[] byArray2;
            PropertyClient.PropertyKey propertyKey;
            block23: {
                propertyKey = new PropertyClient.PropertyKey(interfaceObject.getType(), n);
                byArray2 = interfaceObject.values.get(propertyKey);
                if (n2 == 0) {
                    if (n3 == 1 && byArray.length == 2 && byArray[0] == 0 && byArray[1] == 0) {
                        interfaceObject.truncateValueArray(n, 0);
                        return;
                    }
                    throw new KnxPropertyException("set current number of elements", 5);
                }
                n6 = 0;
                n5 = 0;
                string = null;
                description = null;
                bl = false;
                try {
                    description = new Description(interfaceObject.getType(), this.getDescription(interfaceObject, n, 0));
                    n5 = description.getPDT();
                }
                catch (KnxPropertyException knxPropertyException) {
                    if (InterfaceObjectServer.this.strictMode) {
                        throw new KnxPropertyException("strict mode: no description found for " + interfaceObject.getTypeName() + " PID " + n);
                    }
                    bl = true;
                    PropertyClient.Property property = InterfaceObjectServer.this.getDefinition(interfaceObject.getType(), n);
                    if (property == null) break block23;
                    n5 = property.getPDT();
                    string = property.getDPT();
                }
            }
            if (n5 != 0) {
                try {
                    n6 = PropertyTypes.createTranslator((int)n5).getTypeSize();
                    if (n6 == 0) {
                        n6 = 1;
                    }
                }
                catch (KNXException kNXException) {
                    // empty catch block
                }
            }
            if (n6 == 0 && string != null) {
                try {
                    n6 = TranslatorTypes.createTranslator((int)0, (String)string).getTypeSize();
                    if (n6 == 0) {
                        n6 = 1;
                    }
                }
                catch (KNXException kNXException) {
                    // empty catch block
                }
            }
            if (n6 == 0) {
                n6 = byArray.length / n3;
            } else if (n6 != byArray.length / n3) {
                throw new KnxPropertyException("property type size is " + n6 + ", not " + byArray.length / n3, 8);
            }
            int n7 = n2 + n3 - 1;
            if (byArray2 == null || n7 > (byArray2.length - 2) / n6) {
                int n8;
                int n9 = n8 = description == null ? 100 : description.getMaxElements();
                if (n7 > n8) {
                    throw new KnxPropertyException("property values index range [" + n2 + "..." + n7 + "] exceeds " + n8 + " maximum elements", 9);
                }
                byte[] byArray3 = new byte[2 + n7 * n6];
                byArray3[0] = (byte)(n7 >> 8);
                byArray3[1] = (byte)n7;
                if (byArray2 != null) {
                    for (n4 = 2; n4 < byArray2.length; ++n4) {
                        byArray3[n4] = byArray2[n4];
                    }
                }
                interfaceObject.values.put(propertyKey, byArray3);
                byArray2 = byArray3;
            }
            int n10 = 0;
            boolean bl2 = false;
            for (n4 = 2 + (n2 - 1) * n6; n4 < 2 + n7 * n6; ++n4) {
                bl2 |= byArray2[n4] != byArray[n10];
                byArray2[n4] = byArray[n10++];
            }
            if (bl) {
                Description description2 = this.createNewDescription(interfaceObject.getIndex(), n, true);
                InterfaceObjectServer.this.logger.trace("init description {}", (Object)description2);
            }
            if (bl2) {
                InterfaceObjectServer.this.firePropertyChanged(interfaceObject, n, n2, n3, byArray);
            }
        }

        private byte[] getProperty(InterfaceObject interfaceObject, int n, int n2, int n3) throws KnxPropertyException {
            byte[] byArray = interfaceObject.values.get(new PropertyClient.PropertyKey(interfaceObject.getType(), n));
            if (n2 == 0) {
                if (n3 > 1) {
                    throw new KnxPropertyException("current number of elements consists of only 1 element", 0);
                }
                if (byArray != null) {
                    return new byte[]{byArray[0], byArray[1]};
                }
                if (this.findByPid(interfaceObject.descriptions, n) != null) {
                    return new byte[]{0, 0};
                }
            }
            if (byArray == null) {
                throw new KnxPropertyException("no property ID " + n + " in " + interfaceObject.getTypeName() + " (index " + interfaceObject.getIndex() + ")", 7);
            }
            int n4 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            int n5 = n2 + n3 - 1;
            if (n4 < n5) {
                throw new KnxPropertyException("requested elements exceed past last property value", 9);
            }
            int n6 = (byArray.length - 2) / n4;
            byte[] byArray2 = new byte[n3 * n6];
            int n7 = 0;
            for (int i = 2 + (n2 - 1) * n6; i < 2 + n5 * n6; ++i) {
                byArray2[n7++] = byArray[i];
            }
            return byArray2;
        }

        private byte[] getDescription(InterfaceObject interfaceObject, int n, int n2) throws KnxPropertyException {
            Description description = null;
            if (n != 0) {
                description = this.findByPid(interfaceObject.descriptions, n);
            } else if (n2 < interfaceObject.descriptions.size()) {
                description = interfaceObject.descriptions.get(n2);
            }
            if (description != null) {
                int n3 = 0;
                try {
                    n3 = InterfaceObjectServer.toInt(this.getProperty(interfaceObject, n, 0, 1));
                }
                catch (KnxPropertyException knxPropertyException) {
                    // empty catch block
                }
                return new Description(interfaceObject.getIndex(), description.getObjectType(), description.getPID(), description.getPropIndex(), description.getPDT(), description.isWriteEnabled(), n3, description.getMaxElements(), description.getReadLevel(), description.getWriteLevel()).toByteArray();
            }
            throw new KnxPropertyException("no description found for " + PropertyClient.getObjectTypeName((int)interfaceObject.getType()) + (n != 0 ? " PID " + n : " property index " + n2));
        }

        private Description createNewDescription(int n, int n2, boolean bl) {
            InterfaceObject interfaceObject = InterfaceObjectServer.this.getIfObject(n);
            int n3 = 0;
            PropertyClient.Property property = InterfaceObjectServer.this.getDefinition(interfaceObject.getType(), n2);
            if (property != null) {
                n3 = property.getPDT();
            }
            int n4 = interfaceObject.descriptions.size();
            int n5 = 0;
            try {
                n5 = InterfaceObjectServer.toInt(this.getProperty(n, n2, 0, 1));
            }
            catch (KnxPropertyException knxPropertyException) {
                // empty catch block
            }
            int n6 = Math.max(n5, 10);
            boolean bl2 = property != null ? !property.readOnly() : bl;
            int n7 = property != null ? property.readLevel() : 0;
            int n8 = property != null ? Math.max(0, property.writeLevel()) : 0;
            Description description = new Description(n, interfaceObject.getType(), n2, n4, n3, bl2, n5, n6, n7, n8);
            interfaceObject.descriptions.add(description);
            return description;
        }

        private Description findByPid(List<Description> list, int n) {
            for (Description description : list) {
                if (description == null || description.getPID() != n) continue;
                return description;
            }
            return null;
        }
    }
}

