/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.Settings;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.device.DeviceSecureApplicationLayer;
import tuwien.auto.calimero.device.KnxDevice;
import tuwien.auto.calimero.device.KnxDeviceServiceLogic;
import tuwien.auto.calimero.device.ManagementService;
import tuwien.auto.calimero.device.ManagementServiceNotifier;
import tuwien.auto.calimero.device.ProcessCommunicationService;
import tuwien.auto.calimero.device.ProcessServiceNotifier;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.device.ThreadSafeByteArray;
import tuwien.auto.calimero.device.ios.DeviceObject;
import tuwien.auto.calimero.device.ios.InterfaceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.device.ios.PropertyEvent;
import tuwien.auto.calimero.device.ios.SecurityObject;
import tuwien.auto.calimero.knxnetip.KNXnetIPRouting;
import tuwien.auto.calimero.knxnetip.servicetype.KNXnetIPHeader;
import tuwien.auto.calimero.knxnetip.servicetype.SearchResponse;
import tuwien.auto.calimero.knxnetip.util.DeviceDIB;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.knxnetip.util.ServiceFamiliesDIB;
import tuwien.auto.calimero.link.AbstractLink;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.KNXNetworkLinkUsb;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.mgmt.TransportLayerImpl;
import tuwien.auto.calimero.secure.SecureApplicationLayer;
import tuwien.auto.calimero.secure.SecurityControl;

public class BaseKnxDevice
implements KnxDevice,
AutoCloseable {
    private static final int objectInstance = 1;
    private static final int defMfrId = 0;
    private static final byte[] defMfrData = new byte[]{98, 109, 50, 48, 49, 49, 32, 32};
    private static final int pidHardwareType = 78;
    static final int INCOMING_EVENTS_THREADED = 1;
    static final int OUTGOING_EVENTS_THREADED = 2;
    int threadingPolicy = 2;
    private static final ThreadFactory factory = Executors.defaultThreadFactory();
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
        Thread t = factory.newThread(r);
        t.setName("Calimero Device Task (" + t.getName() + ")");
        t.setDaemon(true);
        return t;
    });
    private boolean taskSubmitted;
    private final List<Runnable> tasks = new ArrayList<Runnable>();
    private final String name;
    private final InterfaceObjectServer ios;
    private final Logger logger;
    private final URI iosResource;
    private final char[] iosPwd;
    private static final char[] NoPwd;
    TransportLayer tl;
    DeviceSecureApplicationLayer sal;
    private final ProcessCommunicationService process;
    private final ManagementService mgmt;
    private ProcessServiceNotifier procNotifier;
    ManagementServiceNotifier mgmtNotifier;
    private KNXNetworkLink link;
    private static final int deviceMemorySize = 65552;
    private final KnxDevice.Memory memory = new ThreadSafeByteArray(65552);
    private static final int SeqSize = 6;
    private static final AtomicLong taskCounter;

    public BaseKnxDevice(String name, DeviceDescriptor.DD0 dd, ProcessCommunicationService process, ManagementService mgmt, URI iosResource, char[] iosPassword) throws KnxPropertyException {
        this.name = name;
        this.ios = new InterfaceObjectServer(false);
        this.ios.addServerListener(this::propertyChanged);
        this.logger = LogService.getLogger((String)("calimero.device." + name));
        this.iosResource = iosResource;
        this.iosPwd = iosPassword;
        this.process = process;
        this.mgmt = mgmt;
        this.initIos(dd);
        this.loadDeviceMemory();
    }

    @Deprecated
    public BaseKnxDevice(String name, DeviceDescriptor.DD0 dd, IndividualAddress device, KNXNetworkLink link, ProcessCommunicationService process, ManagementService mgmt) throws KNXLinkClosedException, KnxPropertyException {
        this(name, dd, process, mgmt, null, NoPwd);
        this.setDeviceLink(link);
        this.setAddress(device);
    }

    BaseKnxDevice(String name, DeviceDescriptor.DD0 dd, KNXNetworkLink link, ProcessCommunicationService process, ManagementService mgmt) throws KNXLinkClosedException, KnxPropertyException {
        this(name, dd, process, mgmt, null, NoPwd);
        this.setDeviceLink(link);
    }

    public BaseKnxDevice(String name, KnxDeviceServiceLogic logic) throws KnxPropertyException {
        this(name, logic, null, NoPwd);
    }

    public BaseKnxDevice(String name, KnxDeviceServiceLogic logic, URI iosResource, char[] iosPassword) throws KnxPropertyException {
        this(name, DeviceDescriptor.DD0.TYPE_5705, logic, logic, iosResource, iosPassword);
        logic.setDevice(this);
    }

    public BaseKnxDevice(String name, KnxDeviceServiceLogic logic, KNXNetworkLink link) throws KNXLinkClosedException, KnxPropertyException {
        this(name, DeviceDescriptor.DD0.TYPE_5705, link, logic, logic);
    }

    protected final synchronized void setAddress(IndividualAddress address) {
        if (address == null) {
            throw new NullPointerException("device address cannot be null");
        }
        if (address.getRawAddress() == 0 || this.getAddress().equals((Object)address)) {
            return;
        }
        KNXNetworkLink link = this.getDeviceLink();
        if (link != null) {
            KNXMediumSettings settings = link.getKNXMedium();
            settings.setDeviceAddress(address);
        }
        DeviceObject.lookup(this.ios).setDeviceAddress(address);
        try {
            this.setIpProperty(52, address.toByteArray());
        }
        catch (KnxPropertyException knxPropertyException) {
            // empty catch block
        }
    }

    @Override
    public final synchronized IndividualAddress getAddress() {
        return DeviceObject.lookup(this.ios).deviceAddress();
    }

    @Override
    public final synchronized void setDeviceLink(KNXNetworkLink link) throws KNXLinkClosedException {
        this.link = link;
        if (link == null) {
            return;
        }
        KNXMediumSettings settings = link.getKNXMedium();
        DeviceObject deviceObject = DeviceObject.lookup(this.ios);
        deviceObject.set(56, BaseKnxDevice.fromWord(settings.maxApduLength()));
        int medium = settings.getMedium();
        this.ios.setProperty(8, 1, 51, 1, 1, 0, (byte)medium);
        if (medium == 32) {
            this.initKnxipProperties();
        } else if (medium == 16) {
            this.initRfProperties();
        }
        IndividualAddress address = settings.getDeviceAddress();
        if (address.getDevice() != 0) {
            this.setAddress(address);
        } else if (address.getRawAddress() == 0 && !(link instanceof KNXNetworkLinkUsb)) {
            settings.setDeviceAddress(this.getAddress());
        }
        if (this.process instanceof KnxDeviceServiceLogic) {
            ((KnxDeviceServiceLogic)this.process).setDevice(this);
        } else if (this.mgmt instanceof KnxDeviceServiceLogic) {
            ((KnxDeviceServiceLogic)this.mgmt).setDevice(this);
        }
        this.tl = new TransportLayerImpl(link, true);
        if (this.sal != null) {
            this.sal.close();
        }
        this.sal = new DeviceSecureApplicationLayer(this);
        this.ensureInitializedSeqNumber();
        this.resetNotifiers();
    }

    private void ensureInitializedSeqNumber() throws KNXLinkClosedException {
        SecurityObject secif = SecurityObject.lookup(this.getInterfaceObjectServer());
        if (!secif.isLoaded() || !this.sal.isSecurityModeEnabled()) {
            return;
        }
        if (BaseKnxDevice.unsigned(secif.get(59)) > 1L) {
            return;
        }
        secif.set(59, BaseKnxDevice.sixBytes(1L).array());
        ArrayList<CompletableFuture> requests = new ArrayList<CompletableFuture>();
        ByteBuffer table = ByteBuffer.wrap(secif.get(54));
        while (table.hasRemaining()) {
            IndividualAddress remote = new IndividualAddress(table.getShort() & 0xFFFF);
            table.get(new byte[6]);
            try {
                requests.add(this.sal.sendSyncRequest(remote, false));
                int maxRequests = 5;
                if (requests.size() < 5) continue;
                break;
            }
            catch (KNXTimeoutException kNXTimeoutException) {
            }
        }
        try {
            CompletableFuture success = new CompletableFuture();
            requests.forEach(r -> r.thenAccept(success::complete));
            success.orTimeout(6L, TimeUnit.SECONDS).join();
        }
        catch (RuntimeException e) {
            this.logger.warn("awaiting sync.res for initializing sequence number", e.getCause());
        }
    }

    @Override
    public final synchronized KNXNetworkLink getDeviceLink() {
        return this.link;
    }

    @Override
    public final InterfaceObjectServer getInterfaceObjectServer() {
        return this.ios;
    }

    @Override
    public KnxDevice.Memory deviceMemory() {
        return this.memory;
    }

    public ExecutorService taskExecutor() {
        return executor;
    }

    public final TransportLayer transportLayer() {
        return this.tl;
    }

    public final SecureApplicationLayer secureApplicationLayer() {
        return this.sal;
    }

    public final void addGroupObject(Datapoint dp, SecurityControl.DataSecurity security, boolean update) {
        int goSecurity = BaseKnxDevice.groupObjectSecurity(security);
        GroupAddress group = dp.getMainAddress();
        Optional<Integer> optGaIdx = KnxDeviceServiceLogic.groupAddressIndex(this.ios, group);
        if (optGaIdx.isPresent()) {
            int idx = optGaIdx.orElseThrow();
            long sec = BaseKnxDevice.unsigned(this.ios.getProperty(17, 1, 61, idx, 1));
            if (sec < (long)goSecurity) {
                this.ios.setProperty(17, 1, 61, idx, 1, (byte)goSecurity);
            }
        } else {
            int lastGaIdx = (int)BaseKnxDevice.unsigned(this.ios.getProperty(1, 1, 23, 0, 1));
            int newGaIdx = lastGaIdx + 1;
            this.ios.setProperty(1, 1, 23, newGaIdx, 1, group.toByteArray());
            this.ios.setProperty(17, 1, 61, newGaIdx, 1, (byte)goSecurity);
            byte[] table = this.ios.getProperty(2, 1, 23, 1, Integer.MAX_VALUE);
            ByteBuffer buffer = ByteBuffer.wrap(table);
            int maxGoIdx = 0;
            while (buffer.hasRemaining()) {
                buffer.getShort();
                maxGoIdx = Math.max(maxGoIdx, buffer.getShort() & 0xFFFF);
            }
            int newGoIdx = maxGoIdx + 1;
            int newAssocIdx = table.length / 4 + 1;
            byte[] assoc = ByteBuffer.allocate(4).putShort((short)newGaIdx).putShort((short)newGoIdx).array();
            this.ios.setProperty(2, 1, 23, newAssocIdx, 1, assoc);
            this.ios.setProperty(9, 1, 23, newGoIdx, 1, KnxDeviceServiceLogic.groupObjectDescriptor(dp.getDPT(), dp.getPriority(), false, update));
        }
    }

    public void identification(DeviceDescriptor.DD0 dd, int manufacturerId, SerialNumber serialNumber, byte[] hardwareType, byte[] programVersion, byte[] fdsk) {
        DeviceObject deviceObject = DeviceObject.lookup(this.ios);
        deviceObject.set(83, dd.toByteArray());
        ByteBuffer memAddr = ByteBuffer.allocate(4).putInt(dd == DeviceDescriptor.DD0.TYPE_0705 ? 16384 : 278);
        this.ios.setProperty(1, 7, 1, 1, memAddr.array());
        deviceObject.set(12, (byte)(manufacturerId >> 8), (byte)manufacturerId);
        deviceObject.set(11, serialNumber.array());
        deviceObject.set(78, hardwareType);
        this.ios.setProperty(3, 1, 13, 1, 1, programVersion);
        SecurityObject.lookup(this.ios).set(56, fdsk);
    }

    @Deprecated(forRemoval=true)
    public void identification(DeviceDescriptor.DD0 dd, int manufacturerId, byte[] serialNumber, byte[] hardwareType, byte[] programVersion, byte[] fdsk) {
        this.identification(dd, manufacturerId, SerialNumber.from((byte[])serialNumber), hardwareType, programVersion, fdsk);
    }

    private static ByteBuffer sixBytes(long num) {
        return ByteBuffer.allocate(6).putShort((short)(num >> 32)).putInt((int)num).flip();
    }

    private static int groupObjectSecurity(SecurityControl.DataSecurity security) {
        return security == SecurityControl.DataSecurity.AuthConf ? 3 : security.ordinal();
    }

    private static long unsigned(byte[] data) {
        long v = 0L;
        for (byte b : data) {
            v = (v << 8) + (long)(b & 0xFF);
        }
        return v;
    }

    @Override
    public void close() {
        if (this.sal != null) {
            this.sal.close();
        }
        this.saveIos();
        this.saveDeviceMemory();
    }

    private void saveIos() {
        if (this.iosResource == null || "".equals(this.iosResource.toString())) {
            return;
        }
        try {
            this.logger.debug("saving interface object server to {}", (Object)this.iosResource);
            if (this.iosPwd.length > 0) {
                this.saveEncryptedIos(this.iosPwd);
            } else {
                this.ios.saveInterfaceObjects(this.iosResource.toString());
            }
        }
        catch (IOException | RuntimeException | GeneralSecurityException | KNXException e) {
            this.logger.error("saving interface object server", e);
        }
    }

    private void saveEncryptedIos(char[] pwd) throws GeneralSecurityException, IOException, KNXException {
        OutputStream os = Files.newOutputStream(Path.of(this.iosResource), new OpenOption[0]);
        byte[] generatedSalt = new byte[16];
        Cipher cipher = BaseKnxDevice.iosCipher(pwd, generatedSalt, null);
        try (CipherOutputStream cos = new CipherOutputStream(os, cipher);){
            os.write(generatedSalt);
            os.write(cipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV());
            this.ios.saveInterfaceObjects(cos);
        }
    }

    private void loadEncryptedIos(char[] pwd) throws GeneralSecurityException, IOException, KNXException {
        InputStream is = Files.newInputStream(Path.of(this.iosResource), new OpenOption[0]);
        try (CipherInputStream cis = new CipherInputStream(is, BaseKnxDevice.iosCipher(pwd, is.readNBytes(16), is.readNBytes(16)));){
            this.ios.loadInterfaceObjects(cis);
        }
    }

    private static Cipher iosCipher(char[] pwd, byte[] salt, byte[] useIv) throws GeneralSecurityException {
        boolean encrypt;
        boolean bl = encrypt = useIv == null;
        if (encrypt) {
            new SecureRandom().nextBytes(salt);
        }
        PBEKeySpec spec = new PBEKeySpec(pwd, salt, 65536, 256);
        SecretKey tmp = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256").generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        if (encrypt) {
            cipher.init(1, secret);
        } else {
            cipher.init(2, (Key)secret, new IvParameterSpec(useIv));
        }
        return cipher;
    }

    public String toString() {
        return this.name + " " + this.getAddress();
    }

    <T> void dispatch(EventObject e, Supplier<ServiceResult<T>> dispatch, BiConsumer<EventObject, ServiceResult<T>> respond) {
        long start = System.nanoTime();
        long taskId = taskCounter.incrementAndGet();
        if (this.threadingPolicy == 1) {
            this.submitTask(taskId, () -> {
                try {
                    Optional.ofNullable((ServiceResult)dispatch.get()).ifPresent(sr -> respond.accept(e, (ServiceResult)sr));
                }
                catch (RuntimeException rte) {
                    this.logger.error("error executing dispatch/respond task {}", (Object)taskId, (Object)rte);
                }
                finally {
                    this.taskDone(taskId, start);
                }
            });
        } else {
            Optional.ofNullable(dispatch.get()).ifPresent(sr -> this.submitTask(taskId, () -> {
                try {
                    respond.accept(e, (ServiceResult)sr);
                }
                catch (RuntimeException rte) {
                    this.logger.error("error executing respond task {}", (Object)taskId, (Object)rte);
                }
                finally {
                    this.taskDone(taskId, start);
                }
            }));
        }
    }

    Logger logger() {
        return this.logger;
    }

    private void initIos(DeviceDescriptor.DD0 dd) {
        if (this.loadIosFromResource()) {
            return;
        }
        InterfaceObject addressTable = this.ios.addInterfaceObject(1);
        this.initTableProperties(addressTable, dd == DeviceDescriptor.DD0.TYPE_5705 ? 16384 : 278, dd);
        InterfaceObject assocTable = this.ios.addInterfaceObject(2);
        this.initTableProperties(assocTable, 4096, dd);
        InterfaceObject groupObjectTable = this.ios.addInterfaceObject(9);
        this.initTableProperties(groupObjectTable, 12288, dd);
        int pidGODiagnostics = 66;
        this.ios.setDescription(new Description(groupObjectTable.getIndex(), 0, 66, 62, 0, true, 0, 1, 3, 3), true);
        InterfaceObject appObject = this.ios.addInterfaceObject(3);
        this.initTableProperties(appObject, 16384, dd);
        this.ios.addInterfaceObject(4);
        this.ios.addInterfaceObject(8);
        this.ios.addInterfaceObject(17);
        this.initDeviceInfo(dd);
    }

    private boolean loadIosFromResource() {
        if (this.iosResource == null || "".equals(this.iosResource.toString())) {
            return false;
        }
        try {
            this.ios.removeInterfaceObject(this.ios.getInterfaceObjects()[0]);
            this.logger.debug("loading interface object server from {}", (Object)this.iosResource);
            if (this.iosPwd.length > 0 && Path.of(this.iosResource).toFile().exists()) {
                this.loadEncryptedIos(this.iosPwd);
            } else {
                this.ios.loadInterfaceObjects(this.iosResource.toString());
            }
            return true;
        }
        catch (UncheckedIOException e) {
            this.logger.info("could not open {}, create resource on closing device ({})", (Object)this.iosResource, (Object)e.getCause().getMessage());
            this.ios.addInterfaceObject(0);
            return false;
        }
        catch (IOException | GeneralSecurityException | KNXException e) {
            throw new KnxRuntimeException("loading interface object server", e);
        }
    }

    private void loadDeviceMemory() {
        this.memResource().filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).ifPresent(path -> {
            try {
                this.logger.debug("loading device memory from {}", path);
                byte[] bytes = Files.readAllBytes(path);
                if (bytes.length != this.memory.size()) {
                    this.logger.warn("loaded {} bytes from {}, available device memory is {} bytes", new Object[]{bytes.length, path, this.memory.size()});
                }
                this.memory.set(0, bytes);
            }
            catch (IOException | RuntimeException e) {
                this.logger.warn("loading device memory from {}", path, (Object)e);
            }
        });
    }

    private void saveDeviceMemory() {
        this.memResource().ifPresent(path -> {
            try {
                this.logger.debug("saving device memory to {}", path);
                Files.write(path, this.memory.get(0, this.memory.size()), new OpenOption[0]);
            }
            catch (IOException | RuntimeException e) {
                this.logger.warn("saving device memory to {}", path, (Object)e);
            }
        });
    }

    private Optional<Path> memResource() {
        if (this.iosResource == null || "".equals(this.iosResource.toString())) {
            return Optional.empty();
        }
        Path memResource = Path.of(URI.create(this.iosResource.toString().replace(".xml", ".mem")));
        return Optional.of(memResource);
    }

    private void initTableProperties(InterfaceObject io, int memAddress, DeviceDescriptor.DD0 dd0) {
        int idx = io.getIndex();
        this.ios.setProperty(idx, 5, 1, 1, (byte)KnxDeviceServiceLogic.LoadState.Loaded.ordinal());
        this.ios.setProperty(idx, 7, 1, 1, ByteBuffer.allocate(4).putInt(memAddress).array());
        boolean systemB = dd0.firmwareVersion() == 11;
        boolean bigAssocTable = dd0 == DeviceDescriptor.DD0.TYPE_0300 || systemB;
        int pdt = io.getType() == 2 && bigAssocTable ? 20 : 18;
        this.ios.setDescription(new Description(idx, 0, 23, 0, pdt, true, 0, 100, 3, 3), true);
        int elems = 4;
        this.ios.setProperty(idx, 27, 1, 4, new byte[32]);
    }

    private void initDeviceInfo(DeviceDescriptor.DD0 dd) throws KnxPropertyException {
        DeviceObject deviceObject = DeviceObject.lookup(this.ios);
        byte[] desc = this.name.getBytes(StandardCharsets.ISO_8859_1);
        this.ios.setProperty(0, 1, 21, 1, desc.length, desc);
        String[] sver = Settings.getLibraryVersion().split("\\.| |-", 0);
        int ver = Integer.parseInt(sver[0]) << 6 | Integer.parseInt(sver[1]);
        deviceObject.set(25, BaseKnxDevice.fromWord(ver));
        boolean firmwareRev = true;
        deviceObject.set(9, 1);
        byte[] sno = new byte[6];
        deviceObject.set(11, sno);
        deviceObject.set(54, 0);
        this.memory.set(96, 0);
        deviceObject.set(12, BaseKnxDevice.fromWord(0));
        this.ios.setProperty(0, 1, 19, 1, defMfrData.length / 4, defMfrData);
        byte[] hwType = new byte[6];
        deviceObject.set(78, hwType);
        deviceObject.set(83, dd.toByteArray());
        int maskVersion = dd.maskVersion();
        if ((maskVersion == 37 || maskVersion == 1797) && hwType[0] != 0) {
            this.logger.error("manufacturer-specific device identification of hardware type should be 0 for this mask!");
        }
        this.ios.setDescription(new Description(0, 0, 56, 0, 0, false, 0, 1, 3, 0), true);
        deviceObject.set(56, BaseKnxDevice.fromWord(254));
        deviceObject.setDeviceAddress(new IndividualAddress(767));
        byte[] orderInfo = new byte[10];
        deviceObject.set(15, orderInfo);
        boolean peiType = false;
        deviceObject.set(16, 0);
        int pidDownloadCounter = 30;
        deviceObject.set(30, 0, 0);
        this.ios.setProperty(8, 1, 51, 1, 1, 0, 2);
        boolean requiredPeiType = false;
        this.ios.setProperty(3, 1, 16, 1, 1, BaseKnxDevice.fromByte(0));
        int[] runStateEnum = new int[]{0, 1, 2, 3, 4, 5};
        int runState = runStateEnum[1];
        this.ios.setProperty(3, 1, 6, 1, 1, (byte)runState);
        byte[] applicationVersion = new byte[5];
        this.ios.setProperty(3, 1, 13, 1, 1, applicationVersion);
    }

    private void setIpProperty(int propertyId, byte ... data) {
        this.ios.setProperty(11, 1, propertyId, 1, 1, data);
    }

    private KNXnetIPRouting connectionOfLink() throws ReflectiveOperationException {
        KNXnetIPRouting conn = (KNXnetIPRouting)BaseKnxDevice.accessField(AbstractLink.class, "conn", this.link);
        if (conn == null) {
            throw new KnxRuntimeException("no KNX IP routing connection found in link " + this.link.getName(), null);
        }
        return conn;
    }

    private static <T, U> T accessField(Class<? extends U> clazz, String field, U obj) throws ReflectiveOperationException, SecurityException {
        Class<?> cl;
        for (cl = obj.getClass(); cl != null && !clazz.equals(cl); cl = cl.getSuperclass()) {
        }
        if (cl == null) {
            return null;
        }
        Field f = cl.getDeclaredField(field);
        f.setAccessible(true);
        return (T)f.get(obj);
    }

    private synchronized void resetNotifiers() throws KNXLinkClosedException {
        if (this.procNotifier != null) {
            this.procNotifier.close();
        }
        ProcessServiceNotifier processServiceNotifier = this.procNotifier = this.link != null && this.process != null ? new ProcessServiceNotifier(this, this.process) : null;
        if (this.mgmtNotifier != null) {
            this.mgmtNotifier.close();
        }
        this.mgmtNotifier = this.link != null && this.mgmt != null ? new ManagementServiceNotifier(this, this.mgmt) : null;
    }

    private void initKnxipProperties() {
        if (!this.lookup(11)) {
            this.ios.addInterfaceObject(11);
        }
        this.setIpProperty(51, BaseKnxDevice.fromWord(0));
        this.setIpProperty(52, this.getAddress().toByteArray());
        this.setIpProperty(54, 1);
        this.setIpProperty(55, 1);
        this.setIpProperty(56, 0);
        byte[] ip = new byte[4];
        byte[] mask = new byte[4];
        byte[] mac = new byte[6];
        byte[] mcast = new byte[4];
        try {
            KNXnetIPRouting conn = this.connectionOfLink();
            mcast = conn.getRemoteAddress().getAddress().getAddress();
            NetworkInterface netif = conn.networkInterface();
            Optional<Object> addr = Optional.empty();
            if (NetworkInterface.getByName(netif.getName()) != null) {
                List<InterfaceAddress> addresses = netif.getInterfaceAddresses();
                addr = addresses.stream().filter(a -> a.getAddress() instanceof Inet4Address).findFirst();
            } else {
                for (NetworkInterface nif : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                    try {
                        List<InterfaceAddress> addresses;
                        if (!nif.isUp() || !nif.supportsMulticast() || nif.isLoopback() || nif.isPointToPoint() || !(addr = (addresses = nif.getInterfaceAddresses()).stream().filter(a -> a.getAddress() instanceof Inet4Address).findFirst()).isPresent()) continue;
                        netif = nif;
                        break;
                    }
                    catch (SocketException socketException) {
                    }
                }
            }
            if (addr.isPresent()) {
                ip = ((InterfaceAddress)addr.get()).getAddress().getAddress();
                short prefixLength = ((InterfaceAddress)addr.get()).getNetworkPrefixLength();
                long defMask = 0xFFFFFFFFL;
                long intMask = 0xFFFFFFFFL ^ 0xFFFFFFFFL >> prefixLength;
                ByteBuffer.wrap(mask).putInt((int)intMask);
            }
            mac = Optional.ofNullable(netif.getHardwareAddress()).orElse(mac);
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(KNXnetIPRouting.class, MethodHandles.lookup());
            VarHandle callback = lookup.findVarHandle(KNXnetIPRouting.class, "searchRequestCallback", BiFunction.class);
            callback.setVolatile(conn, this::ipSearchRequest);
        }
        catch (IOException | ReflectiveOperationException | RuntimeException e) {
            this.logger.warn("initializing KNX IP properties, {}", (Object)e.toString());
        }
        this.setIpProperty(57, ip);
        this.setIpProperty(58, mask);
        byte[] gw = new byte[4];
        this.setIpProperty(59, gw);
        this.setIpProperty(60, ip);
        this.setIpProperty(61, mask);
        this.setIpProperty(62, gw);
        this.setIpProperty(64, mac);
        try {
            InetAddress defMcast = InetAddress.getByName("224.0.23.12");
            this.setIpProperty(65, defMcast.getAddress());
        }
        catch (UnknownHostException defMcast) {
            // empty catch block
        }
        this.setIpProperty(66, mcast);
        this.setIpProperty(67, 16);
        int deviceCaps = 4;
        this.setIpProperty(68, BaseKnxDevice.fromWord(4));
        this.setIpProperty(69, 0);
        this.setIpProperty(72, BaseKnxDevice.fromWord(0));
        this.setIpProperty(74, new byte[4]);
        byte[] data = Arrays.copyOf(this.name.getBytes(StandardCharsets.ISO_8859_1), 30);
        this.ios.setProperty(11, 1, 76, 1, data.length, data);
        this.setIpProperty(78, BaseKnxDevice.fromWord(100));
    }

    private void initRfProperties() {
        if (!this.lookup(19)) {
            this.ios.addInterfaceObject(19);
        }
    }

    private boolean lookup(int ioType) {
        boolean found = false;
        for (InterfaceObject io : this.ios.getInterfaceObjects()) {
            found |= io.getType() == ioType;
        }
        return found;
    }

    private SearchResponse ipSearchRequest(KNXnetIPHeader h, ByteBuffer data) {
        try {
            return this.searchResponse(h, data);
        }
        catch (IOException | KNXFormatException e) {
            throw new KnxRuntimeException("creating search response", e);
        }
    }

    private SearchResponse searchResponse(KNXnetIPHeader h, ByteBuffer data) throws KNXFormatException, IOException {
        int svc = h.getServiceType();
        if (svc != 513) {
            return null;
        }
        DeviceObject deviceObject = DeviceObject.lookup(this.ios);
        IndividualAddress deviceAddress = deviceObject.deviceAddress();
        boolean progmode = deviceObject.programmingMode();
        SerialNumber sno = deviceObject.serialNumber();
        InetAddress ip = InetAddress.getByAddress(this.ipProperty(57));
        InetAddress mcast = InetAddress.getByAddress(this.ipProperty(66));
        String deviceName = new String(this.ios.getProperty(11, 1, 76, 1, 29), StandardCharsets.ISO_8859_1);
        int projectInstId = (int)BaseKnxDevice.unsigned(this.ipProperty(51));
        byte[] mac = this.ipProperty(64);
        DeviceDIB deviceDib = new DeviceDIB(deviceName, progmode ? 1 : 0, projectInstId, 32, deviceAddress, sno, mcast, mac);
        ServiceFamiliesDIB svcFamilies = new ServiceFamiliesDIB(Map.of(ServiceFamiliesDIB.ServiceFamily.Core, 1));
        HPAI ctrlEndpoint = new HPAI(ip, 3671);
        return new SearchResponse(ctrlEndpoint, deviceDib, svcFamilies);
    }

    private byte[] ipProperty(int pid) {
        return this.ios.getProperty(11, 1, pid, 1, 1);
    }

    private void propertyChanged(PropertyEvent pe) {
        try {
            if (pe.getInterfaceObject().getType() == 11) {
                int pid = pe.getPropertyId();
                if (pid == 67) {
                    KNXnetIPRouting conn = this.connectionOfLink();
                    conn.setHopCount((int)pe.getNewData()[0]);
                } else if (pid == 52) {
                    this.setAddress(new IndividualAddress(pe.getNewData()));
                }
            }
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            this.logger.warn("updating {} PID {} with [{}]: {}", new Object[]{pe.getInterfaceObject(), pe.getPropertyId(), DataUnitBuilder.toHex((byte[])pe.getNewData(), (String)""), e.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitTask(long taskId, Runnable task) {
        List<Runnable> list = this.tasks;
        synchronized (list) {
            this.logger.trace("queue task " + taskId);
            if (this.taskSubmitted) {
                this.tasks.add(task);
            } else {
                this.taskSubmitted = true;
                this.taskExecutor().submit(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskDone(long taskId, long start) {
        long total = System.nanoTime() - start;
        long ms = total / 1000000L;
        if (ms > 5000L) {
            this.logger.warn("task {} took suspiciously long ({} ms)", (Object)taskId, (Object)ms);
        }
        List<Runnable> list = this.tasks;
        synchronized (list) {
            if (this.tasks.isEmpty()) {
                this.taskSubmitted = false;
            } else {
                this.taskExecutor().submit(this.tasks.remove(0));
            }
        }
    }

    private static byte[] fromWord(int word) {
        return new byte[]{(byte)(word >> 8), (byte)word};
    }

    private static byte[] fromByte(int uchar) {
        return new byte[]{(byte)uchar};
    }

    static {
        executor.allowCoreThreadTimeOut(true);
        NoPwd = new char[0];
        taskCounter = new AtomicLong();
    }
}

