/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.ReturnCode;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.cemi.CEMIDevMgmt;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.DatapointMap;
import tuwien.auto.calimero.datapoint.DatapointModel;
import tuwien.auto.calimero.datapoint.StateDP;
import tuwien.auto.calimero.device.BaseKnxDevice;
import tuwien.auto.calimero.device.DeviceSecureApplicationLayer;
import tuwien.auto.calimero.device.KnxDevice;
import tuwien.auto.calimero.device.ManagementService;
import tuwien.auto.calimero.device.ProcessCommunicationService;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.device.ios.DeviceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.PropertyTypes;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.PLSettings;
import tuwien.auto.calimero.link.medium.RFSettings;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.process.ProcessEvent;
import tuwien.auto.calimero.secure.SecurityControl;

public abstract class KnxDeviceServiceLogic
implements ProcessCommunicationService,
ManagementService {
    protected KnxDevice device;
    private InterfaceObjectServer ios;
    private Logger logger;
    private final DatapointModel<Datapoint> datapoints = new DatapointMap();
    private static byte[] defaultAuthKey = new byte[]{-1, -1, -1, -1};
    final byte[][] authKeys = new byte[16][4];
    final WeakHashMap<Destination, Integer> accessLevels = new WeakHashMap();
    int minAccessLevel = 3;
    private final Instant startTime = Instant.now();
    private boolean ignoreReadSNByPowerReset;
    private volatile boolean verifyMode;
    private static final int PID_ROUTETABLE_CONTROL = 56;
    private static final int addrGroupAddrTable = 278;
    private static final int addrGroupAddrTable5705 = 16384;

    public void setDevice(KnxDevice device) {
        this.device = device;
        this.ios = device.getInterfaceObjectServer();
        this.logger = device instanceof BaseKnxDevice ? ((BaseKnxDevice)device).logger() : LoggerFactory.getLogger(KnxDeviceServiceLogic.class);
        KNXNetworkLink link = device.getDeviceLink();
        if (link != null) {
            byte[] domainAddress;
            KNXMediumSettings settings = link.getKNXMedium();
            if (settings.getMedium() == 4) {
                byte[] domainAddress2 = ((PLSettings)settings).getDomainAddress();
                if (!Arrays.equals(domainAddress2, new byte[2]) || this.domainAddress().length == 0) {
                    this.setDomainAddress(domainAddress2);
                }
            } else if (!(settings.getMedium() != 16 || Arrays.equals(domainAddress = ((RFSettings)settings).getDomainAddress(), new byte[6]) && this.domainAddress().length != 0)) {
                this.setDomainAddress(domainAddress);
            }
        }
        this.resetAuthKeys(0);
        this.syncDatapoints();
    }

    public final DatapointModel<Datapoint> getDatapointModel() {
        return this.datapoints;
    }

    public abstract void updateDatapointValue(Datapoint var1, DPTXlator var2);

    public abstract DPTXlator requestDatapointValue(Datapoint var1) throws KNXException;

    public void setProgrammingMode(boolean inProgrammingMode) {
        try {
            byte state = (byte)(inProgrammingMode ? 1 : 0);
            this.ios.setProperty(0, 54, 1, 1, state);
        }
        catch (KnxPropertyException state) {
            // empty catch block
        }
        int b = this.device.deviceMemory().get(96);
        b = inProgrammingMode ? b | 1 : b & 0xFFFFFFFE;
        this.device.deviceMemory().set(96, b);
    }

    public final boolean inProgrammingMode() {
        try {
            return DeviceObject.lookup(this.ios).programmingMode();
        }
        catch (KnxPropertyException e) {
            return (this.device.deviceMemory().get(96) & 1) == 1;
        }
    }

    @Override
    public ServiceResult<byte[]> groupReadRequest(ProcessEvent e) {
        GroupAddress dst = e.getDestination();
        Datapoint dp = this.getDatapointModel().get(dst);
        if (dp != null) {
            try {
                DPTXlator t = this.requestDatapointValue(dp);
                if (t != null) {
                    return new ServiceResult<byte[]>(t.getData(), t.getTypeSize() == 0);
                }
            }
            catch (RuntimeException | KNXException ex) {
                this.logger.warn("on group read request {}->{}: {}", new Object[]{e.getSourceAddr(), dst, DataUnitBuilder.toHex((byte[])e.getASDU(), (String)" "), ex});
            }
        }
        return null;
    }

    @Override
    public void groupWrite(ProcessEvent e) {
        GroupAddress dst = e.getDestination();
        Datapoint dp = this.getDatapointModel().get(dst);
        if (dp == null) {
            return;
        }
        try {
            DPTXlator t = TranslatorTypes.createTranslator((int)0, (String)dp.getDPT());
            t.setData(e.getASDU());
            this.updateDatapointValue(dp, t);
        }
        catch (RuntimeException | KNXException ex) {
            this.logger.warn("on group write {}->{}: {}, {}", new Object[]{e.getSourceAddr(), dst, DataUnitBuilder.toHex((byte[])e.getASDU(), (String)" "), ex.getMessage()});
        }
    }

    @Override
    public void groupResponse(ProcessEvent e) {
    }

    @Override
    public ServiceResult<byte[]> readProperty(Destination remote, int objectIndex, int propertyId, int startIndex, int elements) {
        try {
            Description d = this.ios.getDescription(objectIndex, propertyId);
            if (d.getPDT() == 62) {
                return ServiceResult.error(ReturnCode.DataVoid);
            }
            Integer level = this.accessLevel(remote);
            if (level > d.getReadLevel()) {
                this.logger.warn("deny {} read access to property {}|{} (access level {}, requires {})", new Object[]{remote.getAddress(), objectIndex, propertyId, level, d.getReadLevel()});
                return ServiceResult.error(ReturnCode.AccessDenied);
            }
        }
        catch (KnxPropertyException d) {
            // empty catch block
        }
        byte[] res = this.ios.getProperty(objectIndex, propertyId, startIndex, elements);
        return ServiceResult.of(res);
    }

    @Override
    public ServiceResult<Void> writeProperty(Destination remote, int objectIndex, int propertyId, int startIndex, int elements, byte[] data) {
        Description d;
        block8: {
            d = null;
            try {
                d = this.ios.getDescription(objectIndex, propertyId);
            }
            catch (KnxPropertyException e) {
                int objType = this.ios.getInterfaceObjects()[objectIndex].getType();
                PropertyClient.Property p = this.ios.propertyDefinitions().get(new PropertyClient.PropertyKey(objType, propertyId));
                if (p == null) break block8;
                d = new Description(objectIndex, objType, propertyId, 0, p.getPDT(), !p.readOnly(), 0, 1, p.readLevel(), p.writeLevel());
            }
        }
        if (d != null && !this.inProgrammingMode()) {
            if (!d.isWriteEnabled()) {
                this.logger.warn("property {}|{} is {}", new Object[]{objectIndex, propertyId, CEMIDevMgmt.getErrorMessage((int)5)});
                return ServiceResult.error(ReturnCode.AccessReadOnly);
            }
            int level = this.accessLevel(remote);
            if (level > d.getWriteLevel()) {
                this.logger.warn("deny {} write access to property {}|{} (access level {}, requires {})", new Object[]{remote.getAddress(), objectIndex, propertyId, level, d.getWriteLevel()});
                return ServiceResult.error(ReturnCode.AccessDenied);
            }
        }
        if (propertyId == 5) {
            ServiceResult<byte[]> state = this.changeLoadState(remote, objectIndex, propertyId, startIndex, elements, data);
            return KnxDeviceServiceLogic.castResult(state);
        }
        this.ios.setProperty(objectIndex, propertyId, startIndex, elements, data);
        if (objectIndex == 0 && propertyId == 54) {
            this.setProgrammingMode((data[0] & 1) == 1);
        }
        if (objectIndex == 0 && propertyId == 14) {
            this.verifyMode = (data[0] & 4) != 0;
        }
        return ServiceResult.empty();
    }

    private static <T> ServiceResult<T> castResult(ServiceResult<byte[]> ls) {
        return ls;
    }

    private static LoadState nextLoadState(LoadEvent event) {
        switch (event) {
            case NoOperation: {
                return LoadState.Error;
            }
            case StartLoading: {
                return LoadState.Loading;
            }
            case LoadCompleted: {
                return LoadState.Loaded;
            }
            case AdditionalLoadControls: {
                return LoadState.Loading;
            }
            case Unload: {
                return LoadState.Unloaded;
            }
        }
        throw new IllegalStateException();
    }

    private ServiceResult<byte[]> changeLoadState(Destination remote, int objectIndex, int propertyId, int startIndex, int elements, byte[] data) {
        LoadEvent event = LoadEvent.values()[data[0] & 0xFF];
        this.logger.debug("load state control event for OI {}: {}", (Object)objectIndex, (Object)event);
        if (event == LoadEvent.NoOperation) {
            return ServiceResult.of(this.readProperty(remote, objectIndex, propertyId, startIndex, elements).result());
        }
        LoadState loadState = KnxDeviceServiceLogic.nextLoadState(event);
        this.ios.setProperty(objectIndex, propertyId, startIndex, elements, (byte)loadState.ordinal());
        return new ServiceResult<byte[]>(new byte[]{(byte)loadState.ordinal()});
    }

    @Override
    public ServiceResult<Description> readPropertyDescription(int objectIndex, int propertyId, int propertyIndex) {
        if (propertyId > 0) {
            return ServiceResult.of(this.ios.getDescription(objectIndex, propertyId));
        }
        return ServiceResult.of(this.ios.getDescriptionByIndex(objectIndex, propertyIndex));
    }

    @Override
    public ServiceResult<byte[]> functionPropertyCommand(Destination remote, int objectIndex, int propertyId, byte[] command) {
        int serviceId = command[1] & 0xFF;
        int objectType = this.ios.getInterfaceObjects()[objectIndex].getType();
        if (propertyId == 5) {
            return this.changeLoadState(remote, objectIndex, propertyId, 1, 1, command);
        }
        if (objectType == 6) {
            if (propertyId == 56) {
                boolean clearRoutingTable = true;
                int setRoutingTable = 2;
                int clearGroupAddresses = 3;
                int setGroupAddresses = 4;
                if (serviceId == 1) {
                    return new ServiceResult<byte[]>(new byte[]{0, 1});
                }
                if (serviceId == 2) {
                    return new ServiceResult<byte[]>(new byte[]{0, 2});
                }
                if (serviceId == 3) {
                    int startAddress = (command[2] & 0xFF) << 8 | command[3] & 0xFF;
                    int endAddress = (command[4] & 0xFF) << 8 | command[5] & 0xFF;
                    return new ServiceResult<byte[]>(new byte[]{0, 3, command[2], command[3], command[4], command[5]});
                }
                if (serviceId == 4) {
                    int startAddress = (command[2] & 0xFF) << 8 | command[3] & 0xFF;
                    int endAddress = (command[4] & 0xFF) << 8 | command[5] & 0xFF;
                    return new ServiceResult<byte[]>(new byte[]{0, 4, command[2], command[3], command[4], command[5]});
                }
            }
        } else if (objectType == 9) {
            int pidGODiagnostics = 66;
            if (propertyId == 66) {
                return this.writeGroupObjectDiagnostics(command, serviceId);
            }
        }
        return ServiceResult.error(ReturnCode.Error);
    }

    private ServiceResult<byte[]> writeGroupObjectDiagnostics(byte[] command, int serviceId) {
        this.logger.debug("GO diagnostics write service 0x{}", (Object)Integer.toHexString(serviceId));
        boolean setLocalGOValue = false;
        boolean sendGroupValueWrite = true;
        int sendLocalGOValueOnBus = 2;
        int sendGroupValueRead = 3;
        int limitGroupServiceSenders = 4;
        if (serviceId == 4) {
            return ServiceResult.error(ReturnCode.ImpossibleCommand);
        }
        ServiceResult<byte[]> dataVoidResult = ServiceResult.of(ReturnCode.DataVoid, (byte)serviceId);
        ServiceResult<byte[]> invalidCommandResult = ServiceResult.of(ReturnCode.InvalidCommand, (byte)serviceId);
        if (serviceId == 0) {
            int groupObjectNumber = (command[2] & 0xFF) << 8 | command[3] & 0xFF;
            byte[] data = Arrays.copyOfRange(command, 4, command.length);
            return invalidCommandResult;
        }
        if (serviceId == 1) {
            int flags = command[2] & 0xFF;
            if ((flags & 0x7F) > 3) {
                return dataVoidResult;
            }
            byte[] data = Arrays.copyOfRange(command, 5, command.length);
            if (data.length == 0) {
                return dataVoidResult;
            }
            boolean compactApdu = data.length == 1 && (data[0] & 0xFF) < 64 && (flags & 0x80) == 0;
            boolean auth = (flags & 1) != 0;
            boolean conf = (flags & 2) != 0;
            GroupAddress ga = new GroupAddress(Arrays.copyOfRange(command, 3, 5));
            Datapoint datapoint = this.datapoints.get(ga);
            if (datapoint == null) {
                return dataVoidResult;
            }
            SecurityControl secCtrl = SecurityControl.of((SecurityControl.DataSecurity)(conf ? SecurityControl.DataSecurity.AuthConf : (auth ? SecurityControl.DataSecurity.Auth : SecurityControl.DataSecurity.None)), (boolean)false);
            this.logger.debug("send group value write to {} ({})", (Object)ga, (Object)secCtrl);
            try {
                DPTXlator translator = TranslatorTypes.createTranslator((String)datapoint.getDPT(), (byte[])data);
                this.updateDatapointValue(datapoint, translator);
                this.sendGroupValue(ga, 128, compactApdu, data, datapoint.getPriority());
            }
            catch (KNXException e) {
                this.logger.warn("GO diagnostics sending group value write to {}", (Object)ga, (Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return new ServiceResult<byte[]>(new byte[]{(byte)serviceId});
        }
        if (serviceId == 2) {
            int groupObjectNumber = (command[2] & 0xFF) << 8 | command[3] & 0xFF;
            return invalidCommandResult;
        }
        if (serviceId == 3) {
            int flags = command[2] & 0xFF;
            if (flags > 3) {
                return dataVoidResult;
            }
            boolean auth = (flags & 1) != 0;
            boolean conf = (flags & 2) != 0;
            GroupAddress ga = new GroupAddress(Arrays.copyOfRange(command, 3, 5));
            Datapoint datapoint = this.datapoints.get(ga);
            if (datapoint == null) {
                return dataVoidResult;
            }
            SecurityControl secCtrl = SecurityControl.of((SecurityControl.DataSecurity)(conf ? SecurityControl.DataSecurity.AuthConf : (auth ? SecurityControl.DataSecurity.Auth : SecurityControl.DataSecurity.None)), (boolean)false);
            this.logger.info("send group value read to {} ({})", (Object)ga, (Object)secCtrl);
            try {
                this.sendGroupValue(ga, 0, true, new byte[0], datapoint.getPriority());
                DPTXlator translator = this.requestDatapointValue(datapoint);
                if (translator != null) {
                    boolean compactApdu = translator.getTypeSize() == 0;
                    this.sendGroupValue(ga, 64, compactApdu, translator.getData(), datapoint.getPriority());
                }
            }
            catch (KNXException e) {
                this.logger.warn("GO diagnostics sending group value read to {}", (Object)ga, (Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return new ServiceResult<byte[]>(new byte[]{(byte)serviceId});
        }
        return invalidCommandResult;
    }

    private void sendGroupValue(GroupAddress dst, int service, boolean compactApdu, byte[] data, Priority priority) throws KNXTimeoutException, KNXLinkClosedException, InterruptedException {
        byte[] plainApdu = compactApdu ? DataUnitBuilder.createLengthOptimizedAPDU((int)service, (byte[])data) : DataUnitBuilder.createAPDU((int)service, (byte[])data);
        DeviceSecureApplicationLayer sal = ((BaseKnxDevice)this.device).sal;
        byte[] apdu = sal.secureGroupObject(this.device.getAddress(), dst, plainApdu).orElse(plainApdu);
        KNXNetworkLink link = this.device.getDeviceLink();
        link.sendRequestWait((KNXAddress)dst, priority, apdu);
    }

    @Override
    public ServiceResult<byte[]> readFunctionPropertyState(Destination remote, int objectIndex, int propertyId, byte[] functionInput) {
        int serviceId = functionInput[1] & 0xFF;
        int objectType = this.ios.getInterfaceObjects()[objectIndex].getType();
        if (objectType == 9) {
            int pidGODiagnostics = 66;
            if (propertyId == 66) {
                return this.readGroupObjectDiagnostics(functionInput, serviceId);
            }
        }
        return ServiceResult.error(ReturnCode.InvalidCommand);
    }

    private ServiceResult<byte[]> readGroupObjectDiagnostics(byte[] functionInput, int serviceId) {
        this.logger.debug("GO diagnostics read service 0x{}", (Object)Integer.toHexString(serviceId));
        boolean getGOConfig = false;
        boolean getLocalGOValue = true;
        ServiceResult<byte[]> invalidCommandResult = ServiceResult.of(ReturnCode.InvalidCommand, (byte)serviceId);
        if (serviceId == 0) {
            int groupObjectNumber = (functionInput[2] & 0xFF) << 8 | functionInput[3] & 0xFF;
            return invalidCommandResult;
        }
        if (serviceId == 1) {
            int groupObjectNumber = (functionInput[2] & 0xFF) << 8 | functionInput[3] & 0xFF;
            return invalidCommandResult;
        }
        return invalidCommandResult;
    }

    @Override
    public ServiceResult<byte[]> readMemory(int startAddress, int bytes) {
        KnxDevice.Memory mem = this.device.deviceMemory();
        int size = mem.size();
        if (startAddress >= size) {
            return ServiceResult.error(ReturnCode.AddressVoid);
        }
        if (startAddress + bytes >= size) {
            return ServiceResult.error(ReturnCode.AccessDenied);
        }
        byte[] tableData = this.checkGroupAddressTableAccess(startAddress, bytes);
        return ServiceResult.of(tableData != null ? tableData : mem.get(startAddress, bytes));
    }

    private byte[] checkGroupAddressTableAccess(int startAddress, int bytes) {
        DeviceDescriptor.DD0 dd0 = DeviceObject.lookup(this.ios).deviceDescriptor();
        if (dd0 == DeviceDescriptor.DD0.TYPE_0300) {
            return null;
        }
        int addrTableLoc = dd0 == DeviceDescriptor.DD0.TYPE_5705 ? 16384 : 278;
        boolean systemB = dd0 == DeviceDescriptor.DD0.TYPE_07B0 || dd0 == DeviceDescriptor.DD0.TYPE_17B0 || dd0 == DeviceDescriptor.DD0.TYPE_27B0 || dd0 == DeviceDescriptor.DD0.TYPE_57B0;
        int lengthSize = systemB ? 2 : 1;
        int maxGroupAddrTableSize = lengthSize + 510;
        if (startAddress < addrTableLoc || startAddress >= addrTableLoc + maxGroupAddrTableSize) {
            return null;
        }
        long tableSize = KnxDeviceServiceLogic.unsigned(this.device.deviceMemory().get(addrTableLoc, lengthSize));
        if (tableSize != 0L) {
            return null;
        }
        Collection c = ((DatapointMap)this.datapoints).getDatapoints();
        boolean storeDeviceAddr = !systemB;
        int from = startAddress - addrTableLoc;
        int entries = c.size() + (storeDeviceAddr ? 1 : 0);
        int groupAddrTableSize = lengthSize + entries * 2;
        if (from >= groupAddrTableSize) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(groupAddrTableSize);
        if (systemB) {
            bb.putShort((short)entries);
        } else {
            bb.put((byte)entries);
            bb.put(this.device.getAddress().toByteArray());
        }
        TreeSet<Datapoint> set = new TreeSet<Datapoint>(Comparator.comparing(Datapoint::getMainAddress));
        set.addAll(c);
        set.forEach(dp -> bb.put(dp.getMainAddress().toByteArray()));
        return Arrays.copyOfRange(bb.array(), from, from + bytes);
    }

    @Override
    public ServiceResult<Void> writeMemory(int startAddress, byte[] data) {
        DeviceDescriptor dd;
        int size = this.device.deviceMemory().size();
        if (startAddress >= size) {
            return ServiceResult.error(ReturnCode.AddressVoid);
        }
        if (startAddress + data.length >= size) {
            return ServiceResult.error(ReturnCode.MemoryError);
        }
        if (BimM112.isMgmtControl(startAddress) && ((dd = this.readDescriptor(0).result()) == DeviceDescriptor.DD0.TYPE_0700 || dd == DeviceDescriptor.DD0.TYPE_0701)) {
            BimM112.onLoadEvent(this, data);
            return new ServiceResult<Void>();
        }
        if (startAddress == 96 && data.length == 1) {
            this.setProgrammingMode(data[0] == 1);
        } else {
            this.device.deviceMemory().set(startAddress, data);
        }
        return ServiceResult.empty();
    }

    @Override
    public ServiceResult<Boolean> readAddress() {
        return ServiceResult.of(this.inProgrammingMode());
    }

    @Override
    public ServiceResult<Boolean> readAddressSerial(SerialNumber serialNo) {
        SerialNumber myserial = DeviceObject.lookup(this.ios).serialNumber();
        return ServiceResult.of(myserial.equals((Object)serialNo));
    }

    @Override
    public void writeAddress(IndividualAddress newAddress) {
        if (this.inProgrammingMode()) {
            this.setDeviceAddress(newAddress);
        }
    }

    @Override
    public void writeAddressSerial(SerialNumber serialNo, IndividualAddress newAddress) {
        SerialNumber myserial = DeviceObject.lookup(this.ios).serialNumber();
        if (myserial.equals((Object)serialNo)) {
            this.setDeviceAddress(newAddress);
        }
    }

    private void setDeviceAddress(IndividualAddress newAddress) {
        IndividualAddress old = this.device.getAddress();
        KNXMediumSettings settings = this.device.getDeviceLink().getKNXMedium();
        settings.setDeviceAddress(newAddress);
        if (this.device instanceof BaseKnxDevice) {
            ((BaseKnxDevice)this.device).setAddress(newAddress);
        }
        this.logger.info("set new device address {} (old {})", (Object)newAddress, (Object)old);
    }

    @Override
    public ServiceResult<Boolean> readDomainAddress() {
        return ServiceResult.of(this.inProgrammingMode());
    }

    @Override
    public ServiceResult<Boolean> readDomainAddress(byte[] domain, IndividualAddress startAddress, int range) {
        int start;
        int raw;
        byte[] domainAddress = this.domainAddress();
        if (Arrays.equals(domain, domainAddress) && (raw = this.device.getAddress().getRawAddress()) >= (start = startAddress.getRawAddress()) && raw <= start + range) {
            int wait = (raw - start) * this.device.getDeviceLink().getKNXMedium().timeFactor();
            this.logger.trace("read domain address: wait " + wait + " ms before sending response");
            try {
                Thread.sleep(wait);
                return ServiceResult.of(true);
            }
            catch (InterruptedException e) {
                this.logger.warn("read domain address got interrupted, response is canceled");
                Thread.currentThread().interrupt();
            }
        }
        return ServiceResult.of(false);
    }

    @Override
    public ServiceResult<Boolean> readDomainAddress(byte[] startDoA, byte[] endDoA) {
        long start = KnxDeviceServiceLogic.unsigned(startDoA);
        long end = KnxDeviceServiceLogic.unsigned(endDoA);
        byte[] domainAddress = this.domainAddress();
        long our = KnxDeviceServiceLogic.unsigned(domainAddress);
        if (our >= start && our <= end && this.randomWait("read domain address", 2001)) {
            return ServiceResult.of(true);
        }
        return ServiceResult.of(false);
    }

    @Override
    public void writeDomainAddress(byte[] domain) {
        if (this.inProgrammingMode()) {
            KNXMediumSettings settings = this.device.getDeviceLink().getKNXMedium();
            if (domain.length == 2) {
                ((PLSettings)settings).setDomainAddress(domain);
            } else {
                ((RFSettings)settings).setDomainAddress(domain);
            }
            this.setDomainAddress(domain);
        }
    }

    private void setDomainAddress(byte[] domain) {
        try {
            DeviceObject.lookup(this.ios).setDomainAddress(domain);
        }
        catch (KnxPropertyException e) {
            this.logger.warn("setting DoA {} in interface object server", (Object)DataUnitBuilder.toHex((byte[])domain, (String)" "), (Object)e);
        }
    }

    private byte[] domainAddress() {
        try {
            return DeviceObject.lookup(this.ios).domainAddress(this.domainType());
        }
        catch (KnxPropertyException e) {
            this.logger.warn("reading DoA", (Throwable)((Object)e));
            return new byte[0];
        }
    }

    private boolean domainType() {
        KNXMediumSettings settings = this.device.getDeviceLink().getKNXMedium();
        if (settings instanceof PLSettings) {
            return false;
        }
        if (settings instanceof RFSettings) {
            return true;
        }
        throw new KnxPropertyException(settings + " does not have domain");
    }

    @Override
    public ServiceResult<byte[]> readParameter(int objectType, int pid, byte[] info) {
        if (objectType == 0 && pid == 11) {
            int operand = info[0] & 0xFF;
            int maxWaitSeconds = 0;
            if (operand == 1 && this.inProgrammingMode()) {
                maxWaitSeconds = 1;
            } else if (operand == 2 && this.device.getAddress().getDevice() == 255 && (Arrays.equals(new byte[]{0, -1}, this.domainAddress()) || Arrays.equals(new byte[6], this.domainAddress()))) {
                maxWaitSeconds = info[1] & 0xFF;
            } else if (operand == 3) {
                if (this.ignoreReadSNByPowerReset || this.startTime.plus(Duration.ofMinutes(4L)).isBefore(Instant.now())) {
                    return new ServiceResult<byte[]>();
                }
                maxWaitSeconds = info[1] & 0xFF;
                boolean bl = this.ignoreReadSNByPowerReset = maxWaitSeconds < 255;
            }
            if (maxWaitSeconds == 255) {
                return new ServiceResult<byte[]>();
            }
            if (maxWaitSeconds > 0) {
                this.randomWait("read parameter - serial number", maxWaitSeconds * 1000);
                SerialNumber sn = DeviceObject.lookup(this.ios).serialNumber();
                return ServiceResult.of(sn.array());
            }
        }
        return ServiceResult.empty();
    }

    private boolean randomWait(String svc, int maxWaitMillis) {
        int wait = (int)(Math.random() * (double)maxWaitMillis);
        this.logger.trace("{}: add random wait of {} ms before response", (Object)svc, (Object)wait);
        try {
            Thread.sleep(wait);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public ServiceResult<DeviceDescriptor> readDescriptor(int type) {
        if (type == 0) {
            return ServiceResult.of(DeviceObject.lookup(this.ios).deviceDescriptor());
        }
        throw new KnxRuntimeException("cannot provide DD2");
    }

    @Override
    public ServiceResult<Integer> readADC(int channel, int consecutiveReads) {
        int peiType = 10;
        int adcValue = Math.max(0, (1280 * consecutiveReads - 60) / 10);
        return ServiceResult.of(adcValue);
    }

    @Override
    public ServiceResult<Integer> writeAuthKey(Destination remote, int accessLevel, byte[] key) {
        if (accessLevel >= this.minAccessLevel) {
            return ServiceResult.of(this.minAccessLevel);
        }
        if (this.accessLevel(remote) > accessLevel) {
            return ServiceResult.of(255);
        }
        this.authKeys[accessLevel] = key;
        return ServiceResult.of(accessLevel);
    }

    @Override
    public ServiceResult<Integer> authorize(Destination remote, byte[] key) {
        int currentLevel = this.maximumAccessLevel(key);
        this.setAccessLevel(remote, currentLevel);
        return ServiceResult.of(currentLevel);
    }

    @Override
    public ServiceResult<Duration> restart(boolean masterReset, ManagementClient.EraseCode eraseCode, int channel) {
        Object type = masterReset ? "master reset (" + eraseCode + ")" : "basic restart";
        this.logger.info("received request for {}", type);
        this.setProgrammingMode(false);
        this.syncDatapoints();
        if (masterReset) {
            if (eraseCode.ordinal() > 1) {
                int pidDownloadCounter = 30;
                try {
                    double counter = this.ios.getPropertyTranslated(0, 30, 1, 1).getNumericValue();
                    double inc = Math.min(65535.0, counter + 1.0);
                    this.ios.setProperty(0, 30, 1, 1, ByteBuffer.allocate(2).putShort((short)inc).array());
                }
                catch (KNXException | KnxPropertyException e) {
                    ((Throwable)e).printStackTrace();
                }
            }
            if (eraseCode == ManagementClient.EraseCode.FactoryReset || eraseCode == ManagementClient.EraseCode.FactoryResetWithoutIndividualAddress) {
                int accessLevel = this.accessLevel(null);
                this.resetAuthKeys(accessLevel);
            }
            Duration processTime = Duration.ofSeconds(3L);
            return ServiceResult.of(processTime);
        }
        return null;
    }

    private void resetAuthKeys(int maxAccessLevel) {
        for (int i = maxAccessLevel; i < 16; ++i) {
            this.authKeys[i] = defaultAuthKey;
        }
    }

    @Override
    public ServiceResult<byte[]> management(int svcType, byte[] asdu, KNXAddress dst, Destination respondTo, TransportLayer tl) {
        this.logger.info("{}->{} {} {}", new Object[]{respondTo.getAddress(), dst, DataUnitBuilder.decodeAPCI((int)svcType), DataUnitBuilder.toHex((byte[])asdu, (String)" ")});
        return null;
    }

    @Override
    public boolean isVerifyModeEnabled() {
        return this.verifyMode;
    }

    private void syncDatapoints() {
        this.syncTableWithMemory(1);
        this.syncTableWithMemory(2);
        this.syncTableWithMemory(9);
        byte[] table = this.ios.getProperty(1, 1, 23, 1, Integer.MAX_VALUE);
        ByteBuffer buffer = ByteBuffer.wrap(table);
        while (buffer.hasRemaining()) {
            GroupAddress group = new GroupAddress(buffer.getShort() & 0xFFFF);
            if (this.datapoints.contains(group)) continue;
            try {
                Optional<Object[]> optFlags = this.groupAddressIndex(group).flatMap(this::groupObjectIndex).map(groupObjectIndex -> this.ios.getProperty(9, 1, 23, (int)groupObjectIndex, 1)).map(KnxDeviceServiceLogic::groupObjectDescriptor);
                if (optFlags.isEmpty()) continue;
                Object[] flags = optFlags.get();
                TranslatorTypes.MainType mainType = (TranslatorTypes.MainType)TranslatorTypes.ofBitSize((int)((Integer)flags[0])).get(0);
                String dpt = (String)mainType.getSubTypes().keySet().iterator().next();
                StateDP dp = new StateDP(group, group.toString(), mainType.getMainNumber(), dpt);
                dp.setPriority((Priority)flags[1]);
                this.datapoints.add((Datapoint)dp);
            }
            catch (KNXException | KnxPropertyException e) {
                ((Throwable)e).printStackTrace();
            }
        }
    }

    private void syncTableWithMemory(int objectType) {
        DeviceDescriptor.DD0 dd0 = DeviceObject.lookup(this.ios).deviceDescriptor();
        if (dd0 == DeviceDescriptor.DD0.TYPE_0300) {
            return;
        }
        boolean objectInstance = true;
        int ref = (int)KnxDeviceServiceLogic.unsigned(this.ios.getProperty(objectType, 1, 7, 1, 1));
        boolean systemB = dd0 == DeviceDescriptor.DD0.TYPE_07B0 || dd0 == DeviceDescriptor.DD0.TYPE_17B0 || dd0 == DeviceDescriptor.DD0.TYPE_27B0 || dd0 == DeviceDescriptor.DD0.TYPE_57B0;
        int lengthSize = systemB ? 2 : 1;
        int tableEntries = (int)KnxDeviceServiceLogic.unsigned(this.device.deviceMemory().get(ref, lengthSize));
        if (tableEntries > 0) {
            int idx = (int)KnxDeviceServiceLogic.unsigned(this.ios.getProperty(objectType, 1, 29, 1, 1));
            Description description = this.ios.getDescription(idx, 23);
            int max = tableEntries;
            this.ios.setDescription(new Description(idx, 0, 23, 0, 0, true, 0, max, 3, 3), true);
            int typeSize = PropertyTypes.bitSize((int)description.getPDT()).orElse(16) / 8;
            byte[] data = this.device.deviceMemory().get(ref + lengthSize, tableEntries * typeSize);
            this.ios.setProperty(objectType, 1, 23, 1, tableEntries, data);
        }
    }

    private Optional<Integer> groupAddressIndex(GroupAddress address) {
        return KnxDeviceServiceLogic.groupAddressIndex(this.ios, address);
    }

    static Optional<Integer> groupAddressIndex(InterfaceObjectServer ios, GroupAddress address) {
        byte[] addresses = ios.getProperty(1, 1, 23, 1, Integer.MAX_VALUE);
        byte[] addr = address.toByteArray();
        int entrySize = addr.length;
        for (int offset = 0; offset < addresses.length; offset += entrySize) {
            if (!Arrays.equals(addr, 0, addr.length, addresses, offset, offset + 2)) continue;
            return Optional.of(offset / entrySize + 1);
        }
        return Optional.empty();
    }

    private Optional<Integer> groupObjectIndex(int groupAddressIndex) {
        return KnxDeviceServiceLogic.groupObjectIndex(this.ios, groupAddressIndex);
    }

    static Optional<Integer> groupObjectIndex(InterfaceObjectServer ios, int groupAddressIndex) {
        byte[] assoc = ios.getProperty(2, 1, 23, 1, Integer.MAX_VALUE);
        ByteBuffer buffer = ByteBuffer.wrap(assoc);
        while (buffer.hasRemaining()) {
            if ((buffer.getShort() & 0xFFFF) == groupAddressIndex) {
                return Optional.of(buffer.getShort() & 0xFFFF);
            }
            buffer.getShort();
        }
        return Optional.empty();
    }

    private static Object[] groupObjectDescriptor(byte[] descriptor) {
        int flags = descriptor[0] & 0xFF;
        int priority = flags & 3;
        boolean enable = (flags & 4) != 0;
        boolean responder = enable && (flags & 8) != 0;
        boolean update = (flags & 0x80) != 0;
        int bitsize = KnxDeviceServiceLogic.valueFieldTypeToBits(descriptor[1] & 0xFF);
        return new Object[]{bitsize, Priority.get((int)priority), responder, update};
    }

    static byte[] groupObjectDescriptor(String dpt, Priority p, boolean responder, boolean update) {
        int enableFlag = 4;
        int respondFlag = responder ? 8 : 0;
        int updateFlag = update ? 128 : 0;
        int bitsize = 1;
        try {
            bitsize = TranslatorTypes.createTranslator((String)dpt, (byte[])new byte[0]).bitSize();
        }
        catch (KNXException e) {
            e.printStackTrace();
        }
        return new byte[]{(byte)(updateFlag | respondFlag | 4 | p.value), (byte)KnxDeviceServiceLogic.bitsToValueFieldType(bitsize)};
    }

    private static int valueFieldTypeToBits(int code) {
        int[] lowerFieldTypes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 16, 24, 32, 48, 64, 80, 112, 40, 56, 72, 88, 96, 104};
        if (code < lowerFieldTypes.length) {
            return lowerFieldTypes[code];
        }
        if (code == 255) {
            return 2016;
        }
        return (code - 6) * 8;
    }

    private static int bitsToValueFieldType(int bitsize) {
        if (bitsize < 9) {
            return bitsize - 1;
        }
        int bytes = bitsize / 8;
        switch (bytes) {
            case 2: {
                return 8;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 10;
            }
            case 6: {
                return 11;
            }
            case 8: {
                return 12;
            }
            case 10: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 252: {
                return 255;
            }
        }
        return bytes + 6;
    }

    void destinationDisconnected(Destination remote) {
        Integer level = this.accessLevels.remove(remote);
        if (level != null) {
            this.logger.info("endpoint {} disconnected, reset access level {} to {}", new Object[]{remote.getAddress(), level, this.minAccessLevel});
        }
    }

    protected int accessLevel(Destination remote) {
        int freeLevel = this.maximumAccessLevel(defaultAuthKey);
        return this.accessLevels.getOrDefault(remote, freeLevel);
    }

    private int maximumAccessLevel(byte[] key) {
        for (int i = 0; i < this.authKeys.length; ++i) {
            if (!Arrays.equals(key, this.authKeys[i])) continue;
            return i;
        }
        return this.minAccessLevel;
    }

    private void setAccessLevel(Destination remote, int accessLevel) {
        this.accessLevels.put(remote, accessLevel);
        this.logger.info("authorize {} for access level {}", (Object)remote.getAddress(), (Object)accessLevel);
    }

    private static long unsigned(byte[] data) {
        long v = 0L;
        for (byte b : data) {
            v = (v << 8) + (long)(b & 0xFF);
        }
        return v;
    }

    static enum LoadEvent {
        NoOperation,
        StartLoading,
        LoadCompleted,
        AdditionalLoadControls,
        Unload;

    }

    public static enum LoadState {
        Unloaded,
        Loaded,
        Loading,
        Error,
        Unloading,
        LoadCompleting;

    }

    private static class BimM112 {
        private static final int MgmtControl = 260;
        private static final int RunControl = 259;
        private static final int LsAddressTable = 46826;
        private static final int LsAssociationTable = 46827;
        private static final int LsApplicationTable = 46828;
        private static final int LsPeiProgram = 46829;
        private static final int RsAppProgram = 257;
        private static final int RsPeiProgram = 258;

        private BimM112() {
        }

        static boolean isMgmtControl(int startAddress) {
            return startAddress == 260;
        }

        private static int loadStateAddress(int stateMachineIndex) {
            switch (stateMachineIndex) {
                case 1: {
                    return 46826;
                }
                case 2: {
                    return 46827;
                }
                case 3: {
                    return 46828;
                }
                case 4: {
                    return 46829;
                }
            }
            return 0;
        }

        static void onLoadEvent(KnxDeviceServiceLogic logic, byte[] data) {
            int stateMachineAndEvent = data[0] & 0xFF;
            int stateMachine = stateMachineAndEvent >> 4;
            int addr = BimM112.loadStateAddress(stateMachine);
            LoadEvent event = LoadEvent.values()[stateMachineAndEvent & 0xF];
            LoadState state = KnxDeviceServiceLogic.nextLoadState(event);
            logic.logger.debug("state machine {} (0x{}) event {} -> load state {}", new Object[]{stateMachine, Integer.toHexString(addr), event, state});
            logic.writeMemory(addr, new byte[]{(byte)state.ordinal()});
        }
    }
}

