/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator2ByteFloat;
import tuwien.auto.calimero.dptxlator.DPTXlator3BitControlled;
import tuwien.auto.calimero.dptxlator.DPTXlator4ByteFloat;
import tuwien.auto.calimero.dptxlator.DPTXlator8BitUnsigned;
import tuwien.auto.calimero.dptxlator.DPTXlatorBoolean;
import tuwien.auto.calimero.dptxlator.DPTXlatorString;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.process.ProcessCommunication;
import tuwien.auto.calimero.process.ProcessListener;
import tuwien.auto.calimero.secure.SecureApplicationLayer;

public class ProcessCommunicationResponder
implements ProcessCommunication {
    private static final int GROUP_RESPONSE = 64;
    private final KNXNetworkLink lnk;
    private final SecureApplicationLayer sal;
    private final EventListeners<ProcessListener> listeners;
    private volatile Priority priority = Priority.LOW;
    private volatile boolean detached;
    private final Logger logger;

    public ProcessCommunicationResponder(KNXNetworkLink link, SecureApplicationLayer sal) throws KNXLinkClosedException {
        if (!link.isOpen()) {
            throw new KNXLinkClosedException("cannot initialize process communication using closed link " + link.getName());
        }
        this.lnk = link;
        this.sal = sal;
        this.logger = LogService.getLogger((String)("calimero.device.communication " + link.getName()));
        this.listeners = new EventListeners(this.logger);
    }

    public void setPriority(Priority p) {
        this.priority = p;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void addProcessListener(ProcessListener l) {
        this.listeners.add((Object)l);
    }

    public void removeProcessListener(ProcessListener l) {
        this.listeners.remove((Object)l);
    }

    public void write(GroupAddress dst, boolean value) throws KNXTimeoutException, KNXLinkClosedException {
        try {
            DPTXlatorBoolean t = new DPTXlatorBoolean(DPTXlatorBoolean.DPT_BOOL);
            t.setValue(value);
            this.write(dst, this.priority, (DPTXlator)t);
        }
        catch (KNXFormatException kNXFormatException) {
            // empty catch block
        }
    }

    public void write(GroupAddress dst, int value, String scale) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        DPTXlator8BitUnsigned t = new DPTXlator8BitUnsigned(scale);
        t.setValue(value);
        this.write(dst, this.priority, (DPTXlator)t);
    }

    public void write(GroupAddress dst, boolean control, int stepcode) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        DPTXlator3BitControlled t = new DPTXlator3BitControlled(DPTXlator3BitControlled.DPT_CONTROL_DIMMING);
        t.setValue(control, stepcode);
        this.write(dst, this.priority, (DPTXlator)t);
    }

    public void write(GroupAddress dst, double value, boolean use4ByteFloat) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        if (use4ByteFloat) {
            DPTXlator4ByteFloat t = new DPTXlator4ByteFloat(DPTXlator4ByteFloat.DPT_TEMPERATURE_DIFFERENCE);
            t.setValue((float)value);
            this.write(dst, this.priority, (DPTXlator)t);
        } else {
            DPTXlator2ByteFloat t = new DPTXlator2ByteFloat(DPTXlator2ByteFloat.DPT_RAIN_AMOUNT);
            t.setValue(value);
            this.write(dst, this.priority, (DPTXlator)t);
        }
    }

    public void write(GroupAddress dst, String value) throws KNXTimeoutException, KNXFormatException, KNXLinkClosedException {
        DPTXlatorString t = new DPTXlatorString(DPTXlatorString.DPT_STRING_8859_1);
        t.setValue(value);
        this.write(dst, this.priority, (DPTXlator)t);
    }

    public void write(GroupAddress dst, byte[] asdu, boolean lengthOptimizedApdu) throws KNXTimeoutException, KNXLinkClosedException {
        if (this.detached) {
            throw new IllegalStateException("process communicator detached");
        }
        byte[] buf = lengthOptimizedApdu ? DataUnitBuilder.createLengthOptimizedAPDU((int)64, (byte[])asdu) : DataUnitBuilder.createAPDU((int)64, (byte[])asdu);
        this.send(dst, this.priority, buf);
    }

    public void write(GroupAddress dst, DPTXlator value) throws KNXException {
        this.write(dst, this.priority, value);
    }

    public void write(Datapoint dp, String value) throws KNXException {
        DPTXlator t = TranslatorTypes.createTranslator((int)dp.getMainNumber(), (String)dp.getDPT());
        t.setValue(value);
        this.write(dp.getMainAddress(), dp.getPriority(), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KNXNetworkLink detach() {
        ProcessCommunicationResponder processCommunicationResponder = this;
        synchronized (processCommunicationResponder) {
            if (this.detached) {
                return null;
            }
            this.detached = true;
        }
        this.fireDetached();
        this.logger.debug("detached from " + this.lnk.getName());
        return this.lnk;
    }

    private void write(GroupAddress dst, Priority p, DPTXlator t) throws KNXTimeoutException, KNXLinkClosedException {
        if (this.detached) {
            throw new IllegalStateException("process communicator detached");
        }
        byte[] plainApdu = ProcessCommunicationResponder.createGroupAPDU(64, t);
        this.send(dst, p, plainApdu);
    }

    private void send(GroupAddress dst, Priority p, byte[] plainApdu) throws KNXTimeoutException, KNXLinkClosedException {
        IndividualAddress src = this.lnk.getKNXMedium().getDeviceAddress();
        try {
            byte[] apdu = this.sal.secureGroupObject(src, dst, plainApdu).orElse(plainApdu);
            this.lnk.sendRequest((KNXAddress)dst, p, apdu);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void fireDetached() {
        DetachEvent e = new DetachEvent((Object)this);
        this.listeners.fire(l -> l.detached(e));
    }

    private static byte[] createGroupAPDU(int service, DPTXlator t) {
        if (service == 0) {
            return new byte[2];
        }
        if (service != 64 && service != 128) {
            throw new KNXIllegalArgumentException("not an APDU group service");
        }
        int offset = t.getItems() == 1 && t.getTypeSize() == 0 ? 1 : 2;
        byte[] buf = new byte[t.getItems() * Math.max(1, t.getTypeSize()) + offset];
        buf[0] = (byte)(service >> 8);
        buf[1] = (byte)service;
        return t.getData(buf, offset);
    }
}

