/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.util.EventObject;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.device.BaseKnxDevice;
import tuwien.auto.calimero.device.ProcessCommunicationResponder;
import tuwien.auto.calimero.device.ProcessCommunicationService;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.process.ProcessCommunicator;
import tuwien.auto.calimero.process.ProcessCommunicatorImpl;
import tuwien.auto.calimero.process.ProcessEvent;
import tuwien.auto.calimero.process.ProcessListener;
import tuwien.auto.calimero.secure.SecureApplicationLayer;

final class ProcessServiceNotifier
implements ProcessListener,
AutoCloseable {
    static final int GROUP_READ = 0;
    static final int GROUP_RESPONSE = 64;
    static final int GROUP_WRITE = 128;
    private final BaseKnxDevice device;
    private final ProcessCommunicationService svc;
    private final ProcessCommunicator recv;
    private final ProcessCommunicationResponder res;

    ProcessServiceNotifier(BaseKnxDevice device, ProcessCommunicationService service) throws KNXLinkClosedException {
        if (device.getDeviceLink() == null) {
            throw new NullPointerException("KNX device network link is required");
        }
        this.device = device;
        this.svc = service;
        this.recv = new ProcessCommunicatorImpl(device.getDeviceLink(), (SecureApplicationLayer)device.sal);
        this.res = new ProcessCommunicationResponder(device.getDeviceLink(), (SecureApplicationLayer)device.sal);
        this.recv.addProcessListener((ProcessListener)this);
    }

    public void groupReadRequest(ProcessEvent e) {
        this.device.dispatch((EventObject)e, () -> this.svc.groupReadRequest(e), this::respond);
    }

    public void groupReadResponse(ProcessEvent e) {
        this.device.dispatch((EventObject)e, () -> {
            this.svc.groupResponse(e);
            return null;
        }, this::respond);
    }

    public void groupWrite(ProcessEvent e) {
        this.device.dispatch((EventObject)e, () -> {
            this.svc.groupWrite(e);
            return null;
        }, this::respond);
    }

    public void detached(DetachEvent e) {
    }

    void respond(EventObject event, ServiceResult<byte[]> sr) {
        if (sr.result() != null) {
            GroupAddress to = ((ProcessEvent)event).getDestination();
            try {
                this.res.setPriority(sr.getPriority());
                this.res.write(to, sr.result(), sr.compact);
            }
            catch (KNXTimeoutException | KNXLinkClosedException e) {
                this.device.logger().error("responding to {}: {}", new Object[]{to, DataUnitBuilder.toHex((byte[])sr.result(), (String)" "), e});
            }
        } else {
            sr.run();
        }
    }

    @Override
    public void close() {
        this.recv.close();
        this.res.close();
    }
}

