/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device.ios;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.device.ios.InterfaceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.mgmt.PropertyClient;

public final class DeviceObject
extends InterfaceObject {
    private static final int pidDownloadCounter = 30;
    private static final int pidRFDomainAddress = 82;

    public static DeviceObject lookup(InterfaceObjectServer ios) {
        return (DeviceObject)ios.lookup(0, 1);
    }

    DeviceObject(int objectType, int index, Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions) {
        super(objectType, index, definitions);
    }

    public DeviceDescriptor.DD0 deviceDescriptor() {
        return DeviceDescriptor.DD0.from((byte[])this.get(83));
    }

    public IndividualAddress deviceAddress() {
        return new IndividualAddress(new byte[]{this.get(57)[0], this.get(58)[0]});
    }

    public void setDeviceAddress(IndividualAddress address) {
        byte[] addr = address.toByteArray();
        this.set(57, addr[0]);
        this.set(58, addr[1]);
    }

    public String description() {
        byte[] bytes = this.getProperty(21, 1, Integer.MAX_VALUE);
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }

    public boolean programmingMode() {
        return (this.get(54)[0] & 1) == 1;
    }

    public int maxApduLength() {
        return (int)DeviceObject.unsigned(this.get(56));
    }

    public SerialNumber serialNumber() {
        return SerialNumber.from((byte[])this.get(11));
    }

    public byte[] domainAddress(boolean rfMedium) {
        return this.get(rfMedium ? 82 : 70);
    }

    public void setDomainAddress(byte[] domain) {
        this.set(domain.length == 6 ? 82 : 70, domain);
    }

    public long downloadCounter() {
        return DeviceObject.unsigned(this.get(30));
    }

    private byte[] get(int pid) {
        return this.getProperty(pid, 1, 1);
    }

    public void set(int pid, byte ... data) {
        this.setProperty(pid, 1, 1, data, false);
    }

    private static long unsigned(byte[] data) {
        long l = 0L;
        for (byte b : data) {
            l = (l << 8) + (long)(b & 0xFF);
        }
        return l;
    }
}

