/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device.ios;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.Settings;
import tuwien.auto.calimero.device.ios.DeviceObject;
import tuwien.auto.calimero.device.ios.InterfaceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServerListener;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.device.ios.PropertyEvent;
import tuwien.auto.calimero.device.ios.SecurityObject;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.PropertyAccess;
import tuwien.auto.calimero.mgmt.PropertyAdapter;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlInputFactory;
import tuwien.auto.calimero.xml.XmlOutputFactory;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlWriter;

public class InterfaceObjectServer
implements PropertyAccess {
    private final Logger logger = LogService.getLogger((String)"calimero.device.Interface Object Server");
    private IosResourceHandler rh;
    private final List<InterfaceObject> objects = new ArrayList<InterfaceObject>();
    private final IosAdapter adapter = new IosAdapter();
    private final PropertyClient client;
    private final boolean strictMode;
    private final EventListeners<InterfaceObjectServerListener> listeners = new EventListeners(this.logger);

    public InterfaceObjectServer(boolean strictPropertyMode) {
        this.strictMode = strictPropertyMode;
        try {
            this.client = new PropertyClient((PropertyAdapter)this.adapter);
        }
        catch (KNXFormatException e) {
            throw new KNXIllegalArgumentException("cannot create property client", (Throwable)e);
        }
        try {
            String propertyDefinitions = "/properties.xml";
            URL resource = this.getClass().getResource("/properties.xml");
            if (resource != null) {
                this.loadDefinitions(resource.toString());
            }
        }
        catch (UncheckedIOException | KNXException | KNXMLException e) {
            this.logger.info("could not load the Interface Object Server KNX property definitions ({})", (Object)e.getMessage());
        }
        this.addInterfaceObject(0);
    }

    public synchronized void setResourceHandler(IosResourceHandler handler) {
        this.rh = handler;
    }

    public void loadDefinitions(String resource) throws KNXException {
        PropertyClient.XmlPropertyDefinitions handler = new PropertyClient.XmlPropertyDefinitions();
        this.client.addDefinitions(handler.load(resource));
    }

    public Map<PropertyClient.PropertyKey, PropertyClient.Property> propertyDefinitions() {
        return this.client.getDefinitions();
    }

    public void loadInterfaceObjects(String resource) throws KNXException {
        this.load(resource);
    }

    public void loadInterfaceObjects(InputStream is) throws KNXException {
        this.load(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Object o) throws KNXException {
        IosResourceHandler h;
        InterfaceObjectServer interfaceObjectServer = this;
        synchronized (interfaceObjectServer) {
            if (this.rh == null) {
                this.setResourceHandler(new XmlSerializer(this.logger, this.client.getDefinitions()));
            }
            h = this.rh;
        }
        Collection<InterfaceObject> list = o instanceof String ? h.loadInterfaceObjects((String)o) : h.loadInterfaceObjects((InputStream)o);
        for (InterfaceObject io : list) {
            List<InterfaceObject> list2 = this.objects;
            synchronized (list2) {
                int index = this.objects.size();
                io.setIndex(index);
                this.objects.add(io);
            }
            this.initIoProperties(io, false);
        }
        this.updateIoList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInterfaceObjects(String resource) throws KNXException {
        IosResourceHandler h;
        InterfaceObjectServer interfaceObjectServer = this;
        synchronized (interfaceObjectServer) {
            if (this.rh == null) {
                this.setResourceHandler(new XmlSerializer(this.logger, this.client.getDefinitions()));
            }
            h = this.rh;
        }
        InterfaceObject[] objects = this.getInterfaceObjects();
        h.saveInterfaceObjects(resource, Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInterfaceObjects(OutputStream os) throws KNXException {
        IosResourceHandler h;
        InterfaceObjectServer interfaceObjectServer = this;
        synchronized (interfaceObjectServer) {
            if (this.rh == null) {
                this.setResourceHandler(new XmlSerializer(this.logger, this.client.getDefinitions()));
            }
            h = this.rh;
        }
        InterfaceObject[] objects = this.getInterfaceObjects();
        h.saveInterfaceObjects(os, Arrays.asList(objects));
    }

    public <T extends InterfaceObject> T lookup(int objectType, int objectInstance) throws KnxPropertyException {
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            int inst = 0;
            for (InterfaceObject io : this.objects) {
                if (io.getType() != objectType || ++inst != objectInstance) continue;
                return (T)io;
            }
            Object ot = PropertyClient.getObjectTypeName((int)objectType);
            if (((String)ot).isEmpty()) {
                ot = "object type " + objectType;
            }
            throw new KnxPropertyException("no object instance " + objectInstance + " of " + (String)ot + " in IOS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceObject[] getInterfaceObjects() {
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            return this.objects.toArray(new InterfaceObject[this.objects.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceObject addInterfaceObject(int objectType) {
        InterfaceObject io;
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            int index = this.objects.size();
            io = InterfaceObjectServer.newInterfaceObject(objectType, index, this.client.getDefinitions());
            this.objects.add(io);
            this.updateIoList();
        }
        this.initIoProperties(io, true);
        if (objectType == 0) {
            this.adapter.createNewDescription(0, 71, false);
        }
        if (io instanceof SecurityObject) {
            ((SecurityObject)io).populateWithDefaults();
        }
        return io;
    }

    private static InterfaceObject newInterfaceObject(int objectType, int index, Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions) {
        if (objectType == 0) {
            return new DeviceObject(objectType, index, definitions);
        }
        if (objectType == 17) {
            return new SecurityObject(objectType, index, definitions);
        }
        return new InterfaceObject(objectType, index, definitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterfaceObject(InterfaceObject io) {
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            this.objects.remove(io);
        }
    }

    public void addServerListener(InterfaceObjectServerListener l) {
        this.listeners.add((Object)l);
    }

    public void removeServerListener(InterfaceObjectServerListener l) {
        this.listeners.remove((Object)l);
    }

    public byte[] getProperty(int objectIndex, int propertyId, int start, int elements) throws KnxPropertyException {
        return this.adapter.getProperty(objectIndex, propertyId, start, elements);
    }

    public void setProperty(int objectIndex, int propertyId, int start, int elements, byte ... data) throws KnxPropertyException {
        this.adapter.setProperty(objectIndex, propertyId, start, elements, data);
    }

    public void setProperty(int objectType, int objectInstance, int propertyId, int start, int elements, byte ... data) throws KnxPropertyException {
        this.adapter.setProperty(objectType, objectInstance, propertyId, start, elements, data);
    }

    public byte[] getProperty(int objectType, int objectInstance, int propertyId, int start, int elements) throws KnxPropertyException {
        return this.adapter.getProperty(objectType, objectInstance, propertyId, start, elements);
    }

    public void setProperty(int objIndex, int propertyId, int position, String value) throws KNXException {
        try {
            this.client.setProperty(objIndex, propertyId, position, value);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("IOS adapter does not throw InterruptedException", e);
        }
    }

    public DPTXlator getPropertyTranslated(int objIndex, int pid, int start, int elements) throws KNXException {
        try {
            return this.client.getPropertyTranslated(objIndex, pid, start, elements);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("IOS adapter does not throw InterruptedException", e);
        }
    }

    public void setDescription(Description d, boolean allowCorrections) {
        InterfaceObject io = this.getIfObject(d.getObjectIndex());
        io.setDescription(d, allowCorrections);
    }

    public Description getDescription(int objIndex, int pid) throws KnxPropertyException {
        try {
            return this.client.getDescription(objIndex, pid);
        }
        catch (KNXException e) {
            KnxPropertyException pe = new KnxPropertyException(e.getMessage());
            pe.setStackTrace(e.getStackTrace());
            throw pe;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("IOS adapter does not throw InterruptedException", e);
        }
    }

    public Description getDescriptionByIndex(int objIndex, int propIndex) throws KnxPropertyException {
        try {
            return this.client.getDescriptionByIndex(objIndex, propIndex);
        }
        catch (KNXException e) {
            KnxPropertyException pe = new KnxPropertyException(e.getMessage());
            pe.setStackTrace(e.getStackTrace());
            throw pe;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("IOS adapter does not throw InterruptedException", e);
        }
    }

    public String toString() {
        return this.objects.toString();
    }

    private void updateIoList() {
        InterfaceObject io = this.objects.get(0);
        if (io == null || io.getType() != 0) {
            throw new IllegalStateException("IOS is missing mandatory device object");
        }
        int items = this.objects.size();
        ByteBuffer buffer = ByteBuffer.allocate(2 + items * 2).putShort((short)items);
        for (InterfaceObject interfaceObject : this.objects) {
            buffer.putShort((short)interfaceObject.getType());
        }
        this.objects.get((int)0).values.put(new PropertyClient.PropertyKey(0, 71), buffer.array());
    }

    void initIoProperties(InterfaceObject io, boolean createDescription) {
        int objectType = io.getType();
        int index = io.getIndex();
        io.values.put(new PropertyClient.PropertyKey(objectType, 1), new byte[]{0, 1, (byte)(objectType >> 8), (byte)objectType});
        if (createDescription) {
            this.adapter.createNewDescription(index, 1, false);
        }
        byte[] name = io.getTypeName().getBytes(Charset.forName("ISO-8859-1"));
        byte[] value = ByteBuffer.allocate(2 + name.length).put((byte)0).put((byte)name.length).put(name).array();
        io.values.put(new PropertyClient.PropertyKey(objectType, 2), value);
        if (createDescription) {
            this.adapter.createNewDescription(index, 2, false);
        }
        io.values.put(new PropertyClient.PropertyKey(objectType, 29), new byte[]{0, 1, (byte)index});
        if (createDescription) {
            this.adapter.createNewDescription(index, 29, false);
        }
    }

    private void firePropertyChanged(InterfaceObject io, int propertyId, int start, int elements, byte[] data) {
        PropertyEvent pe = new PropertyEvent(this, io, propertyId, start, elements, data);
        this.listeners.fire(l -> l.onPropertyValueChanged(pe));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterfaceObject getIfObject(int objIndex) {
        List<InterfaceObject> list = this.objects;
        synchronized (list) {
            for (InterfaceObject io : this.objects) {
                if (io.getIndex() != objIndex) continue;
                return io;
            }
        }
        throw new KNXIllegalArgumentException("interface object index " + objIndex + " past last interface object");
    }

    private final class IosAdapter
    implements PropertyAdapter {
        private IosAdapter() {
        }

        public void setProperty(int objIndex, int pid, int start, int elements, byte ... data) throws KnxPropertyException {
            this.setProperty(InterfaceObjectServer.this.getIfObject(objIndex), pid, start, elements, data);
        }

        public void setProperty(int objectType, int objectInstance, int propertyId, int start, int elements, byte ... data) throws KnxPropertyException {
            this.setProperty((InterfaceObject)InterfaceObjectServer.this.lookup(objectType, objectInstance), propertyId, start, elements, data);
        }

        public byte[] getProperty(int objIndex, int pid, int start, int elements) throws KnxPropertyException {
            return this.getProperty(InterfaceObjectServer.this.getIfObject(objIndex), pid, start, elements);
        }

        public byte[] getProperty(int objectType, int objectInstance, int propertyId, int start, int elements) throws KnxPropertyException {
            return this.getProperty((InterfaceObject)InterfaceObjectServer.this.lookup(objectType, objectInstance), propertyId, start, elements);
        }

        public byte[] getDescription(int objIndex, int pid, int propIndex) throws KnxPropertyException {
            InterfaceObject io = InterfaceObjectServer.this.getIfObject(objIndex);
            return io.getDescription(pid, propIndex);
        }

        public String getName() {
            return "Calimero IOS adapter";
        }

        public boolean isOpen() {
            return true;
        }

        public void close() {
        }

        private void setProperty(InterfaceObject io, int pid, int start, int elements, byte[] data) throws KnxPropertyException {
            boolean changed = io.setProperty(pid, start, elements, data, InterfaceObjectServer.this.strictMode);
            if (changed) {
                InterfaceObjectServer.this.firePropertyChanged(io, pid, start, elements, data);
            }
        }

        private byte[] getProperty(InterfaceObject io, int pid, int start, int elements) throws KnxPropertyException {
            return io.getProperty(pid, start, elements);
        }

        private void createNewDescription(int objIndex, int pid, boolean writeEnabled) {
            InterfaceObject io = InterfaceObjectServer.this.getIfObject(objIndex);
            io.createNewDescription(pid, writeEnabled);
        }
    }

    public static interface IosResourceHandler {
        public Collection<InterfaceObject> loadInterfaceObjects(String var1) throws KNXException;

        public Collection<InterfaceObject> loadInterfaceObjects(InputStream var1) throws KNXException;

        public void saveInterfaceObjects(String var1, Collection<InterfaceObject> var2) throws KNXException;

        public void saveInterfaceObjects(OutputStream var1, Collection<InterfaceObject> var2) throws KNXException;

        public void loadProperties(String var1, Collection<Description> var2, Collection<byte[]> var3) throws KNXException;

        public void loadProperties(Collection<Description> var1, Collection<byte[]> var2) throws KNXException;

        public void saveProperties(String var1, Collection<Description> var2, Collection<byte[]> var3) throws KNXException;

        public void saveProperties(Collection<Description> var1, Collection<byte[]> var2) throws KNXException;
    }

    private static class XmlSerializer
    implements IosResourceHandler {
        private static final String TAG_IOS = "interfaceObjects";
        private static final String TAG_OBJECT = "object";
        private static final String ATTR_OBJECTTYPE = "type";
        private static final String TAG_PROPERTY = "property";
        private static final String ATTR_PID = "pid";
        private static final String ATTR_INDEX = "index";
        private static final String ATTR_PDT = "pdt";
        private static final String ATTR_RW = "rw";
        private static final String ATTR_WRITE = "writeEnabled";
        private static final String ATTR_MAXELEMS = "maxElements";
        private static final String TAG_DATA = "data";
        private XmlReader r;
        private XmlWriter w;
        private final Logger logger;
        private final Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions;

        XmlSerializer(Logger l, Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions) {
            this.logger = l;
            this.definitions = definitions;
        }

        @Override
        public Collection<InterfaceObject> loadInterfaceObjects(String resource) throws KNXException {
            Collection<InterfaceObject> collection;
            block8: {
                XmlReader reader = XmlInputFactory.newInstance().createXMLReader(resource);
                try {
                    collection = this.load(reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NumberFormatException e) {
                        throw new KNXFormatException("loading interface objects", e.getMessage());
                    }
                }
                reader.close();
            }
            return collection;
        }

        @Override
        public Collection<InterfaceObject> loadInterfaceObjects(InputStream is) throws KNXException {
            Collection<InterfaceObject> collection;
            block8: {
                XmlReader reader = XmlInputFactory.newInstance().createXMLStreamReader(is);
                try {
                    collection = this.load(reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NumberFormatException e) {
                        throw new KNXFormatException("loading interface objects", e.getMessage());
                    }
                }
                reader.close();
            }
            return collection;
        }

        private Collection<InterfaceObject> load(XmlReader reader) throws KNXException {
            this.r = reader;
            if (reader.nextTag() != 1 || !this.r.getLocalName().equals(TAG_IOS)) {
                throw new KNXMLException("no interface objects");
            }
            ArrayList<InterfaceObject> list = new ArrayList<InterfaceObject>();
            while (this.r.next() != 8) {
                if (this.r.getEventType() == 1) {
                    if (!this.r.getLocalName().equals(TAG_OBJECT)) continue;
                    int type = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_OBJECTTYPE));
                    int index = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_INDEX));
                    InterfaceObject io = InterfaceObjectServer.newInterfaceObject(type, index, this.definitions);
                    list.add(io);
                    io.load(this);
                    continue;
                }
                if (this.r.getEventType() != 2 || !this.r.getLocalName().equals(TAG_IOS)) continue;
                break;
            }
            return list;
        }

        @Override
        public void saveInterfaceObjects(String resource, Collection<InterfaceObject> objects) throws KNXException {
            try (XmlWriter writer = XmlOutputFactory.newInstance().createXMLWriter(resource);){
                this.save(objects, writer);
            }
        }

        @Override
        public void saveInterfaceObjects(OutputStream os, Collection<InterfaceObject> ifObjects) throws KNXException {
            try (XmlWriter writer = XmlOutputFactory.newInstance().createXMLStreamWriter(os);){
                this.save(ifObjects, writer);
            }
        }

        private void save(Collection<InterfaceObject> objects, XmlWriter writer) throws KNXException {
            this.w = writer;
            writer.writeStartDocument("UTF-8", "1.0");
            this.w.writeComment("Calimero v" + Settings.getLibraryVersion() + " interface objects, saved on " + ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
            this.w.writeStartElement(TAG_IOS);
            for (InterfaceObject io : objects) {
                this.w.writeStartElement(TAG_OBJECT);
                this.w.writeAttribute(ATTR_OBJECTTYPE, Integer.toString(io.getType()));
                this.w.writeAttribute(ATTR_INDEX, Integer.toString(io.getIndex()));
                io.save(this);
                this.w.writeEndElement();
            }
            this.w.writeEndDocument();
        }

        @Override
        public void loadProperties(String resource, Collection<Description> descriptions, Collection<byte[]> values) throws KNXException {
            this.loadProperties(descriptions, values);
        }

        @Override
        public void loadProperties(Collection<Description> descriptions, Collection<byte[]> values) throws KNXException {
            try {
                int type = 0;
                int oi = 0;
                if (this.r.getLocalName().equals(TAG_OBJECT)) {
                    type = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_OBJECTTYPE));
                    oi = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_INDEX));
                }
                boolean valueExpected = false;
                int index = 0;
                Description currentDesc = null;
                while (this.r.next() != 8) {
                    if (this.r.getEventType() == 1) {
                        if (this.r.getLocalName().equals(TAG_PROPERTY)) {
                            int maxElems = XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_MAXELEMS));
                            int[] rw = XmlSerializer.parseRW(this.r.getAttributeValue(null, ATTR_RW));
                            Description d = new Description(oi, type, XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_PID)), index, XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_PDT)), XmlSerializer.toInt(this.r.getAttributeValue(null, ATTR_WRITE)) == 1, 0, maxElems, rw[0], rw[1]);
                            descriptions.add(d);
                            ++index;
                            if (valueExpected) {
                                values.add(new byte[2]);
                                this.logger.trace("{}: 0000", (Object)currentDesc);
                            }
                            valueExpected = true;
                            currentDesc = d;
                            continue;
                        }
                        if (!this.r.getLocalName().equals(TAG_DATA)) continue;
                        Object s = this.r.getElementText();
                        if (((String)s).length() % 2 != 0) {
                            s = "0" + (String)s;
                        }
                        this.logger.trace("{}: {}", currentDesc, s);
                        byte[] data = DataUnitBuilder.fromHex((String)s);
                        values.add(data.length == 0 ? new byte[2] : data);
                        valueExpected = false;
                        continue;
                    }
                    if (this.r.getEventType() != 2 || !this.r.getLocalName().equals(TAG_OBJECT)) continue;
                    break;
                }
            }
            catch (NumberFormatException e) {
                throw new KNXFormatException("loading properties", e.getMessage());
            }
        }

        @Override
        public void saveProperties(String resource, Collection<Description> descriptions, Collection<byte[]> values) {
            this.saveProperties(descriptions, values);
        }

        @Override
        public void saveProperties(Collection<Description> descriptions, Collection<byte[]> values) {
            if (values.size() < descriptions.size()) {
                throw new KNXIllegalArgumentException("values size " + values.size() + " less than descriptions size " + descriptions.size());
            }
            Iterator<byte[]> k = values.iterator();
            for (Description d : descriptions) {
                byte[] data = k.next();
                this.w.writeStartElement(TAG_PROPERTY);
                this.w.writeAttribute(ATTR_PID, Integer.toString(d.getPID()));
                this.w.writeAttribute(ATTR_PDT, d.getPDT() == -1 ? "<tbd>" : Integer.toString(d.getPDT()));
                this.w.writeAttribute(ATTR_MAXELEMS, Integer.toString(d.getMaxElements()));
                this.w.writeAttribute(ATTR_RW, Integer.toString(d.getReadLevel()) + "/" + d.getWriteLevel());
                this.w.writeAttribute(ATTR_WRITE, d.isWriteEnabled() ? "1" : "0");
                this.writeData(data);
                this.w.writeEndElement();
            }
            while (k.hasNext()) {
                byte[] data = k.next();
                this.w.writeStartElement(TAG_PROPERTY);
                this.writeData(data);
                this.w.writeEndElement();
            }
        }

        private void writeData(byte[] data) {
            if (data.length == 0) {
                this.w.writeEmptyElement(TAG_DATA);
            } else {
                this.w.writeStartElement(TAG_DATA);
                this.w.writeCharacters(DataUnitBuilder.toHex((byte[])data, (String)""));
                this.w.writeEndElement();
            }
        }

        private static int[] parseRW(String rw) {
            String s = rw.toLowerCase();
            int read = 0;
            int write = 0;
            boolean slash = false;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '/') {
                    slash = true;
                    continue;
                }
                if (c < '0' || c > '9') continue;
                if (slash) {
                    write = write * 10 + c - 48;
                    continue;
                }
                read = read * 10 + c - 48;
            }
            return new int[]{read, write};
        }

        private static int toInt(String s) throws NumberFormatException {
            if (s != null) {
                if (s.equals("<tbd>")) {
                    return -1;
                }
                return s.length() == 0 ? 0 : Integer.decode(s);
            }
            throw new NumberFormatException("no integer number: " + s);
        }
    }
}

