/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device.ios;

import java.util.Map;
import tuwien.auto.calimero.device.KnxDeviceServiceLogic;
import tuwien.auto.calimero.device.ios.InterfaceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.PropertyClient;

public final class SecurityObject
extends InterfaceObject {
    public static SecurityObject lookup(InterfaceObjectServer ios) {
        return (SecurityObject)ios.lookup(17, 1);
    }

    SecurityObject(int objectType, int index, Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions) {
        super(objectType, index, definitions);
    }

    public boolean isLoaded() {
        int state = this.get(5)[0] & 0xFF;
        return KnxDeviceServiceLogic.LoadState.values()[state] == KnxDeviceServiceLogic.LoadState.Loaded;
    }

    public byte[] get(int pid) {
        return this.get(pid, 1, Integer.MAX_VALUE);
    }

    public byte[] get(int pid, int start, int elements) {
        return this.getProperty(pid, start, elements);
    }

    public void set(int pid, byte ... data) {
        this.set(pid, 1, 1, data);
    }

    public void set(int pid, int start, int elements, byte ... data) {
        boolean strictMode = false;
        this.setProperty(pid, start, elements, data, false);
    }

    public void populateWithDefaults() {
        this.set(5, (byte)KnxDeviceServiceLogic.LoadState.Loaded.ordinal());
        this.set(51, 0);
        int objIndex = this.getIndex();
        this.setDescription(new Description(objIndex, 17, 52, 0, 0, true, 0, 50, 3, 3), true);
        this.setDescription(new Description(objIndex, 17, 53, 0, 0, true, 0, 50, 3, 3), true);
        this.setDescription(new Description(objIndex, 17, 54, 0, 0, true, 0, 500, 3, 3), true);
        this.set(55, 1, 1, new byte[8]);
        byte[] toolkey = new byte[16];
        this.set(56, toolkey);
        this.set(57, 0);
        this.set(58, 1);
        this.set(59, 0, 0, 0, 0, 0, 1);
        int goFlags = 4000;
        this.set(61, 1, 4000, new byte[4000]);
        this.setDescription(new Description(objIndex, 17, 61, 0, 0, true, 0, 4000, 3, 3), true);
        this.set(62, 1, 0, new byte[0]);
    }

    public static interface Pid {
        public static final int LoadStateControl = 5;
        public static final int SecurityMode = 51;
        public static final int P2PKeyTable = 52;
        public static final int GroupKeyTable = 53;
        public static final int SecurityIndividualAddressTable = 54;
        public static final int SecurityFailuresLog = 55;
        public static final int ToolKey = 56;
        public static final int SecurityReport = 57;
        public static final int SecurityReportControl = 58;
        public static final int SequenceNumberSending = 59;
        public static final int ZoneKeyTable = 60;
        public static final int GoSecurityFlags = 61;
        public static final int RoleTable = 62;
        public static final int ToolSequenceNumberSending = 250;
    }
}

